/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.ClientCertificateIssuerType;
import com.pingidentity.admin.api.model.oauth.ClientMetadata;
import com.pingidentity.admin.api.model.oauth.ClientRegistrationOIDCPolicy;
import com.pingidentity.admin.api.model.oauth.ClientSettings;
import com.pingidentity.admin.api.model.oauth.DeviceFlowSettingType;
import com.pingidentity.admin.api.model.oauth.DynamicClientRegistration;
import com.pingidentity.admin.api.model.oauth.LockoutMaxMaliciousActionsType;
import com.pingidentity.admin.api.model.oauth.OfflineAccessRequireConsentPromptType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshRollingType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingGracePeriodType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalTimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalType;
import com.pingidentity.admin.api.model.oauth.RequireOfflineAccessScopeToIssueRefreshTokensType;
import com.pingidentity.admin.api.model.oauth.SigningAlgorithm;
import com.pingidentity.crypto.Cert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class ClientSettingsTranslator {
    private static final OpenIdConnectProviderPolicyManager oidcPolicyMgr = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
    private static final TrustedCAsManager trustedCasManager = MgmtFactory.getTrustedCAsManager();
    public static final String POLICIES_PATH = "/policies";

    public ClientSettings domainToApi(ClientSetting domain) {
        ClientSettings api = new ClientSettings();
        ArrayList<ClientMetadata> clientMetadataList = new ArrayList<ClientMetadata>();
        domain.getExtendedMetadataParams().forEach((key, value) -> {
            ClientMetadata clientMetadata = new ClientMetadata();
            clientMetadata.setParameter((String)key);
            clientMetadata.setDescription(value.getParamDescription());
            clientMetadata.setMultiValued(value.isMultiValued());
            clientMetadataList.add(clientMetadata);
        });
        api.setClientMetadata(clientMetadataList);
        if (domain.isEnableDynamicClientRegistration()) {
            LockoutMaxMaliciousActionsType apiLockoutMaxMaliciousActionsType;
            String offlineAccessRequireConsentPrompt;
            OfflineAccessRequireConsentPromptType offlineAccessRequireConsentPromptType;
            String tokenExchangeProcessorPolicyId;
            DynamicClientRegistration apiDynamicClientReg = new DynamicClientRegistration();
            if (domain.isRequireInitialAccessToken()) {
                apiDynamicClientReg.setInitialAccessTokenScope(domain.getInitialAccessTokenScope());
            }
            apiDynamicClientReg.setRestrictCommonScopes(domain.isRestrictCommonScopes());
            ArrayList<String> commonScopes = new ArrayList<String>(domain.getRestrictedCommonScopes());
            Collections.sort(commonScopes);
            apiDynamicClientReg.setRestrictedCommonScopes(commonScopes);
            ArrayList<String> exclusiveScopes = new ArrayList<String>(domain.getAllowedExclusiveScopes());
            Collections.sort(exclusiveScopes);
            apiDynamicClientReg.setAllowedExclusiveScopes(exclusiveScopes);
            ArrayList<String> authorizationDetailTypes = new ArrayList<String>(domain.getAllowedAuthorizationDetailTypes());
            Collections.sort(authorizationDetailTypes);
            apiDynamicClientReg.setAllowedAuthorizationDetailTypes(authorizationDetailTypes);
            apiDynamicClientReg.setEnforceReplayPrevention(domain.isEnforceReplayPrevention());
            apiDynamicClientReg.setRequireSignedRequests(domain.isRequireSignedRequests());
            if (StringUtils.isNotEmpty((String)domain.getDefaultAccessTokenManagerId())) {
                ResourceLink defaultAtmRef = new ResourceLink(domain.getDefaultAccessTokenManagerId(), ApiUtil.getResourceUrl("/oauth/accessTokenManagers", domain.getDefaultAccessTokenManagerId()));
                apiDynamicClientReg.setDefaultAccessTokenManagerRef(defaultAtmRef);
            }
            apiDynamicClientReg.setRestrictToDefaultAccessTokenManager(domain.isRestrictToDefaultAccessTokenManager());
            PersistentGrantLifetimeType apiPersistentGrantExpirationSettingType = PersistentGrantLifetimeType.getType(domain.getPersistentGrantExpirationType());
            apiDynamicClientReg.setPersistentGrantExpirationType(apiPersistentGrantExpirationSettingType);
            if ("OVERRIDE_SERVER_DEFAULT".equals(domain.getPersistentGrantExpirationType())) {
                apiDynamicClientReg.setPersistentGrantExpirationTime(domain.getPersistentGrantExpirationTime());
                PersistentGrantLifetimeUnit apiPersistentGrantExpirationTimeUnit = PersistentGrantLifetimeUnit.getType(domain.getPersistentGrantExpirationTimeUnit());
                apiDynamicClientReg.setPersistentGrantExpirationTimeUnit(apiPersistentGrantExpirationTimeUnit);
            }
            PersistentGrantLifetimeType apiPersistentGrantIdleTimeoutSettingType = PersistentGrantLifetimeType.getType(domain.getPersistentGrantIdleTimeoutType());
            apiDynamicClientReg.setPersistentGrantIdleTimeoutType(apiPersistentGrantIdleTimeoutSettingType);
            if ("OVERRIDE_SERVER_DEFAULT".equals(domain.getPersistentGrantIdleTimeoutType())) {
                apiDynamicClientReg.setPersistentGrantIdleTimeout(domain.getPersistentGrantIdleTimeout());
                PersistentGrantLifetimeUnit apiPersistentGrantIdleTimeoutTimeUnit = PersistentGrantLifetimeUnit.getType(domain.getPersistentGrantIdleTimeoutTimeUnit());
                apiDynamicClientReg.setPersistentGrantIdleTimeoutTimeUnit(apiPersistentGrantIdleTimeoutTimeUnit);
            }
            RefreshRollingType apiRollingType = RefreshRollingType.getType(domain.getRefreshRolling());
            apiDynamicClientReg.setRefreshRolling(apiRollingType);
            apiDynamicClientReg.setRefreshTokenRollingInterval(domain.getRefreshTokenRollingInterval());
            if (domain.getRefreshTokenRollingInterval() != null) {
                String refreshTokenRollingIntervalTimeUnit = domain.getRefreshTokenRollingIntervalTimeUnit() == null ? "h" : domain.getRefreshTokenRollingIntervalTimeUnit();
                apiDynamicClientReg.setRefreshTokenRollingIntervalTimeUnit(RefreshTokenRollingIntervalTimeUnit.getType(refreshTokenRollingIntervalTimeUnit));
            }
            if (domain.getRefreshTokenRollingInterval() == null) {
                apiDynamicClientReg.setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType.SERVER_DEFAULT);
            } else if (domain.getRefreshTokenRollingIntervalType() == null) {
                apiDynamicClientReg.setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType.getType("OVERRIDE_SERVER_DEFAULT"));
            } else {
                apiDynamicClientReg.setRefreshTokenRollingIntervalType(RefreshTokenRollingIntervalType.getType(domain.getRefreshTokenRollingIntervalType()));
            }
            if (StringUtils.isNotEmpty((String)domain.getClientCertIssuerDn())) {
                String issuerDn = domain.getClientCertIssuerDn();
                if ("Trust Any".equals(issuerDn)) {
                    apiDynamicClientReg.setClientCertIssuerType(ClientCertificateIssuerType.TRUST_ANY);
                } else {
                    apiDynamicClientReg.setClientCertIssuerType(ClientCertificateIssuerType.CERTIFICATE);
                    apiDynamicClientReg.setClientCertIssuerRef(this.getClientCertIssuerDnResourceLink(issuerDn));
                }
            } else {
                apiDynamicClientReg.setClientCertIssuerType(ClientCertificateIssuerType.NONE);
            }
            if (oidcPolicyMgr.getPolicy().isEnabled()) {
                SigningAlgorithm algo = SigningAlgorithm.getType(domain.getIdTokenSigningAlgorithm());
                ClientRegistrationOIDCPolicy policy = new ClientRegistrationOIDCPolicy();
                policy.setIdTokenSigningAlgorithm(algo);
                ResourceLink link = this.getPolicyResourceLink(domain);
                policy.setPolicyGroup(link);
                if (policy.getIdTokenSigningAlgorithm() != null || policy.getPolicyGroup() != null) {
                    apiDynamicClientReg.setOidcPolicy(policy);
                }
            }
            ArrayList<ResourceLink> policies = new ArrayList<ResourceLink>();
            for (String id : domain.getPolicyPlugins()) {
                ResourceLink link = new ResourceLink(id, ApiUtil.getResourceUrl("/oauth/clientRegistrationPolicies", id));
                policies.add(link);
            }
            apiDynamicClientReg.setPolicyRefs(policies);
            DeviceFlowSettingType deviceFlowSetting = DeviceFlowSettingType.getType(domain.getDeviceFlowSettingType());
            apiDynamicClientReg.setDeviceFlowSettingType(deviceFlowSetting);
            apiDynamicClientReg.setUserAuthorizationUrlOverride(domain.getUserAuthzUrlOverride());
            apiDynamicClientReg.setPendingAuthorizationTimeoutOverride(domain.getPendingAuthzTimeoutOverride());
            apiDynamicClientReg.setDevicePollingIntervalOverride(domain.getDevicePollingIntervalOverride());
            apiDynamicClientReg.setBypassActivationCodeConfirmationOverride(domain.getBypassActivationCodeConfirmationOverride());
            apiDynamicClientReg.setRequireProofKeyForCodeExchange(domain.isRequireProofKeyForCodeExchange());
            apiDynamicClientReg.setCibaPollingInterval(domain.getCibaPollingInterval());
            apiDynamicClientReg.setCibaRequireSignedRequests(domain.isCibaRequireSignedRequests());
            if (StringUtils.isNotBlank((String)domain.getCibaPolicyId())) {
                String href = ApiUtil.getResourceUrl("/oauth/cibaServerPolicy", domain.getCibaPolicyId());
                ResourceLink cibaPolicy = new ResourceLink(domain.getCibaPolicyId(), href);
                apiDynamicClientReg.setRequestPolicyRef(cibaPolicy);
            }
            if (StringUtils.isNotBlank((String)(tokenExchangeProcessorPolicyId = domain.getTokenExchangeProcessorPolicyId()))) {
                String href = ApiUtil.getResourceUrl("/oauth/tokenExchange/processor/policies", tokenExchangeProcessorPolicyId);
                apiDynamicClientReg.setTokenExchangeProcessorPolicyRef(new ResourceLink(tokenExchangeProcessorPolicyId, href));
            }
            RefreshTokenRollingGracePeriodType refreshTokenRollingGracePeriodType = RefreshTokenRollingGracePeriodType.getType(domain.getRefreshTokenRollingGracePeriodType());
            apiDynamicClientReg.setRefreshTokenRollingGracePeriodType(refreshTokenRollingGracePeriodType);
            apiDynamicClientReg.setRefreshTokenRollingGracePeriod(domain.getRefreshTokenRollingGracePeriod());
            String requireOfflineAccessScopeToIssueRefreshTokens = domain.getRequireOfflineAccessScopeToIssueRefreshTokens();
            RequireOfflineAccessScopeToIssueRefreshTokensType requireOfflineAccessScopeToIssueRefreshTokensType = RequireOfflineAccessScopeToIssueRefreshTokensType.getType(requireOfflineAccessScopeToIssueRefreshTokens);
            if (requireOfflineAccessScopeToIssueRefreshTokensType != null) {
                apiDynamicClientReg.setRequireOfflineAccessScopeToIssueRefreshTokens(requireOfflineAccessScopeToIssueRefreshTokensType);
            }
            if ((offlineAccessRequireConsentPromptType = OfflineAccessRequireConsentPromptType.getType(offlineAccessRequireConsentPrompt = domain.getOfflineAccessRequireConsentPrompt())) != null) {
                apiDynamicClientReg.setOfflineAccessRequireConsentPrompt(offlineAccessRequireConsentPromptType);
            }
            apiDynamicClientReg.setRequireJwtSecuredAuthorizationResponseMode(domain.getRequireJwtSecuredAuthorizationResponseMode());
            if (domain.isEnableDynamicClientRegistrationManagement()) {
                apiDynamicClientReg.setRotateClientSecret(domain.isRotateClientSecret());
                apiDynamicClientReg.setRotateRegistrationAccessToken(domain.isRotateRegistrationAccessToken());
                apiDynamicClientReg.setAllowClientDelete(domain.isAllowClientDelete());
                apiDynamicClientReg.setDisableRegistrationAccessTokens(domain.isDisableRegistrationAccessTokens() ? Boolean.valueOf(true) : null);
                apiDynamicClientReg.setRetainClientSecret(domain.isRetainClientSecret());
                if (domain.isRetainClientSecret()) {
                    apiDynamicClientReg.setClientSecretRetentionPeriodType(domain.getClientSecretRetentionPeriodType());
                    if ("OVERRIDE_SERVER_DEFAULT".equals(domain.getClientSecretRetentionPeriodType())) {
                        apiDynamicClientReg.setClientSecretRetentionPeriodOverride(domain.getClientSecretRetentionPeriod());
                    }
                }
            }
            if ((apiLockoutMaxMaliciousActionsType = LockoutMaxMaliciousActionsType.getType(domain.getLockoutMaxMaliciousActionsType())) != null) {
                apiDynamicClientReg.setLockoutMaxMaliciousActionsType(apiLockoutMaxMaliciousActionsType);
            }
            if ("OVERRIDE_SERVER_DEFAULT".equals(domain.getLockoutMaxMaliciousActionsType())) {
                apiDynamicClientReg.setLockoutMaxMaliciousActions(domain.getLockoutMaxMaliciousActions());
            }
            api.setDynamicClientRegistration(apiDynamicClientReg);
        }
        return api;
    }

    public ClientSetting apiToDomain(ClientSettings api) {
        ClientSetting domain = new ClientSetting();
        List<ClientMetadata> clientMetadataList = api.getClientMetadata();
        LinkedHashMap<String, ClientParam> params = new LinkedHashMap<String, ClientParam>();
        if (clientMetadataList != null) {
            for (ClientMetadata clientMetadata : clientMetadataList) {
                ClientParam clientParam = new ClientParam(clientMetadata.getDescription(), clientMetadata.isMultiValued());
                params.put(clientMetadata.getParameter(), clientParam);
            }
        }
        domain.setExtendedMetadataParams(params);
        if (api.getDynamicClientRegistration() != null) {
            DynamicClientRegistration dClientReg = api.getDynamicClientRegistration();
            domain.setEnableDynamicClientRegistration(true);
            if (dClientReg.getInitialAccessTokenScope() != null) {
                domain.setRequireInitialAccessToken(true);
                domain.setInitialAccessTokenScope(dClientReg.getInitialAccessTokenScope());
            }
            domain.setRestrictCommonScopes(dClientReg.isRestrictCommonScopes());
            domain.setRestrictedCommonScopes(new HashSet<String>(dClientReg.getRestrictedCommonScopes()));
            if (dClientReg.getAllowedExclusiveScopes() != null) {
                domain.setAllowedExclusiveScopes(new HashSet<String>(dClientReg.getAllowedExclusiveScopes()));
            }
            if (dClientReg.getAllowedAuthorizationDetailTypes() != null) {
                domain.setAllowedAuthorizationDetailTypes(new HashSet<String>(dClientReg.getAllowedAuthorizationDetailTypes()));
            }
            domain.setEnforceReplayPrevention(dClientReg.isEnforceReplayPrevention());
            domain.setRequireSignedRequests(dClientReg.isRequireSignedRequests());
            if (dClientReg.getDefaultAccessTokenManagerRef() != null) {
                domain.setDefaultAccessTokenManagerId(dClientReg.getDefaultAccessTokenManagerRef().getId());
            }
            domain.setRestrictToDefaultAccessTokenManager(dClientReg.isRestrictToDefaultAccessTokenManager());
            domain.setPersistentGrantExpirationType(dClientReg.getPersistentGrantExpirationType().getId());
            if (PersistentGrantLifetimeType.OVERRIDE_SERVER_DEFAULT == dClientReg.getPersistentGrantExpirationType()) {
                Long time = dClientReg.getPersistentGrantExpirationTime();
                domain.setPersistentGrantExpirationTime(time);
                domain.setPersistentGrantExpirationTimeUnit(dClientReg.getPersistentGrantExpirationTimeUnit().getId());
            }
            domain.setPersistentGrantIdleTimeoutType(dClientReg.getPersistentGrantIdleTimeoutType().getId());
            if (PersistentGrantLifetimeType.OVERRIDE_SERVER_DEFAULT.equals((Object)dClientReg.getPersistentGrantIdleTimeoutType())) {
                Long idleTimeout = dClientReg.getPersistentGrantIdleTimeout();
                domain.setPersistentGrantIdleTimeout(idleTimeout);
                domain.setPersistentGrantIdleTimeoutTimeUnit(dClientReg.getPersistentGrantIdleTimeoutTimeUnit().getId());
            }
            if (ClientCertificateIssuerType.TRUST_ANY == dClientReg.getClientCertIssuerType()) {
                domain.setClientCertIssuerDn("Trust Any");
            } else if (ClientCertificateIssuerType.CERTIFICATE == dClientReg.getClientCertIssuerType()) {
                Cert cert = trustedCasManager.getCert(dClientReg.getClientCertIssuerRef().getId());
                String dn = cert.getX509Certificate().getSubjectDN().getName();
                domain.setClientCertIssuerDn(dn);
            }
            domain.setRefreshRolling(dClientReg.getRefreshRolling().getId());
            domain.setRefreshTokenRollingInterval(dClientReg.getRefreshTokenRollingInterval());
            if (dClientReg.getRefreshTokenRollingInterval() != null) {
                RefreshTokenRollingIntervalTimeUnit refreshTokenRollingIntervalTimeUnit = dClientReg.getRefreshTokenRollingIntervalTimeUnit() == null ? RefreshTokenRollingIntervalTimeUnit.HOURS : dClientReg.getRefreshTokenRollingIntervalTimeUnit();
                domain.setRefreshTokenRollingIntervalTimeUnit(refreshTokenRollingIntervalTimeUnit.getId());
            }
            if (dClientReg.getRefreshTokenRollingIntervalType() != null) {
                domain.setRefreshTokenRollingIntervalType(dClientReg.getRefreshTokenRollingIntervalType().getId());
            }
            if (dClientReg.getOidcPolicy() != null) {
                ClientRegistrationOIDCPolicy oidcPolicy = dClientReg.getOidcPolicy();
                if (oidcPolicy.getIdTokenSigningAlgorithm() != null) {
                    domain.setIdTokenSigningAlgorithm(oidcPolicy.getIdTokenSigningAlgorithm().getId());
                }
                if (oidcPolicy.getPolicyGroup() != null) {
                    domain.setPolicyGroupId(oidcPolicy.getPolicyGroup().getId());
                }
            }
            List policyPluginIds = dClientReg.getPolicyRefs().stream().map(ResourceLink::getId).collect(Collectors.toList());
            domain.setPolicyPlugins(policyPluginIds);
            domain.setDeviceFlowSettingType(dClientReg.getDeviceFlowSettingType().getId());
            domain.setUserAuthzUrlOverride(dClientReg.getUserAuthorizationUrlOverride());
            domain.setPendingAuthzTimeoutOverride(dClientReg.getPendingAuthorizationTimeoutOverride());
            domain.setDevicePollingIntervalOverride(dClientReg.getDevicePollingIntervalOverride());
            domain.setBypassActivationCodeConfirmationOverride(dClientReg.getBypassActivationCodeConfirmationOverride());
            boolean requireProofKeyForCodeExchange = dClientReg.getRequireProofKeyForCodeExchange() != null ? dClientReg.getRequireProofKeyForCodeExchange() : false;
            domain.setRequireProofKeyForCodeExchange(requireProofKeyForCodeExchange);
            domain.setCibaPollingInterval(dClientReg.getCibaPollingInterval());
            domain.setCibaRequireSignedRequests(dClientReg.isCibaRequireSignedRequests() == null ? false : dClientReg.isCibaRequireSignedRequests());
            if (dClientReg.getRequestPolicyRef() != null) {
                domain.setCibaPolicyId(dClientReg.getRequestPolicyRef().getId());
            }
            if (dClientReg.getTokenExchangeProcessorPolicyRef() != null) {
                domain.setTokenExchangeProcessorPolicyId(dClientReg.getTokenExchangeProcessorPolicyRef().getId());
            }
            String refreshTokenRollingGracePeriodTypeStr = dClientReg.getRefreshTokenRollingGracePeriodType() != null ? dClientReg.getRefreshTokenRollingGracePeriodType().getId() : null;
            domain.setRefreshTokenRollingGracePeriodType(refreshTokenRollingGracePeriodTypeStr);
            domain.setRefreshTokenRollingGracePeriod(null);
            if (RefreshTokenRollingGracePeriodType.OVERRIDE_SERVER_DEFAULT.equals((Object)dClientReg.getRefreshTokenRollingGracePeriodType())) {
                domain.setRefreshTokenRollingGracePeriod(dClientReg.getRefreshTokenRollingGracePeriod());
            }
            domain.setClientSecretRetentionPeriodType(dClientReg.getClientSecretRetentionPeriodType());
            if (dClientReg.getClientSecretRetentionPeriodOverride() != null) {
                domain.setClientSecretRetentionPeriod(dClientReg.getClientSecretRetentionPeriodOverride());
            }
            domain.setRequireJwtSecuredAuthorizationResponseMode(dClientReg.getRequireJwtSecuredAuthorizationResponseMode());
            if (dClientReg.getRotateClientSecret() != null || dClientReg.getRotateRegistrationAccessToken() != null || dClientReg.getAllowClientDelete() != null || dClientReg.getDisableRegistrationAccessTokens() != null || dClientReg.getRetainClientSecret() != null) {
                domain.setEnableDynamicClientRegistrationManagement(true);
                domain.setRotateClientSecret(dClientReg.getRotateClientSecret() != null ? dClientReg.getRotateClientSecret() : true);
                domain.setRotateRegistrationAccessToken(dClientReg.getRotateRegistrationAccessToken() != null ? dClientReg.getRotateRegistrationAccessToken() : true);
                domain.setAllowClientDelete(dClientReg.getAllowClientDelete() != null ? dClientReg.getAllowClientDelete() : false);
                domain.setDisableRegistrationAccessTokens(dClientReg.getDisableRegistrationAccessTokens() != null ? dClientReg.getDisableRegistrationAccessTokens() : false);
                domain.setRetainClientSecret(dClientReg.getRetainClientSecret() != null ? dClientReg.getRetainClientSecret() : false);
            } else {
                domain.setEnableDynamicClientRegistrationManagement(false);
            }
            RequireOfflineAccessScopeToIssueRefreshTokensType requireOfflineAccessScopeToIssueRefreshTokensType = dClientReg.getRequireOfflineAccessScopeToIssueRefreshTokens();
            String requireOfflineAccessScopeToIssueRefreshTokens = requireOfflineAccessScopeToIssueRefreshTokensType != null ? requireOfflineAccessScopeToIssueRefreshTokensType.getValue() : RequireOfflineAccessScopeToIssueRefreshTokensType.SERVER_DEFAULT.getValue();
            domain.setRequireOfflineAccessScopeToIssueRefreshTokens(requireOfflineAccessScopeToIssueRefreshTokens);
            OfflineAccessRequireConsentPromptType offlineAccessRequireConsentPrompt = dClientReg.getOfflineAccessRequireConsentPrompt();
            String offlineAccessRequireConsentPromptType = offlineAccessRequireConsentPrompt != null ? offlineAccessRequireConsentPrompt.getValue() : OfflineAccessRequireConsentPromptType.SERVER_DEFAULT.getValue();
            domain.setOfflineAccessRequireConsentPrompt(offlineAccessRequireConsentPromptType);
            String lockoutMaxMaliciousActionsType = dClientReg.getLockoutMaxMaliciousActionsType() != null ? dClientReg.getLockoutMaxMaliciousActionsType().getValue() : LockoutMaxMaliciousActionsType.SERVER_DEFAULT.getValue();
            domain.setLockoutMaxMaliciousActionsType(lockoutMaxMaliciousActionsType);
            Integer lockoutMaxMaliciousActions = dClientReg.getLockoutMaxMaliciousActions();
            domain.setLockoutMaxMaliciousActions(lockoutMaxMaliciousActions);
        } else {
            domain.setEnableDynamicClientRegistration(false);
        }
        return domain;
    }

    private ResourceLink getClientCertIssuerDnResourceLink(String issuerDn) {
        if (StringUtils.isNotBlank((String)issuerDn)) {
            for (Cert cert : trustedCasManager.getTrustedCAs()) {
                String trustedCASubjectDN = cert.getX509Certificate().getSubjectDN().getName();
                if (!trustedCASubjectDN.equals(issuerDn)) continue;
                String href = ApiUtil.getResourceUrl("/certificates/ca", cert.getId());
                return new ResourceLink(cert.getId(), href);
            }
        }
        return null;
    }

    private ResourceLink getPolicyResourceLink(ClientSetting client) {
        if (StringUtils.isNotBlank((String)client.getPolicyGroupId())) {
            String href = ApiUtil.getResourceUrl("/oauth/openIdConnect/policies", client.getPolicyGroupId());
            return new ResourceLink(client.getPolicyGroupId(), href);
        }
        return null;
    }
}

