/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.ApcToPersistentGrantMapping;
import com.pingidentity.admin.api.model.oauth.ApcToPersistentGrantMappings;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthApcMappingTranslator {
    public ApcToPersistentGrantMappings domainToApi(Collection<ApcToUserKeyAttrMapping> domainApcMappings) {
        ArrayList<ApcToPersistentGrantMapping> apiApcMappings = new ArrayList<ApcToPersistentGrantMapping>();
        for (ApcToUserKeyAttrMapping apcMapping : domainApcMappings) {
            ApcToPersistentGrantMapping apiMapping = this.domainToApi(apcMapping);
            apiApcMappings.add(apiMapping);
        }
        return new ApcToPersistentGrantMappings(apiApcMappings);
    }

    public ApcToPersistentGrantMapping domainToApi(ApcToUserKeyAttrMapping domainAttrMapping) {
        ApcToPersistentGrantMapping apiApcMapping = new ApcToPersistentGrantMapping();
        apiApcMapping.setId(domainAttrMapping.getApcId());
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        HashSet<String> validAttributeContract = MgmtFactory.getAuthzServerManager().getKeyNameContract() == null ? new HashSet() : MgmtFactory.getAuthzServerManager().getKeyNameContract().getAllAttributeNames();
        attributeMappingTranslator.domainToApi((AttributeMapping)domainAttrMapping, apiApcMapping, validAttributeContract, false);
        ResourceLink resourceId = new ResourceLink();
        resourceId.setId(domainAttrMapping.getApcId());
        resourceId.setLocation(ApiUtil.getResourceUrl("/authenticationPolicyContracts", domainAttrMapping.getApcId()));
        apiApcMapping.setAuthenticationPolicyContractRef(resourceId);
        return apiApcMapping;
    }

    public ApcToUserKeyAttrMapping apiToDomain(ApcToPersistentGrantMapping apiMapping) {
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        ApcToUserKeyAttrMapping domainMapping = new ApcToUserKeyAttrMapping(authzServerManager.getKeyNameContract());
        attributeMappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        domainMapping.setApcId(apiMapping.getAuthenticationPolicyContractRef().getId());
        return domainMapping;
    }
}

