/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.ResourceOwnerCredentialsMapping;
import com.pingidentity.admin.api.model.oauth.ResourceOwnerCredentialsMappings;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthResourceOwnerCredentialsMappingsTranslator {
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    public ResourceOwnerCredentialsMappings domainToApi(Collection<PluginToUserKeyAttrMapping> domainRoCredsMappings) {
        ArrayList<ResourceOwnerCredentialsMapping> apiRoCredsMappings = new ArrayList<ResourceOwnerCredentialsMapping>();
        for (PluginToUserKeyAttrMapping roCredMapping : domainRoCredsMappings) {
            ResourceOwnerCredentialsMapping apiClient = this.domainToApi(roCredMapping);
            apiRoCredsMappings.add(apiClient);
        }
        return new ResourceOwnerCredentialsMappings(apiRoCredsMappings);
    }

    public ResourceOwnerCredentialsMapping domainToApi(PluginToUserKeyAttrMapping domainAttrMapping) {
        ResourceOwnerCredentialsMapping apiRoCredsMapping = new ResourceOwnerCredentialsMapping();
        apiRoCredsMapping.setId(domainAttrMapping.getSourcePluginId());
        HashSet<String> validAttributeContract = MgmtFactory.getAuthzServerManager().getKeyNameContract() == null ? new HashSet() : MgmtFactory.getAuthzServerManager().getKeyNameContract().getAllAttributeNames();
        this.attributeMappingTranslator.domainToApi((AttributeMapping)domainAttrMapping, apiRoCredsMapping, validAttributeContract, false);
        ResourceLink resourceId = new ResourceLink();
        resourceId.setId(domainAttrMapping.getSourcePluginId());
        resourceId.setLocation(ApiUtil.getResourceUrl("/passwordCredentialValidators", domainAttrMapping.getSourcePluginId()));
        apiRoCredsMapping.setPasswordValidatorRef(resourceId);
        return apiRoCredsMapping;
    }

    public PluginToUserKeyAttrMapping apiToDomain(ResourceOwnerCredentialsMapping apiMapping) {
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        PluginToUserKeyAttrMapping domainMapping = new PluginToUserKeyAttrMapping(authzServerManager.getKeyNameContract());
        this.attributeMappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        domainMapping.setSourcePluginId(apiMapping.getId());
        return domainMapping;
    }
}

