/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.google.common.collect.ImmutableMap;
import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.ParameterValues;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectPolicy;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.oauth.UserInfoAttributeContractTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrMapping;

public class OpenIdConnectPolicyTranslator {
    private final UserInfoAttributeContractTranslator attributeContractTranslator = new UserInfoAttributeContractTranslator();
    private final Map<SourceType, String> additionalPrefixes = ImmutableMap.of((Object)((Object)SourceType.OAUTH_PERSISTENT_GRANT), (Object)"persistentgrant.");
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator(this.additionalPrefixes);

    public OpenIdConnectPolicy domainToApi(OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        OpenIdConnectPolicy apiPolicy = new OpenIdConnectPolicy();
        apiPolicy.setId(policyGroup.getPolicyId());
        apiPolicy.setName(policyGroup.getName());
        apiPolicy.setIdTokenLifetime(policyGroup.getIdTokenLife());
        apiPolicy.setIncludeSriInIdToken(policyGroup.isIncludeSriInIdToken());
        apiPolicy.setIncludeUserInfoInIdToken(policyGroup.isIncludeUserInfoInIdToken());
        apiPolicy.setIncludeSHashInIdToken(policyGroup.isIncludeSHashInIdToken());
        apiPolicy.setIncludeX5tInIdToken(policyGroup.isIncludeX5tInIdToken());
        apiPolicy.setIdTokenTypHeaderValue(policyGroup.getIdTokenTypHeaderValue());
        apiPolicy.setReturnIdTokenOnRefreshGrant(policyGroup.isReturnIdTokenOnRefreshGrant());
        apiPolicy.setReturnIdTokenOnTokenExchangeGrant(policyGroup.isReturnIdTokenOnTokenExchangeGrant());
        apiPolicy.setReissueIdTokenInHybridFlow(policyGroup.isReissueIdTokenHybridFlows());
        apiPolicy.setAllowIdTokenIntrospection(policyGroup.isAllowIdTokenIntrospection());
        apiPolicy.setAttributeContract(this.attributeContractTranslator.domainToApi(policyGroup));
        apiPolicy.setAccessTokenManagerRef(new ResourceLink(policyGroup.getAccessTokenManagerId(), ApiUtil.getResourceUrl("/oauth/accessTokenManagers", policyGroup.getAccessTokenManagerId())));
        this.translateDomainToApiScopeAttributeMappings(apiPolicy, policyGroup.getScopeAttributeMappings());
        UserInfoAttrMapping domainAttributeMapping = policyGroup.getUserInfoAttributeMapping();
        AttributeMapping apiAttributeMapping = new AttributeMapping();
        this.attributeMappingTranslator.domainToApi((org.sourceid.saml20.domain.AttributeMapping)domainAttributeMapping, apiAttributeMapping);
        apiPolicy.setAttributeMapping(apiAttributeMapping);
        if (policyGroup.getLastModified() != null) {
            apiPolicy.setLastModified(policyGroup.getLastModified().getTime());
        }
        return apiPolicy;
    }

    private void translateDomainToApiScopeAttributeMappings(OpenIdConnectPolicy apiPolicy, Map<String, List<String>> scopeAttributeMappings) {
        HashMap<String, ParameterValues> apiParams = new HashMap<String, ParameterValues>();
        if (scopeAttributeMappings != null) {
            for (Map.Entry<String, List<String>> param : scopeAttributeMappings.entrySet()) {
                ParameterValues values = new ParameterValues();
                ArrayList<String> elements = new ArrayList<String>((Collection)param.getValue());
                values.setValues(elements);
                apiParams.put(param.getKey(), values);
            }
        }
        apiPolicy.setScopeAttributeMappings(apiParams);
    }

    public OpenIdConnectProviderPolicy.PolicyGroup apiToDomain(OpenIdConnectPolicy apiPolicy) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = new OpenIdConnectProviderPolicy.PolicyGroup();
        policyGroup.setPolicyId(apiPolicy.getId());
        policyGroup.setName(apiPolicy.getName());
        policyGroup.setIdTokenLife(apiPolicy.getIdTokenLifetime().intValue());
        policyGroup.setIncludeSriInIdToken(apiPolicy.isIncludeSriInIdToken());
        policyGroup.setIncludeUserInfoInIdToken(apiPolicy.isIncludeUserInfoInIdToken());
        policyGroup.setUserInfoAttributeContract(this.attributeContractTranslator.apiToDomain(apiPolicy, policyGroup));
        policyGroup.setIncludeSHashInIdToken(apiPolicy.isIncludeSHashInIdToken());
        policyGroup.setIncludeX5tInIdToken(apiPolicy.isIncludeX5tInIdToken());
        policyGroup.setIdTokenTypHeaderValue(apiPolicy.getIdTokenTypHeaderValue());
        policyGroup.setReturnIdTokenOnRefreshGrant(apiPolicy.isReturnIdTokenOnRefreshGrant());
        policyGroup.setReturnIdTokenOnTokenExchangeGrant(apiPolicy.isReturnIdTokenOnTokenExchangeGrant());
        policyGroup.setReissueIdTokenHybridFlows(apiPolicy.isReissueIdTokenInHybridFlow());
        policyGroup.setAllowIdTokenIntrospection(apiPolicy.isAllowIdTokenIntrospection());
        policyGroup.setAccessTokenManagerId(apiPolicy.getAccessTokenManagerRef().getId());
        AttributeMapping apiAttributeMapping = apiPolicy.getAttributeMapping();
        UserInfoAttrMapping domainAttributeMapping = new UserInfoAttrMapping();
        this.attributeMappingTranslator.apiToDomain(apiAttributeMapping, (org.sourceid.saml20.domain.AttributeMapping)domainAttributeMapping);
        policyGroup.setUserInfoAttributeMapping(domainAttributeMapping);
        this.translateApiToDomainScopeAttributeMappings(policyGroup, apiPolicy.getScopeAttributeMappings());
        return policyGroup;
    }

    private void translateApiToDomainScopeAttributeMappings(OpenIdConnectProviderPolicy.PolicyGroup policyGroup, Map<String, ParameterValues> scopeAttributeMappings) {
        HashMap<String, List<String>> domainParams = new HashMap<String, List<String>>();
        if (scopeAttributeMappings != null) {
            for (Map.Entry<String, ParameterValues> param : scopeAttributeMappings.entrySet()) {
                domainParams.put(param.getKey(), param.getValue().getValues());
            }
        }
        policyGroup.setScopeAttributeMappings(domainParams);
    }
}

