/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.model.oauth.OpenIdConnectAttribute;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectAttributeContract;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectPolicy;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrContract;

public class UserInfoAttributeContractTranslator {
    public OpenIdConnectAttributeContract domainToApi(OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        OpenIdConnectAttributeContract apiContract = new OpenIdConnectAttributeContract();
        UserInfoAttrContract domainContract = policyGroup.getUserInfoAttributeContract();
        for (String coreAttributeName : domainContract.getImmutableAttributeNames()) {
            OpenIdConnectAttribute coreAttribute = new OpenIdConnectAttribute();
            coreAttribute.setName(coreAttributeName);
            apiContract.addCoreAttribute(coreAttribute);
        }
        for (String extendedAttributeName : domainContract.getMutableAttributeNames()) {
            OpenIdConnectAttribute extendedAttribute = new OpenIdConnectAttribute();
            extendedAttribute.setName(extendedAttributeName);
            if (policyGroup.getAttributeInclusionMappings().containsKey(extendedAttributeName)) {
                extendedAttribute.setIncludeInIdToken(((OpenIdConnectProviderPolicy.AttributeInclusionInfo)policyGroup.getAttributeInclusionMappings().get(extendedAttributeName)).isIncludeInIdToken());
                extendedAttribute.setIncludeInUserInfo(((OpenIdConnectProviderPolicy.AttributeInclusionInfo)policyGroup.getAttributeInclusionMappings().get(extendedAttributeName)).isIncludeInUserInfo());
            }
            extendedAttribute.setMultiValued(policyGroup.getMultiValuedAttributes().contains(extendedAttributeName));
            apiContract.addExtendedAttribute(extendedAttribute);
        }
        return apiContract;
    }

    public UserInfoAttrContract apiToDomain(OpenIdConnectPolicy apiPolicy, OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        Set coreAttributes = new UserInfoAttrContract().getImmutableAttributeNames();
        HashSet<String> extendedAttributes = new HashSet<String>();
        OpenIdConnectAttributeContract apiContract = apiPolicy.getAttributeContract();
        for (OpenIdConnectAttribute extendedAttribute : apiContract.getExtendedAttributes()) {
            extendedAttributes.add(extendedAttribute.getName());
            if (extendedAttribute.isIncludeInIdToken() != null || extendedAttribute.isIncludeInUserInfo() != null) {
                boolean includeInIdtoken = extendedAttribute.isIncludeInIdToken() != null && extendedAttribute.isIncludeInIdToken() != false;
                boolean includeInUserInfo = extendedAttribute.isIncludeInUserInfo() != null && extendedAttribute.isIncludeInUserInfo() != false;
                policyGroup.getAttributeInclusionMappings().put(extendedAttribute.getName(), new OpenIdConnectProviderPolicy.AttributeInclusionInfo(includeInIdtoken, includeInUserInfo));
            }
            if (!extendedAttribute.isMultiValued()) continue;
            policyGroup.getMultiValuedAttributes().add(extendedAttribute.getName());
        }
        return new UserInfoAttrContract(coreAttributes, extendedAttributes);
    }
}

