/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.oauth.AccessTokenMapping;
import com.pingidentity.admin.api.model.oauth.AccessTokenMappingContext;
import com.pingidentity.admin.api.model.oauth.AccessTokenMappingType;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class UserKeyToAccessTokenMappingTranslator {
    private final ContextUtil contextUtil = new ContextUtil();
    private final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
    private final AttributeMappingTranslator attributeMappingTranslator;

    public UserKeyToAccessTokenMappingTranslator() {
        HashMap<SourceType, String> additionalPrefixes = new HashMap<SourceType, String>();
        additionalPrefixes.put(SourceType.IDP_CONNECTION, "idp.");
        additionalPrefixes.put(SourceType.ADAPTER, "adapter.");
        additionalPrefixes.put(SourceType.PASSWORD_CREDENTIAL_VALIDATOR, "pcv.");
        additionalPrefixes.put(SourceType.AUTHENTICATION_POLICY_CONTRACT, "apc.");
        additionalPrefixes.put(SourceType.TOKEN_EXCHANGE_PROCESSOR_POLICY, "tepp.");
        this.attributeMappingTranslator = new AttributeMappingTranslator(additionalPrefixes);
    }

    public UserKeyToAccessTokenMapping apiToDomain(AccessTokenMapping apiMapping) {
        UserKeyToAccessTokenMapping domainMapping = new UserKeyToAccessTokenMapping();
        AccessTokenMappingType type = apiMapping.getContext().getType();
        String id = null;
        if (type != AccessTokenMappingType.DEFAULT) {
            id = apiMapping.getContext().getContextRef().getId();
        }
        String contextId = AccessTokenMappingType.toContextId(type, id);
        domainMapping.setContextId(contextId);
        domainMapping.setTokenManagerId(apiMapping.getAccessTokenManagerRef().getId());
        this.attributeMappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        return domainMapping;
    }

    public List<AccessTokenMapping> domainToApi(Collection<UserKeyToAccessTokenMapping> domainMappings) {
        ArrayList<AccessTokenMapping> apiMappings = new ArrayList<AccessTokenMapping>();
        for (UserKeyToAccessTokenMapping domainMapping : domainMappings) {
            apiMappings.add(this.domainToApi(domainMapping));
        }
        return apiMappings;
    }

    public AccessTokenMapping domainToApi(UserKeyToAccessTokenMapping domainMapping) {
        AccessTokenMapping apiMapping = new AccessTokenMapping();
        apiMapping.setId(domainMapping.getId());
        if (domainMapping.isDefaultContextMapping()) {
            AccessTokenMappingContext context = new AccessTokenMappingContext();
            context.setType(AccessTokenMappingType.DEFAULT);
            apiMapping.setContext(context);
        } else {
            String contextId = domainMapping.getContextId();
            AccessTokenMappingType type = AccessTokenMappingType.fromContextId(contextId);
            ContextUtil.Ctx ctx = this.contextUtil.split(contextId);
            AccessTokenMappingContext context = new AccessTokenMappingContext();
            if (type != AccessTokenMappingType.CLIENT_CREDENTIALS) {
                String id = ctx.getOAuthSourceId().getRealId();
                String location = null;
                switch (type) {
                    case IDP_CONNECTION: {
                        location = ApiUtil.getResourceUrl("/sp/idpConnections", id);
                        break;
                    }
                    case IDP_ADAPTER: {
                        location = ApiUtil.getResourceUrl("/idp/adapters", id);
                        break;
                    }
                    case PCV: {
                        location = ApiUtil.getResourceUrl("/passwordCredentialValidators", id);
                        break;
                    }
                    case AUTHENTICATION_POLICY_CONTRACT: {
                        location = ApiUtil.getResourceUrl("/authenticationPolicyContracts", id);
                        break;
                    }
                    case TOKEN_EXCHANGE_PROCESSOR_POLICY: {
                        location = ApiUtil.getResourceUrl("/oauth/tokenExchange/processor/policies", id);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized context type");
                    }
                }
                context.setContextRef(new ResourceLink(id, location));
            }
            context.setType(type);
            apiMapping.setContext(context);
        }
        String tokenManagerId = domainMapping.getTokenManagerId();
        ResourceLink tokenManagerRef = new ResourceLink(tokenManagerId, ApiUtil.getResourceUrl("/oauth/accessTokenManagers", tokenManagerId));
        apiMapping.setAccessTokenManagerRef(tokenManagerRef);
        BearerAccessTokenMgmtPluginInstance tokenManagerInstance = (BearerAccessTokenMgmtPluginInstance)this.bearerAccessTokenMgmtPluginManager.getInstance(tokenManagerId);
        Set attributeContract = tokenManagerInstance.getAttributeContract().getAllAttributeNames();
        attributeContract.addAll(tokenManagerInstance.getTokenEndpointAttributeContract().getAllAttributeNames());
        this.attributeMappingTranslator.domainToApi((AttributeMapping)domainMapping, apiMapping, (Set<String>)attributeContract, false);
        return apiMapping;
    }
}

