/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth.exchange;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.oauth.exchange.ProcessorPolicyToGeneratorMapping;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.sourceid.oauth20.exchange.domain.ProcessorPolicy2GeneratorMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public final class ProcessorPolicyToGeneratorMappingTranslator {
    private final TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
    private final AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();

    public Function<ProcessorPolicy2GeneratorMapping, ProcessorPolicyToGeneratorMapping> toApi() {
        return domain -> {
            ProcessorPolicyToGeneratorMapping api = new ProcessorPolicyToGeneratorMapping();
            api.setId(ApiUtil.combineId(domain.getSourceId(), domain.getTargetId()));
            api.setSourceId(domain.getSourceId());
            api.setTargetId(domain.getTargetId());
            api.setLicenseConnectionGroupAssignment(domain.getLicenseConnectionGroupAssignment());
            this.mappingTranslator.domainToApi((AttributeMapping)domain, api);
            return api;
        };
    }

    public Function<ProcessorPolicyToGeneratorMapping, ProcessorPolicy2GeneratorMapping> toDomain() {
        return api -> {
            ProcessorPolicy2GeneratorMapping domain = new ProcessorPolicy2GeneratorMapping();
            domain.setSourceId(api.getSourceId());
            domain.setTargetId(api.getTargetId());
            domain.setLicenseConnectionGroupAssignment(api.getLicenseConnectionGroupAssignment());
            this.mappingTranslator.apiToDomain((com.pingidentity.admin.api.model.AttributeMapping)api, (AttributeMapping)domain);
            return domain;
        };
    }

    public Consumer<ProcessorPolicyToGeneratorMapping> cleanupContractFulfillmentMapping() {
        return mapping -> {
            ConfigurablePluginInstance tokenGenerator = this.tokenGeneratorManager.getInstance(mapping.getTargetId());
            Set attributeContract = tokenGenerator.getAttributeContract().getAllAttributeNames();
            Map<String, AttributeFulfillmentValue> contractFulfillmentMappings = mapping.getAttributeContractFulfillment();
            contractFulfillmentMappings.entrySet().removeIf(entry -> !attributeContract.contains(entry.getKey()));
        };
    }
}

