/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth.exchange;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorAttribute;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorAttributeContract;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.saml20.domain.AttributeMapping;

public final class TokenExchangeProcessorPolicyTranslator {
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    public Function<TokenExchangeProcessorPolicy, com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy> toApi() {
        return domain -> {
            com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy api = new com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy();
            api.setId(domain.getId());
            api.setName(domain.getName());
            api.setActorTokenRequired(domain.isActorTokenRequired());
            api.setAttributeContract(this.getApiAttributeContract((TokenExchangeProcessorPolicy)domain));
            api.setProcessorMappings(this.getApiProcessorMappings((TokenExchangeProcessorPolicy)domain));
            return api;
        };
    }

    public Function<com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy, TokenExchangeProcessorPolicy> toDomain() {
        return api -> {
            TokenExchangeProcessorPolicy domain = new TokenExchangeProcessorPolicy();
            domain.setId(api.getId());
            domain.setName(api.getName());
            domain.setActorTokenRequired(api.isActorTokenRequired());
            domain.setContract(this.getDomainAttributeContract((com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy)api));
            for (com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping apiMapping : api.getProcessorMappings()) {
                domain.addTokenExchangeProcessorMapping(this.getDomainProcessorMapping(apiMapping));
            }
            return domain;
        };
    }

    private org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorAttributeContract getDomainAttributeContract(com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy api) {
        org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorAttributeContract contract = new org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorAttributeContract();
        for (TokenExchangeProcessorAttribute attribute : api.getAttributeContract().getExtendedAttributes()) {
            contract.addMutableAttributeName(attribute.getName());
        }
        return contract;
    }

    private TokenExchangeProcessorAttributeContract getApiAttributeContract(TokenExchangeProcessorPolicy domain) {
        TokenExchangeProcessorAttributeContract attributeContract = new TokenExchangeProcessorAttributeContract();
        Set immutableAttributeNames = domain.getContract().getImmutableAttributeNames();
        for (String name : immutableAttributeNames) {
            TokenExchangeProcessorAttribute attribute = new TokenExchangeProcessorAttribute();
            attribute.setName(name);
            attributeContract.addCoreAttribute(attribute);
        }
        Set mutableAttributeNames = domain.getContract().getMutableAttributeNames();
        for (String name : mutableAttributeNames) {
            TokenExchangeProcessorAttribute attribute = new TokenExchangeProcessorAttribute();
            attribute.setName(name);
            attributeContract.addExtendedAttribute(attribute);
        }
        return attributeContract;
    }

    private List<com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping> getApiProcessorMappings(TokenExchangeProcessorPolicy domain) {
        ArrayList<com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping> result = new ArrayList<com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping>();
        for (TokenExchangeProcessorMapping domainMapping : domain.getTokenExchangeProcessorMappings().values()) {
            com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping apiMapping = this.getApiTokenExchangeProcessorMapping(domainMapping);
            result.add(apiMapping);
        }
        return result;
    }

    public com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping getApiTokenExchangeProcessorMapping(TokenExchangeProcessorMapping domainMapping) {
        com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping apiMapping = new com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping();
        apiMapping.setSubjectTokenType(domainMapping.getSubjectTokenType());
        apiMapping.setActorTokenType(domainMapping.getActorTokenType());
        if (StringUtils.isNotBlank((String)domainMapping.getSubjectTokenProcessorId())) {
            apiMapping.setSubjectTokenProcessor(new ResourceLink(domainMapping.getSubjectTokenProcessorId(), ApiUtil.getResourceUrl("/idp/tokenProcessors", domainMapping.getSubjectTokenProcessorId())));
        } else {
            apiMapping.setSubjectTokenProcessor(new ResourceLink());
        }
        if (StringUtils.isNotBlank((String)domainMapping.getActorTokenProcessorId())) {
            apiMapping.setActorTokenProcessor(new ResourceLink(domainMapping.getActorTokenProcessorId(), ApiUtil.getResourceUrl("/idp/tokenProcessors", domainMapping.getActorTokenProcessorId())));
        } else {
            apiMapping.setActorTokenProcessor(new ResourceLink());
        }
        this.attributeMappingTranslator.domainToApi(domainMapping.getAttributeMapping(), apiMapping);
        return apiMapping;
    }

    private TokenExchangeProcessorMapping getDomainProcessorMapping(com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping apiMapping) {
        TokenExchangeProcessorMapping domainMapping = new TokenExchangeProcessorMapping();
        domainMapping.setSubjectTokenType(apiMapping.getSubjectTokenType());
        domainMapping.setActorTokenType(apiMapping.getActorTokenType());
        if (apiMapping.getSubjectTokenProcessor() != null) {
            domainMapping.setSubjectTokenProcessorId(apiMapping.getSubjectTokenProcessor().getId());
        }
        if (apiMapping.getActorTokenProcessor() != null) {
            domainMapping.setActorTokenProcessorId(apiMapping.getActorTokenProcessor().getId());
        }
        AttributeMapping domainAttributeMapping = new AttributeMapping();
        this.attributeMappingTranslator.apiToDomain(apiMapping, domainAttributeMapping);
        domainMapping.setAttributeMapping(domainAttributeMapping);
        return domainMapping;
    }
}

