/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.plugin;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.IdpAdapterContractMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.plugin.IdpAdapter;
import com.pingidentity.admin.api.model.plugin.IdpAdapterAttribute;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.plugin.PluginInstanceTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;

public class IdpAdapterTranslator
extends PluginInstanceTranslator {
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    public IdpAuthnAdapterInstance apiToDomain(IdpAdapter apiInstance, PluginInstanceValidator validator) {
        IdpAuthnAdapterInstance domainInstance = (IdpAuthnAdapterInstance)this.apiToDomain(apiInstance, validator, PluginEnum.IDP_ADAPTER);
        boolean isAttrContractInherited = this.getBooleanVal(apiInstance.getAttributeContract().isInherited());
        if (!StringUtils.isEmpty((String)apiInstance.getAuthnCtxClassRef()) && domainInstance.getDescriptor().allowConfigurableAuthnCtx()) {
            domainInstance.setAuthnCtxClassRef(apiInstance.getAuthnCtxClassRef());
        }
        if (!isAttrContractInherited) {
            HashSet<String> domainMaskedFields = new HashSet<String>();
            LinkedList<String> domainUniqueKeys = new LinkedList<String>();
            for (IdpAdapterAttribute idpAdapterAttribute : apiInstance.getAttributeContract().getCoreAttributes()) {
                if (idpAdapterAttribute.isMasked().booleanValue()) {
                    domainMaskedFields.add(idpAdapterAttribute.getName());
                }
                if (!idpAdapterAttribute.isPseudonym()) continue;
                domainUniqueKeys.add(idpAdapterAttribute.getName());
            }
            if (domainInstance.getDescriptor().isSupportsExtendedContract() && apiInstance.getAttributeContract().getExtendedAttributes() != null) {
                HashSet<String> domainExtAttrs = new HashSet<String>();
                for (IdpAdapterAttribute extApiAttr : apiInstance.getAttributeContract().getExtendedAttributes()) {
                    if (extApiAttr.isMasked().booleanValue()) {
                        domainMaskedFields.add(extApiAttr.getName());
                    }
                    if (extApiAttr.isPseudonym()) {
                        domainUniqueKeys.add(extApiAttr.getName());
                    }
                    domainExtAttrs.add(extApiAttr.getName());
                }
                domainInstance.setExtendedContractAttributes(domainExtAttrs);
            }
            domainInstance.setOwnMaskedFields(domainMaskedFields);
            domainInstance.setOwnUniqueKeyFields(domainUniqueKeys);
            this.apiToDomainUniqueUserKey(apiInstance, domainInstance);
            domainInstance.setOwnMaskOgnlValues(apiInstance.getAttributeContract().isMaskOgnlValues());
        } else {
            domainInstance.setInheritingExtendedContractAttributes(true);
            domainInstance.setInheritingAttributeSettings(true);
        }
        IdpAdapterContractMapping apiAttributeMapping = apiInstance.getAttributeMapping();
        if (apiAttributeMapping == null) {
            apiAttributeMapping = new IdpAdapterContractMapping();
            domainInstance.setInheritingAttributeMapping(false);
        } else {
            boolean isAttrMappingInherited = this.getBooleanVal(apiAttributeMapping.isInherited());
            domainInstance.setInheritingAttributeMapping(isAttrMappingInherited);
        }
        SourceTypeIdKey key = new SourceTypeIdKey();
        key.setType(SourceType.ADAPTER);
        HashMap<String, AttributeFulfillmentValue> attributeFulfillmentValueMap = apiAttributeMapping.getAttributeContractFulfillment() == null ? new HashMap() : apiAttributeMapping.getAttributeContractFulfillment();
        for (String attributeName : this.getCoreAttributeNames(apiInstance)) {
            if (attributeFulfillmentValueMap.containsKey(attributeName)) continue;
            AttributeFulfillmentValue attributeFulfillmentValue = new AttributeFulfillmentValue();
            attributeFulfillmentValue.setSource(key);
            attributeFulfillmentValue.setValue(attributeName);
            attributeFulfillmentValueMap.put(attributeName, attributeFulfillmentValue);
        }
        apiAttributeMapping.setAttributeContractFulfillment(attributeFulfillmentValueMap);
        AttributeMapping attributeMapping = domainInstance.getAttributeMapping();
        this.attributeMappingTranslator.apiToDomain(apiAttributeMapping, attributeMapping);
        domainInstance.setAttributeMapping(attributeMapping);
        return domainInstance;
    }

    void apiToDomainUniqueUserKey(IdpAdapter apiInstance, IdpAuthnAdapterInstance domainInstance) {
        String uniqueUserKeyAttribute = apiInstance.getAttributeContract().getUniqueUserKeyAttribute();
        if (uniqueUserKeyAttribute == null) {
            domainInstance.setUniqueUserKeyAttributeAsIs("pf_none");
        } else {
            domainInstance.setUniqueUserKeyAttributeAsIs(uniqueUserKeyAttribute);
        }
    }

    public IdpAdapter domainToApi(IdpAuthnAdapterInstance domainInstance) {
        IdpAdapterContractMapping apiAttributeMapping;
        IdpAuthnAdapterInstance adapterWithMapping;
        AttributeMapping domainAttributeMapping;
        boolean inheriting;
        IdpAdapter apiAdapter = (IdpAdapter)this.domainToApi((ConfigurablePluginInstance)domainInstance, PluginEnum.IDP_ADAPTER);
        Set maskedFields = domainInstance.getMaskedFields();
        HashSet uniqueKeys = new HashSet(domainInstance.getUniqueKeyFields());
        for (Object coreAttr : domainInstance.getAttributeContract().getImmutableAttributeNames()) {
            IdpAdapterAttribute apiAttr = new IdpAdapterAttribute();
            apiAttr.setName((String)coreAttr);
            apiAttr.setMasked(maskedFields.contains(coreAttr));
            apiAttr.setPseudonym(uniqueKeys.contains(coreAttr));
            apiAdapter.getAttributeContract().getCoreAttributes().add(apiAttr);
        }
        this.domainToApiUniqueUserKey(domainInstance, apiAdapter);
        if (domainInstance.getDescriptor().isSupportsExtendedContract()) {
            LinkedList<IdpAdapterAttribute> apiExtAttrs = new LinkedList<IdpAdapterAttribute>();
            for (String extAttr : domainInstance.getAttributeContract().getMutableAttributeNames()) {
                IdpAdapterAttribute apiAttr = new IdpAdapterAttribute();
                apiAttr.setName(extAttr);
                apiAttr.setMasked(maskedFields.contains(extAttr));
                apiAttr.setPseudonym(uniqueKeys.contains(extAttr));
                apiExtAttrs.add(apiAttr);
            }
            apiAdapter.getAttributeContract().setExtendedAttributes(apiExtAttrs);
        }
        apiAdapter.getAttributeContract().setMaskOgnlValues(domainInstance.getMaskOgnlValues());
        if (!StringUtils.isEmpty((String)domainInstance.getAuthnCtxClassRef()) && domainInstance.getDescriptor().allowConfigurableAuthnCtx()) {
            apiAdapter.setAuthnCtxClassRef(domainInstance.getAuthnCtxClassRef());
        }
        boolean bl = inheriting = domainInstance.isInheritingAttributeSettings() && domainInstance.isInheritingExtendedContractAttributes();
        if (inheriting) {
            apiAdapter.getAttributeContract().setInherited(Boolean.TRUE);
        }
        if ((domainAttributeMapping = (adapterWithMapping = ConfigurationUtil.findAdapterWithEffectiveAttributeMap((IdpAuthnAdapterInstance)domainInstance)).getNullableAttributeMapping()) != null) {
            apiAttributeMapping = apiAdapter.getAttributeMapping();
            if (apiAttributeMapping == null) {
                apiAttributeMapping = new IdpAdapterContractMapping();
            }
            this.attributeMappingTranslator.domainToApi(domainAttributeMapping, apiAttributeMapping);
            apiAdapter.setAttributeMapping(apiAttributeMapping);
        } else {
            apiAttributeMapping = new IdpAdapterContractMapping();
            SourceTypeIdKey key = new SourceTypeIdKey();
            key.setType(SourceType.ADAPTER);
            HashMap<String, AttributeFulfillmentValue> attributeFulfillmentValueMap = new HashMap<String, AttributeFulfillmentValue>();
            for (String attributeName : domainInstance.getAttributeContract().getAllAttributeNames()) {
                AttributeFulfillmentValue attributeFulfillmentValue = new AttributeFulfillmentValue();
                attributeFulfillmentValue.setSource(key);
                attributeFulfillmentValue.setValue(attributeName);
                attributeFulfillmentValueMap.put(attributeName, attributeFulfillmentValue);
            }
            apiAttributeMapping.setAttributeContractFulfillment(attributeFulfillmentValueMap);
            apiAdapter.setAttributeMapping(apiAttributeMapping);
        }
        if (domainInstance.isInheritingAttributeMapping()) {
            apiAdapter.getAttributeMapping().setInherited(Boolean.TRUE);
        }
        return apiAdapter;
    }

    void domainToApiUniqueUserKey(IdpAuthnAdapterInstance domainInstance, IdpAdapter apiAdapter) {
        if (!"pf_none".equals(domainInstance.getUniqueUserKeyAttribute()) || domainInstance.getUniqueUserKeyAttribute() == null) {
            apiAdapter.getAttributeContract().setUniqueUserKeyAttribute(domainInstance.getUniqueUserKeyAttribute());
        }
    }

    private Set<String> getCoreAttributeNames(IdpAdapter idpAdapter) {
        HashSet<String> allAttributeNames = new HashSet<String>();
        ArrayList<IdpAdapterAttribute> idpAdapterAttributeList = new ArrayList<IdpAdapterAttribute>();
        if (idpAdapter.getAttributeContract() != null && idpAdapter.getAttributeContract().getCoreAttributes() != null) {
            idpAdapterAttributeList.addAll(idpAdapter.getAttributeContract().getCoreAttributes());
        }
        if (idpAdapter.getAttributeContract() != null && idpAdapter.getAttributeContract().getExtendedAttributes() != null) {
            idpAdapterAttributeList.addAll(idpAdapter.getAttributeContract().getExtendedAttributes());
        }
        for (IdpAdapterAttribute idpAdapterAttribute : idpAdapterAttributeList) {
            allAttributeNames.add(idpAdapterAttribute.getName());
        }
        return allAttributeNames;
    }
}

