/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.plugin;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.plugin.Action;
import com.pingidentity.admin.api.model.plugin.ActionOptions;
import com.pingidentity.admin.api.model.plugin.Actions;
import com.pingidentity.common.util.Base64URL;
import com.pingidentity.pf.admin.rest.translator.plugin.PluginConfigDescriptorTranslator;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class PluginActionTranslator {
    private final PluginConfigDescriptorTranslator pluginConfigDescriptorTranslator = new PluginConfigDescriptorTranslator();

    public Actions domainToApi(List<ActionDescriptor> domainActions, String pluginId, String instancesPath) {
        ArrayList<Action> apiActions = new ArrayList<Action>(domainActions.size());
        for (ActionDescriptor domainAction : domainActions) {
            apiActions.add(this.domainToApi(domainAction, pluginId, instancesPath));
        }
        return new Actions(apiActions);
    }

    public Action domainToApi(ActionDescriptor domainAction, String pluginId, String instancesPath) {
        String actionId = Base64URL.encodeToString((int)domainAction.getName().hashCode());
        Action apiAction = new Action();
        apiAction.setDescription(domainAction.getDescription());
        apiAction.setDownload(domainAction.isDownload());
        ResourceLink actionLink = new ResourceLink();
        actionLink.setId(actionId);
        actionLink.setLocation(ApiUtil.getResourceUrl(instancesPath, pluginId, "/actions", actionLink.getId(), "/invokeAction"));
        apiAction.setInvocationRef(actionLink);
        apiAction.setName(domainAction.getName());
        apiAction.setId(actionId);
        apiAction.setParameters(this.pluginConfigDescriptorTranslator.domainToApi(domainAction.getParameters()).getFields());
        return apiAction;
    }

    public SimpleFieldList apiToDomain(ActionOptions actionOptions) {
        ArrayList fields = new ArrayList();
        if (actionOptions.getParameters() != null) {
            actionOptions.getParameters().forEach(actionConfigField -> fields.add(new Field(actionConfigField.getName(), actionConfigField.getValue())));
        }
        return new SimpleFieldList(fields);
    }
}

