/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.plugin;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.plugin.PluginConfigDescriptor;
import com.pingidentity.admin.api.model.plugin.SaasPluginDescriptor;
import com.pingidentity.admin.api.model.plugin.SaasPluginFieldInfoDescriptor;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.admin.rest.translator.plugin.PluginConfigDescriptorTranslator;
import com.pingidentity.pf.admin.rest.translator.plugin.SaasFieldInfosTranslator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaasPluginTranslator {
    private static final Log log = LogFactory.getLog(SaasPluginTranslator.class);
    private final PluginConfigDescriptorTranslator configTranslator = new PluginConfigDescriptorTranslator();
    private final SaasFieldInfosTranslator fieldTranslator = new SaasFieldInfosTranslator();
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    public List<ValidationError> getValidationError() {
        return this.errors;
    }

    public void domainToApi(SaasProvisionerPlugin domainPlugin, SaasPluginDescriptor apiSaasPlugin) {
        apiSaasPlugin.setId(domainPlugin.getId());
        apiSaasPlugin.setDescription(domainPlugin.getDescription());
        try {
            ArrayList<SaasPluginFieldInfoDescriptor> saasPluginFieldInfoDescriptors = new ArrayList<SaasPluginFieldInfoDescriptor>();
            List fieldInfos = domainPlugin.getFieldsInfo();
            for (FieldInfo domainFieldInfo : fieldInfos) {
                SaasPluginFieldInfoDescriptor apiFieldInfo = new SaasPluginFieldInfoDescriptor();
                this.fieldTranslator.domainToApi(domainFieldInfo, apiFieldInfo);
                saasPluginFieldInfoDescriptors.add(apiFieldInfo);
            }
            apiSaasPlugin.setSaasPluginFieldInfoDescriptors(saasPluginFieldInfoDescriptors);
        }
        catch (SaasException e) {
            this.errors.add(this.errorFactory.create(ApiMessageKey.outbound_provisioning_plugin_load_failed, e.getMessage()));
            log.debug((Object)e.getStackTrace());
        }
        List descriptors = domainPlugin.getParameterDescriptors();
        PluginConfigDescriptor apiConfigDescriptor = this.configTranslator.domainToApi(descriptors);
        apiSaasPlugin.setConfigDescriptor(apiConfigDescriptor);
    }
}

