/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui;

import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AsUiAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AsActionOption selectedOption = null;
    private Tree.Node<AsUiAction> node;
    private String resultContext;
    private List<AttributeRule> attrRules = null;
    private String mappingApcId = "";
    private AttributeMapping apcAttributeMapping = null;
    private AttributeMapping fragmentMapping = null;
    private boolean fallBackToDefaultSuccess = true;
    private final AbstractPolicyState state;
    private final String nodeId;
    private String displayResultContext;
    private AttrMappingValue inputUserIdMapping;
    private LocalIdentityMappingAction localIdentityMappingAction = null;
    private boolean isCollapseChildren = false;
    private boolean isUserIdAuthenticated = false;
    private String displayName;

    public AsUiAction(AbstractPolicyState state, String resultContext) {
        this.state = state;
        this.resultContext = resultContext;
        this.nodeId = UUID.randomUUID().toString();
    }

    public AsUiAction(AbstractPolicyState state, String resultContext, AsActionOption selectedOption) {
        this.state = state;
        this.resultContext = resultContext;
        this.selectedOption = selectedOption;
        this.displayName = AsActionOption.getName(selectedOption);
        this.nodeId = UUID.randomUUID().toString();
    }

    public AsUiAction(AbstractPolicyState state, String resultContext, AsActionOption selectedOption, String displayName) {
        this.state = state;
        this.resultContext = resultContext;
        this.selectedOption = selectedOption;
        this.displayName = displayName;
        this.nodeId = UUID.randomUUID().toString();
    }

    public AsActionOption getSelectedOption() {
        return this.selectedOption;
    }

    public void setSelectedOption(AsActionOption newOption) {
        this.setSelectedOption(newOption, false);
    }

    public void setSelectedOption(AsActionOption newOption, boolean delayTreeUpdates) {
        boolean isNewOptionDifferent;
        boolean bl = isNewOptionDifferent = this.selectedOption == null && newOption != null || this.selectedOption != null && newOption == null || this.selectedOption != null && !this.selectedOption.equals(newOption);
        if (isNewOptionDifferent && delayTreeUpdates) {
            this.state.setSubmitRunnable(() -> this.setSelectedOption(newOption, false));
            return;
        }
        if (isNewOptionDifferent) {
            this.state.removeAttributeRulesAndMappings(this.node);
            this.state.removeNodeError(this.node);
            if (this.node.hasChildren()) {
                this.node.getChildren().clear();
                if (this.node.getData() != null && ((AsUiAction)this.node.getData()).getAttributeRules() != null) {
                    ((AsUiAction)this.node.getData()).setAttributeRules(new ArrayList<AttributeRule>());
                }
            }
            if (this.node.getData() != null) {
                ((AsUiAction)this.node.getData()).setCollapseChildren(false);
            }
            if (newOption != null) {
                AsActionOption.Type newType = newOption.getType();
                if (newType == AsActionOption.Type.ADAPTER || newType == AsActionOption.Type.CONNECTION) {
                    AsUiAction newAction = new AsUiAction(this.state, "Fail", null);
                    Tree.Node childNode = this.node.addChildData((Object)newAction);
                    newAction.setNode((Tree.Node<AsUiAction>)childNode);
                    newAction = new AsUiAction(this.state, "Success", null);
                    childNode = this.node.addChildData((Object)newAction);
                    newAction.setNode((Tree.Node<AsUiAction>)childNode);
                } else if (newType == AsActionOption.Type.SELECTOR) {
                    for (AuthnSelectorInstance plugin : this.state.getAuthnSelectorInstances()) {
                        if (!plugin.getId().equals(newOption.getId())) continue;
                        for (String result : plugin.getOrderedResults()) {
                            AsUiAction newAction = new AsUiAction(this.state, result);
                            Tree.Node childNode = this.node.addChildData((Object)newAction);
                            newAction.setNode((Tree.Node<AsUiAction>)childNode);
                        }
                        break;
                    }
                } else if (newType != AsActionOption.Type.CONTINUE && newType != AsActionOption.Type.DONE && newType != AsActionOption.Type.RESTART) {
                    if (newType == AsActionOption.Type.AUTHN_POLICY_CONTRACT) {
                        this.state.getApcMappingTasklet(newOption.getId(), this.node, null);
                        this.setMappingApcId(newOption.getId());
                    } else if (newType == AsActionOption.Type.LOCAL_IDENTITY_PROFILE) {
                        this.state.getLipMappingTasklet(newOption.getId(), this.node, null);
                        LocalIdentityProfile profile = MgmtFactory.getLocalIdentityProfileManager().getProfile(newOption.getId());
                        this.setMappingApcId(profile.getContractId());
                    } else if (newType == AsActionOption.Type.FRAGMENT) {
                        AsUiAction newAction = new AsUiAction(this.state, "Fail", null);
                        Tree.Node childNode = this.node.addChildData((Object)newAction);
                        newAction.setNode((Tree.Node<AsUiAction>)childNode);
                        newAction = new AsUiAction(this.state, "Success", null);
                        childNode = this.node.addChildData((Object)newAction);
                        newAction.setNode((Tree.Node<AsUiAction>)childNode);
                        this.state.getFragmentMappingTasklet(newOption.getId(), this.node, null);
                    } else {
                        throw new IllegalStateException("Unhandled action type");
                    }
                }
            }
            this.inputUserIdMapping = null;
            this.selectedOption = newOption;
            this.displayName = AsActionOption.getName(this.selectedOption);
            this.state.updatePossibleAttributeSourceOptions(this.node);
            this.state.loadAttributeContracts(this.selectedOption);
        }
    }

    public Tree.Node<AsUiAction> getNode() {
        return this.node;
    }

    public void setNode(Tree.Node<AsUiAction> node) {
        this.node = node;
    }

    public String getResultContext() {
        return this.resultContext;
    }

    public String getDisplayResultContext() {
        return StringUtils.isEmpty((String)this.displayResultContext) ? this.resultContext : this.displayResultContext;
    }

    public void setDisplayResultContext(String displayResultContext) {
        this.displayResultContext = displayResultContext;
    }

    public void setResultContext(String resultContext) {
        this.resultContext = resultContext;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public List<AttributeRule> getAttributeRules() {
        return this.attrRules;
    }

    public void setAttributeRules(List<AttributeRule> attrRules) {
        this.attrRules = attrRules;
    }

    public boolean isFallBackToDefaultSuccess() {
        return this.fallBackToDefaultSuccess;
    }

    public void setFallBackToDefaultSuccess(boolean fallBackToDefaultSuccess) {
        this.fallBackToDefaultSuccess = fallBackToDefaultSuccess;
    }

    public AttributeMapping getApcAttributeMapping() {
        return this.apcAttributeMapping;
    }

    public void setApcAttributeMapping(AttributeMapping apcAttributeMapping) {
        this.apcAttributeMapping = apcAttributeMapping;
    }

    public LocalIdentityMappingAction getLocalIdentityMappingAction() {
        return this.localIdentityMappingAction;
    }

    public void setLocalIdentityMappingAction(LocalIdentityMappingAction localIdentityMappingAction) {
        this.localIdentityMappingAction = localIdentityMappingAction;
    }

    public AbstractPolicyState getState() {
        return this.state;
    }

    public void setInputUserIdMapping(AttrMappingValue inputUserIdMapping) {
        this.inputUserIdMapping = inputUserIdMapping;
    }

    public AttrMappingValue getInputUserIdMapping() {
        return this.inputUserIdMapping;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getTypeAndId() {
        if (this.selectedOption != null) {
            String type = AsActionOption.getType(this.getSelectedOption().getType()).getTabTitle();
            String id = this.getSelectedOption().getId();
            if (this.getSelectedOption().getType().equals((Object)AsActionOption.Type.CONNECTION)) {
                ConnectionManager connManager = MgmtFactory.getConnectionManager();
                id = connManager.getIdpConnectionBySystemId(id).getEntityId();
            }
            return type + "-" + id;
        }
        return null;
    }

    public void setTypeAndId(String typeAndId) {
        if (StringUtils.isEmpty((String)typeAndId)) {
            this.setSelectedOption(null, true);
        } else {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(typeAndId);
            AsActionOption.Type type = AsActionOption.getType(option.getType());
            String id = option.getId();
            if (AsActionOption.Type.CONNECTION.equals((Object)type)) {
                ConnectionManager connManager = MgmtFactory.getConnectionManager();
                id = connManager.getIdpConnection(id).getId();
            }
            this.setSelectedOption(new AsActionOption(id, type), true);
        }
    }

    public boolean isRootNode() {
        Tree.Node ancestorNode = this.getNode().getParent();
        boolean isRoot = ancestorNode == null;
        return isRoot;
    }

    public boolean hasAuthnSourceAncestor() {
        AsActionOption ancestorOption;
        boolean isRoot;
        boolean hasAuthnSourceAncestor = false;
        Tree.Node ancestorNode = this.getNode().getParent();
        boolean bl = isRoot = ancestorNode == null;
        if (isRoot) {
            return false;
        }
        while (ancestorNode != null && (ancestorOption = ((AsUiAction)ancestorNode.getData()).getSelectedOption()) != null) {
            AuthenticationSelectorDescriptor descriptor;
            String selectorId;
            AuthnSelectorInstance instance;
            AsActionOption.Type type = ancestorOption.getType();
            if (type == AsActionOption.Type.ADAPTER || type == AsActionOption.Type.CONNECTION || type == AsActionOption.Type.FRAGMENT) {
                hasAuthnSourceAncestor = true;
                break;
            }
            if (type == AsActionOption.Type.SELECTOR && (instance = this.state.getAuthnSelectorInstanceById(selectorId = ancestorOption.getId())) != null && instance.getDescriptor() != null && instance.getDescriptor() instanceof AuthenticationSelectorDescriptor && (descriptor = (AuthenticationSelectorDescriptor)instance.getDescriptor()).canSelectAuthnSourceResultType()) {
                hasAuthnSourceAncestor = true;
                break;
            }
            ancestorNode = ancestorNode.getParent();
        }
        return hasAuthnSourceAncestor;
    }

    public boolean isContinueType() {
        return this.selectedOption != null && this.selectedOption.getType().equals((Object)AsActionOption.Type.CONTINUE);
    }

    public boolean isDoneType() {
        return this.selectedOption != null && this.selectedOption.getType().equals((Object)AsActionOption.Type.DONE);
    }

    public boolean isRestartType() {
        return this.selectedOption != null && this.selectedOption.getType().equals((Object)AsActionOption.Type.RESTART);
    }

    public boolean isNoOpActionType() {
        return this.isContinueType() || this.isDoneType() || this.isRestartType();
    }

    public boolean isCollapseChildren() {
        return this.isCollapseChildren;
    }

    public void setCollapseChildren(boolean collapseChildren) {
        this.isCollapseChildren = collapseChildren;
    }

    public AttributeMapping getFragmentMapping() {
        return this.fragmentMapping;
    }

    public void setFragmentMapping(AttributeMapping fragmentMapping) {
        this.fragmentMapping = fragmentMapping;
    }

    public String getMappingApcId() {
        return this.mappingApcId;
    }

    public void setMappingApcId(String mappingApcId) {
        this.mappingApcId = mappingApcId;
    }

    public boolean isUserIdAuthenticated() {
        return this.isUserIdAuthenticated;
    }

    public void setUserIdAuthenticated(boolean userIdAuthenticated) {
        this.isUserIdAuthenticated = userIdAuthenticated;
    }
}

