/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui;

import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.service.AuthnSourceKey;

public class FindDeletedPolicyNodesVisitor
implements TraversalVisitor<AuthnSelectionAction> {
    private List<String> invalidPolicyNodes = new ArrayList<String>();
    private List<String> errorMessages = new ArrayList<String>();
    boolean isRootValid;
    C2cContractManager apcManager;
    IdpAdapterManager idpAdapterManager;
    ConnectionManager connectionManager;
    PolicyFragmentManager fragmentManager;
    LocalIdentityManager localIdentityManager;
    AuthnSelectorManager selectorManager;

    public FindDeletedPolicyNodesVisitor(C2cContractManager apcManager, IdpAdapterManager idpAdapterManager, ConnectionManager connectionManager, PolicyFragmentManager fragmentManager, LocalIdentityManager lipManager, AuthnSelectorManager selectorManager) {
        this.apcManager = apcManager;
        this.idpAdapterManager = idpAdapterManager;
        this.connectionManager = connectionManager;
        this.fragmentManager = fragmentManager;
        this.localIdentityManager = lipManager;
        this.selectorManager = selectorManager;
        this.isRootValid = true;
    }

    public void visit(AuthnSelectionAction action, Tree.Node<AuthnSelectionAction> node) {
        String selectorId;
        boolean removeNode = false;
        if (action instanceof AuthnSourceAction) {
            AuthnSourceAction authnSourceAction = (AuthnSourceAction)action;
            AuthnSourceKey sourceKey = authnSourceAction.getAuthnSourceKey();
            switch (sourceKey.getType()) {
                case ADAPTER: {
                    String adapterId = sourceKey.getId();
                    if (this.idpAdapterManager.getInstance(adapterId) != null) break;
                    this.addErrorMessage(adapterId, "IdP Adapter", "Adapter");
                    removeNode = true;
                    break;
                }
                case IDP_CONN: {
                    String connId = sourceKey.getId();
                    if (this.connectionManager.getIdpConnectionBySystemId(connId) != null) break;
                    this.addErrorMessage(connId, "IdP Connection", "IdP Connection");
                    removeNode = true;
                    break;
                }
            }
        } else if (action instanceof ApcMappingAction) {
            String apcId = ((ApcMappingAction)action).getApcId();
            if (this.apcManager.getContract(apcId) == null) {
                this.addErrorMessage(apcId, "Authentication Policy Contract", "contract");
                removeNode = true;
            }
        } else if (action instanceof FragmentAction) {
            String fragmentId = ((FragmentAction)action).getFragmentId();
            if (this.fragmentManager.getFragment(fragmentId) == null) {
                this.addErrorMessage(fragmentId, "Policy Fragment", "Fragment");
                removeNode = true;
            }
        } else if (action instanceof LocalIdentityMappingAction) {
            String lipId = ((LocalIdentityMappingAction)action).getLipId();
            if (this.localIdentityManager.getProfile(lipId) == null) {
                this.addErrorMessage(lipId, "Local Identity Profile", "Local Identity Profile");
                removeNode = true;
            }
        } else if (action instanceof AuthnSelectorAction && this.selectorManager.getAuthenticationSelector(selectorId = ((AuthnSelectorAction)action).getAuthnSelectorId()) == null) {
            this.addErrorMessage(selectorId, "Authentication Selector", "Selector");
            removeNode = true;
        }
        if (removeNode) {
            Tree.Node parent = node.getParent();
            if (parent != null) {
                int index;
                List children = parent.getChildren();
                String currentContext = ((AuthnSelectionAction)node.getData()).getContext();
                for (index = 0; index < children.size() && !((AuthnSelectionAction)((Tree.Node)children.get(index)).getData()).getContext().equals(currentContext); ++index) {
                }
                parent.getChildren().remove(index);
                Tree.Node emptyNode = new Tree.Node((Object)new NoOpAction(NoOpAction.Type.EMPTY));
                ((AuthnSelectionAction)emptyNode.getData()).setContext(currentContext);
                parent.addChildNode(emptyNode);
            } else {
                this.isRootValid = false;
            }
        }
    }

    public boolean continueTraversal() {
        return this.isRootValid;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public boolean isRootValid() {
        return this.isRootValid;
    }

    private void addErrorMessage(String id, String nodeTypeLabel, String nodeType) {
        String key = nodeType + "-" + id;
        if (!this.invalidPolicyNodes.contains(key)) {
            this.invalidPolicyNodes.add(key);
            this.errorMessages.add("The " + nodeTypeLabel + " with the ID " + id + " is no longer valid. Policy nodes using this " + nodeType + " have been removed from the pasted tree.");
        }
    }
}

