/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.authnselection.ui;

import com.pingidentity.admin.api.validator.OgnlExpressionValidator;
import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;

public class FindInvalidAttributeSourcesVisitor
implements TraversalVisitor<AsUiAction> {
    final List rulesSourceTypes = Arrays.asList(AsActionOption.Type.ADAPTER, AsActionOption.Type.CONNECTION, AsActionOption.Type.FRAGMENT);
    final List<SourceType> authnSourceSourceTypes = Arrays.asList(SourceType.ADAPTER, SourceType.IDP_CONNECTION);
    final Map<String, List<String>> availableSourceIdsMap;
    final Map<String, Set<String>> availableTypesToAttributesMap;
    final Map<String, List<String>> availableUpstreamAttributesMap;
    final Map<String, String> idsToExpressionIds;
    List<String> nodeIdsWithInvalidAttributeSources;
    List<String> nodeIdsWithInvalidIncomingUserId;
    List<String> nodeIdsWithInvalidRule;

    public FindInvalidAttributeSourcesVisitor(Map<String, List<String>> availableSourceIdsMap, Map<String, Set<String>> availableTypesToAttributesMap, Map<String, List<String>> availableUpstreamAttributesMap, Map<String, String> idsToExpressionIds) {
        this.availableSourceIdsMap = availableSourceIdsMap;
        this.availableTypesToAttributesMap = availableTypesToAttributesMap;
        this.availableUpstreamAttributesMap = availableUpstreamAttributesMap;
        this.idsToExpressionIds = idsToExpressionIds;
        this.nodeIdsWithInvalidAttributeSources = new ArrayList<String>();
        this.nodeIdsWithInvalidIncomingUserId = new ArrayList<String>();
        this.nodeIdsWithInvalidRule = new ArrayList<String>();
    }

    public void visit(AsUiAction data, Tree.Node<AsUiAction> node) {
        List availableSourceIds = this.availableSourceIdsMap.get(((AsUiAction)node.getData()).getNodeId());
        if (availableSourceIds == null) {
            availableSourceIds = Collections.EMPTY_LIST;
        }
        ArrayList<String> referencedAuthnSources = new ArrayList();
        if (data.getSelectedOption() != null) {
            List<AttributeRule> rules;
            AttrMappingValue mappingValue;
            if (data.getSelectedOption().getType() == AsActionOption.Type.AUTHN_POLICY_CONTRACT) {
                AttributeMapping mapping = data.getApcAttributeMapping();
                referencedAuthnSources = this.findReferencedAuthnSources(mapping);
            } else if (data.getSelectedOption().getType() == AsActionOption.Type.LOCAL_IDENTITY_PROFILE) {
                if (data.getLocalIdentityMappingAction() != null) {
                    AttributeMapping inboundMapping = data.getLocalIdentityMappingAction().getInboundAttributeMapping();
                    AttributeMapping outboundMapping = data.getLocalIdentityMappingAction().getOutboundAttributeMapping();
                    AttributeMapping contractMapping = data.getLocalIdentityMappingAction().getAttributeMapping();
                    referencedAuthnSources = this.findReferencedAuthnSources(inboundMapping);
                    this.addWithoutDuplicates(referencedAuthnSources, this.findReferencedAuthnSources(outboundMapping));
                    this.addWithoutDuplicates(referencedAuthnSources, this.findReferencedAuthnSources(contractMapping));
                }
            } else if (data.getSelectedOption().getType() == AsActionOption.Type.FRAGMENT) {
                AttributeMapping fragmentMapping = data.getFragmentMapping();
                referencedAuthnSources = this.findReferencedAuthnSources(fragmentMapping);
            } else if ((data.getSelectedOption().getType() == AsActionOption.Type.ADAPTER || data.getSelectedOption().getType() == AsActionOption.Type.CONNECTION) && (mappingValue = data.getInputUserIdMapping()) != null) {
                String authnSrcKey = AbstractPolicyState.getAuthnSourceKey(mappingValue.getAttributeSourceId(), mappingValue.getType());
                Set<String> availableAttributesForSrcKey = this.availableTypesToAttributesMap.get(authnSrcKey);
                if (!(mappingValue.getAttributeSourceId() == null || availableSourceIds.contains(authnSrcKey) && availableAttributesForSrcKey.contains(mappingValue.getValue()))) {
                    this.nodeIdsWithInvalidIncomingUserId.add(((AsUiAction)node.getData()).getNodeId());
                }
            }
            if (this.rulesSourceTypes.contains((Object)data.getSelectedOption().getType()) && (rules = data.getAttributeRules()) != null) {
                Map<String, String> substitutionMap = this.getSubstitutionMap(((AsUiAction)node.getData()).getNodeId());
                for (AttributeRule rule : rules) {
                    if (rule.getAuthenticationSourceType() == null) {
                        AsActionOption selectedOption = ((AsUiAction)node.getData()).getSelectedOption();
                        Set availableAttributesMap = this.availableTypesToAttributesMap.getOrDefault(AbstractPolicyState.getAuthnSourceKey(selectedOption.getId(), selectedOption.getType()), Collections.emptySet());
                        if (availableAttributesMap.contains(rule.getAttribute()) || this.nodeIdsWithInvalidRule.contains(((AsUiAction)node.getData()).getNodeId())) continue;
                        this.nodeIdsWithInvalidRule.add(((AsUiAction)node.getData()).getNodeId());
                        continue;
                    }
                    if (SourceType.EXPRESSION.equals((Object)rule.getAuthenticationSourceType())) {
                        if (ExpressionManager.getInstance().isEvaluateExpressionsOff()) {
                            if (this.nodeIdsWithInvalidRule.contains(((AsUiAction)node.getData()).getNodeId())) continue;
                            this.nodeIdsWithInvalidRule.add(((AsUiAction)node.getData()).getNodeId());
                            continue;
                        }
                        OgnlExpressionValidator ognlExpressionValidator = new OgnlExpressionValidator(rule.getExpression(), "", true, substitutionMap, false);
                        ognlExpressionValidator.validate();
                        if (!ognlExpressionValidator.hasErrors() || this.nodeIdsWithInvalidRule.contains(((AsUiAction)node.getData()).getNodeId())) continue;
                        this.nodeIdsWithInvalidRule.add(((AsUiAction)node.getData()).getNodeId());
                        continue;
                    }
                    String authnSourceId = SourceType.CONTEXT.equals((Object)rule.getAuthenticationSourceType()) ? "rulesContext" : rule.getAuthenticationSourceId();
                    String authnSourceKey = AbstractPolicyState.getAuthnSourceKey(authnSourceId, rule.getAuthenticationSourceType());
                    List sourceAttributeList = this.availableUpstreamAttributesMap.getOrDefault(((AsUiAction)node.getData()).getNodeId(), Collections.emptyList());
                    Set availableAttributesMap = this.availableTypesToAttributesMap.getOrDefault(authnSourceKey, Collections.emptySet());
                    String ruleAttribute = rule.getAttribute();
                    if (SourceType.CONTEXT.equals((Object)rule.getAuthenticationSourceType())) {
                        ruleAttribute = SourceContextType.getTypeFromId((String)ruleAttribute).getDescription();
                    }
                    if (sourceAttributeList.contains(authnSourceKey) && availableAttributesMap.contains(ruleAttribute) || this.nodeIdsWithInvalidRule.contains(((AsUiAction)node.getData()).getNodeId())) continue;
                    this.nodeIdsWithInvalidRule.add(((AsUiAction)node.getData()).getNodeId());
                }
            }
        }
        boolean error = false;
        for (String referenced : referencedAuthnSources) {
            if (availableSourceIds.contains(referenced)) continue;
            error = true;
            break;
        }
        if (error) {
            this.nodeIdsWithInvalidAttributeSources.add(((AsUiAction)node.getData()).getNodeId());
        }
    }

    public void addWithoutDuplicates(List<String> list1, List<String> list2) {
        for (String s : list2) {
            if (list1.contains(s)) continue;
            list1.add(s);
        }
    }

    public List<String> getNodeIdsWithInvalidAttributeSources() {
        return this.nodeIdsWithInvalidAttributeSources;
    }

    public List<String> getNodeIdsWithInvalidIncomingUserId() {
        return this.nodeIdsWithInvalidIncomingUserId;
    }

    public List<String> getNodeIdsWithInvalidRule() {
        return this.nodeIdsWithInvalidRule;
    }

    public List<String> findReferencedAuthnSources(AttributeMapping mapping) {
        ArrayList<String> referencedAuthnSources = new ArrayList<String>();
        if (mapping != null) {
            Map attrMapping = mapping.getAttributeMapping();
            if (attrMapping != null) {
                for (List mappings : attrMapping.values()) {
                    for (AttrMappingValue value : mappings) {
                        if (!this.authnSourceSourceTypes.contains(value.getType()) || referencedAuthnSources.contains(value.getAttributeSourceId())) continue;
                        referencedAuthnSources.add(value.getAttributeSourceId());
                    }
                }
            }
            List issuanceCriteria = mapping.getTokenAuthorizationIssuanceCriteria();
            for (TokenAuthorizationIssuanceCriterion criterion : issuanceCriteria) {
                if (!this.authnSourceSourceTypes.contains(criterion.getAttrSourceType()) || referencedAuthnSources.contains(criterion.getAttrSourceId())) continue;
                referencedAuthnSources.add(criterion.getAttrSourceId());
            }
        }
        return referencedAuthnSources;
    }

    public boolean continueTraversal() {
        return true;
    }

    private Map<String, String> getSubstitutionMap(String nodeId) {
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        if (this.availableUpstreamAttributesMap.containsKey(nodeId)) {
            List<String> upStreamSources = this.availableUpstreamAttributesMap.get(nodeId);
            upStreamSources.forEach(upstreamSourceAuthnKey -> {
                block10: {
                    Object substitutionPrefix;
                    SourceType sourceType;
                    block11: {
                        if (!this.availableTypesToAttributesMap.containsKey(upstreamSourceAuthnKey)) break block10;
                        sourceType = AbstractPolicyState.getSourceTypeFromAuthnSourceKey(upstreamSourceAuthnKey);
                        if (!SourceType.CONTEXT.equals((Object)sourceType)) break block11;
                        for (String attribute : this.availableTypesToAttributesMap.get(upstreamSourceAuthnKey)) {
                            SourceContextType contextType = SourceContextType.getTypeFromDescription((String)attribute);
                            substitutionMap.put(contextType.getId(), contextType.getId());
                        }
                        break block10;
                    }
                    String sourceId = AbstractPolicyState.getSourceIdFromAuthnSourceKey(upstreamSourceAuthnKey);
                    switch (sourceType) {
                        case ADAPTER: {
                            substitutionPrefix = "ad." + sourceId + ".";
                            break;
                        }
                        case IDP_CONNECTION: {
                            substitutionPrefix = "idp." + this.idsToExpressionIds.get(upstreamSourceAuthnKey) + ".";
                            break;
                        }
                        case INPUTS: {
                            substitutionPrefix = "fragment.Inputs.";
                            break;
                        }
                        case FRAGMENT: {
                            substitutionPrefix = "fragment." + sourceId + ".";
                            break;
                        }
                        case TRACKED_HTTP_PARAMS: {
                            substitutionPrefix = "trackedparams.";
                            break;
                        }
                        case EXTENDED_PROPERTIES: {
                            substitutionPrefix = "extproperties.";
                            break;
                        }
                        default: {
                            substitutionPrefix = null;
                        }
                    }
                    if (substitutionPrefix == null) break block10;
                    for (String attribute : this.availableTypesToAttributesMap.get(upstreamSourceAuthnKey)) {
                        substitutionMap.put((String)substitutionPrefix + attribute, (String)substitutionPrefix + attribute);
                    }
                }
            });
        }
        return substitutionMap;
    }
}

