/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.ConnMgmtState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.ConnectionImageType;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.util.EnumPropertySelectionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public class ConnMgmt
extends TaskletCard {
    public static final EnumPropertySelectionModel PROTOCOL_MODEL = new EnumPropertySelectionModel();

    public void create(IRequestCycle cycle) {
        ((ConnMgmtState)this.getCurrentState()).create(cycle);
    }

    public void importConnection(IRequestCycle cycle) {
        ((ConnMgmtState)this.getCurrentState()).importConnection(cycle);
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        state.sortAndFilter();
        PROTOCOL_MODEL.clear();
        ArrayList<ConnectionImageType> protocols = new ArrayList<ConnectionImageType>(Arrays.asList(ConnectionImageType.values()));
        protocols.sort(Comparator.comparing(ConnectionImageType::getLabel));
        protocols.stream().filter(connectionImageType -> this.isProtocolEnabled((ConnectionImageType)((Object)connectionImageType), state.getConnectionType().equals((Object)ConnectionType.SP))).forEachOrdered(PROTOCOL_MODEL::add);
    }

    public void toggleAdvancedSearch(IRequestCycle cycle) {
        ConnMgmtState state;
        state.setShowAdvancedSearch(!(state = (ConnMgmtState)this.getCurrentState()).isShowAdvancedSearch());
    }

    private boolean isProtocolEnabled(ConnectionImageType connectionImageType, boolean isSPConnection) {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        LocalSettings localSettings = state.getLocalSettings();
        if (isSPConnection) {
            switch (connectionImageType) {
                case ALL: {
                    return true;
                }
                case SAML20: {
                    return localSettings.isEnableSamlIdP();
                }
                case SAML11: {
                    return localSettings.isEnableSamlOneOneAp();
                }
                case SAML10: {
                    return localSettings.isEnableSamlOneZeroAp();
                }
                case WSFED: {
                    return localSettings.isEnableWsFedIdP();
                }
                case WSTRUST: {
                    return localSettings.isEnableWsTrustIdP();
                }
                case OUTBOUNDPROVISIONING: {
                    return localSettings.isEnableOutboundProvisioning();
                }
            }
        } else {
            switch (connectionImageType) {
                case ALL: {
                    return true;
                }
                case SAML20: {
                    return localSettings.isEnableSamlSp();
                }
                case SAML11: {
                    return localSettings.isEnableSamlOneOneRp();
                }
                case SAML10: {
                    return localSettings.isEnableSamlOneZeroRp();
                }
                case WSFED: {
                    return localSettings.isEnableWsFedSp();
                }
                case WSTRUST: {
                    return localSettings.isEnableWsTrustSp();
                }
                case INBOUNDPROVISIONING: {
                    return localSettings.isEnableInboundProvisioning();
                }
                case OIDC: {
                    return localSettings.isEnableOIDCSp();
                }
                case OAUTHASSERTIONGRANT: {
                    return MgmtFactory.getAuthzServerManager().isEnableOAuth();
                }
            }
        }
        return false;
    }

    public void sortConnName(IRequestCycle cycle) {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        if (state.getSortBy() == ConnMgmtState.SORT_BY.Name) {
            state.setSortConnNameUp(!state.isSortConnNameUp());
        }
        state.setSortBy(ConnMgmtState.SORT_BY.Name);
    }

    public void sortConnId(IRequestCycle cycle) {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        if (state.getSortBy() == ConnMgmtState.SORT_BY.Id) {
            state.setSortConnIdUp(!state.isSortConnIdUp());
        }
        state.setSortBy(ConnMgmtState.SORT_BY.Id);
    }

    public void sortVirtualIdentity(IRequestCycle cycle) {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        if (state.getSortBy() == ConnMgmtState.SORT_BY.VirtualIdentity) {
            state.setSortVirtualIdentityUp(!state.isSortVirtualIdentityUp());
        }
        state.setSortBy(ConnMgmtState.SORT_BY.VirtualIdentity);
    }

    public void sortModificationTime(IRequestCycle cycle) {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        if (state.getSortBy() == ConnMgmtState.SORT_BY.ModificationTime) {
            state.setSortModificationTimeUp(!state.isSortModificationTimeUp());
        }
        state.setSortBy(ConnMgmtState.SORT_BY.ModificationTime);
    }

    public void sortCreationTime(IRequestCycle cycle) {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        if (state.getSortBy() == ConnMgmtState.SORT_BY.CreationTime) {
            state.setSortCreationTimeUp(!state.isSortCreationTimeUp());
        }
        state.setSortBy(ConnMgmtState.SORT_BY.CreationTime);
    }

    public boolean isConnNameUp() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return state.isSortConnNameUp() && state.getSortBy() == ConnMgmtState.SORT_BY.Name;
    }

    public boolean isConnNameDown() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return !state.isSortConnNameUp() && state.getSortBy() == ConnMgmtState.SORT_BY.Name;
    }

    public boolean isConnIdUp() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return state.isSortConnIdUp() && state.getSortBy() == ConnMgmtState.SORT_BY.Id;
    }

    public boolean isConnIdDown() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return !state.isSortConnIdUp() && state.getSortBy() == ConnMgmtState.SORT_BY.Id;
    }

    public boolean isVirtualIdentityUp() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return state.isSortVirtualIdentityUp() && state.getSortBy() == ConnMgmtState.SORT_BY.VirtualIdentity;
    }

    public boolean isVirtualIdentityDown() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return !state.isSortVirtualIdentityUp() && state.getSortBy() == ConnMgmtState.SORT_BY.VirtualIdentity;
    }

    public boolean isModificationTimeUp() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return state.isSortModificationTimeUp() && state.getSortBy() == ConnMgmtState.SORT_BY.ModificationTime;
    }

    public boolean isModificationTimeDown() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return !state.isSortModificationTimeUp() && state.getSortBy() == ConnMgmtState.SORT_BY.ModificationTime;
    }

    public boolean isCreationTimeUp() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return state.isSortCreationTimeUp() && state.getSortBy() == ConnMgmtState.SORT_BY.CreationTime;
    }

    public boolean isCreationTimeDown() {
        ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
        return !state.isSortCreationTimeUp() && state.getSortBy() == ConnMgmtState.SORT_BY.CreationTime;
    }

    public boolean isLicenseGroupDefined() {
        return LicenseManager.isConnectionGroupDefined();
    }
}

