/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.fsm.state.impl.GeneralInfoState;
import com.pingidentity.fsm.state.impl.OIDCDiscoveryMetadata;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.IOException;
import javax.net.ssl.SSLException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.common.ValidationUtil;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.util.ObjectMapperFactory;

public class GeneralInfo
extends TaskletCard {
    private static final ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();
    private static Logger logger = LogManager.getLogger(GeneralInfo.class);

    public void onLoadMetadata(IRequestCycle cycle) {
        if (this.getCurrentUser().isAuditor()) {
            return;
        }
        GeneralInfoState state = (GeneralInfoState)this.getCurrentState();
        state.setMetaDataLoaded(false);
        if (StringUtils.isBlank((String)state.getConnId())) {
            String msg = state.getMessage("Metadata_Empty_Issuer");
            state.recordErrorMsg(msg);
            return;
        }
        if (!ValidationUtil.isValidHttpsUrl((String)state.getConnId())) {
            ValidationError error = ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.general_info_issuer_invalid, null);
            String msg = error.getMessage();
            state.recordErrorMsg(msg);
            return;
        }
        String endpoint = state.getConnId() + "/.well-known/openid-configuration";
        try {
            HttpGet request = new HttpGet(endpoint);
            logger.info("Connecting to OIDC Discovery endpoint " + request.getRequestLine());
            String responseBody = HttpConnectionPoolingManager.getInstance().doRequest((HttpRequestBase)request);
            ObjectReader reader = mapper.reader(OIDCDiscoveryMetadata.class);
            OIDCDiscoveryMetadata result = (OIDCDiscoveryMetadata)reader.readValue(responseBody);
            state.loadMetadata(result);
        }
        catch (IllegalArgumentException e) {
            String msg = state.getMessage("Metadata_Error", new Object[]{endpoint});
            logger.warn(msg);
            state.recordErrorMsg(msg);
        }
        catch (SSLException e) {
            String msg = state.getMessage("Metadata_Cert_Error", new Object[]{endpoint});
            logger.warn(msg);
            state.recordErrorMsg(msg);
        }
        catch (IOException e) {
            String msg = state.getMessage("Metadata_Error", new Object[]{endpoint});
            logger.warn(msg);
            state.recordErrorMsg(msg);
        }
    }
}

