/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.fsm.state.impl.ManageDataSourcesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import java.util.Comparator;
import org.apache.tapestry.IRequestCycle;

public class ManageDataSources
extends TaskletCard {
    private static final Comparator<Tasklet> COMPARE_BY_NAME_DOWN = new Comparator<Tasklet>(){

        @Override
        public int compare(Tasklet t1, Tasklet t2) {
            if (!(t1 instanceof DataSourceTasklet) || !(t2 instanceof DataSourceTasklet)) {
                return t1 instanceof DataSourceTasklet ? 1 : -1;
            }
            DataSourceTasklet dsTasklet1 = (DataSourceTasklet)t1;
            DataSourceTasklet dsTasklet2 = (DataSourceTasklet)t2;
            return dsTasklet1.getDesc().compareToIgnoreCase(dsTasklet2.getDesc());
        }
    };

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        TaskletListState state = (TaskletListState)this.getCurrentState();
        state.refreshTasklets();
        state.sort(COMPARE_BY_NAME_DOWN);
    }

    public void addNewDataSource(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            DataSourceTasklet dataSourceTasklet = this.createTaskletToLoad(DataSourceTasklet.class);
            dataSourceTasklet.markProtocolImgAvailable(this.getCurrentState().getParent().isProtocolImgAvailable());
            dataSourceTasklet.setMode(Mode.create);
            dataSourceTasklet.setFinishLabel("Save");
            this.loadTasklet(dataSourceTasklet);
        }
    }

    public void edit(IRequestCycle cycle) {
        DataSourceTasklet tasklet;
        ManageDataSourcesState state = (ManageDataSourcesState)this.getCurrentState();
        Object[] params = cycle.getServiceParameters();
        Integer dataSourceToEdit = (Integer)params[0];
        if (dataSourceToEdit != null && (tasklet = (DataSourceTasklet)state.getTasklet(dataSourceToEdit)) != null) {
            tasklet.setDataSourceTaskletInitialState(tasklet.getSelectedDataSourceType());
            tasklet.resetCurrentStateToSourceState();
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            this.loadTasklet(tasklet);
            tasklet.gotoSummaryState(cycle);
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            ManageDataSourcesState state = (ManageDataSourcesState)this.getCurrentState();
            Object[] params = cycle.getServiceParameters();
            Integer dataSourceToDelete = (Integer)params[0];
            state.deleteTasklet(dataSourceToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("manage data sources");
        }
    }
}

