/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.component.common.Pagination;
import com.pingidentity.fsm.state.impl.OAuthClientManagementTasklet;
import com.pingidentity.fsm.state.impl.OAuthClientsManagementState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.Mode;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.domain.log.AdminAuditLogger;

public class OAuthClientsManagement
extends TaskletCard {
    public void edit(IRequestCycle cycle) {
        Object[] params;
        String clientToEdit;
        OAuthClientsManagementState state = this.getState();
        OAuthClientManagementTasklet tasklet = state.getEditTasklet(clientToEdit = (String)(params = cycle.getServiceParameters())[0]);
        if (tasklet == null) {
            tasklet = state.createTasklet(OAuthClientManagementTasklet.class);
            tasklet.setFinishLabel("Save");
            tasklet.setUpdate(true);
            tasklet.setMode(Mode.edit);
            OAuthClientManagementTasklet.Operation current = tasklet.getOperation();
            if (current != OAuthClientManagementTasklet.Operation.INSERT) {
                tasklet.setOperation(OAuthClientManagementTasklet.Operation.UPDATE);
            }
        }
        Client client = state.getClient(clientToEdit);
        tasklet.populate(client);
        this.loadTasklet(tasklet);
        tasklet.setInitialState(tasklet.getoAuthClientManagementState());
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            OAuthClientsManagementState state = this.getState();
            Object[] params = cycle.getServiceParameters();
            String clientToDelete = (String)params[0];
            state.delete(clientToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("oauth clients management");
        }
    }

    public void toggle(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            OAuthClientsManagementState state = this.getState();
            Object[] params = cycle.getServiceParameters();
            String clientToToggle = (String)params[0];
            state.toggle(clientToToggle);
        } else {
            String newMessage = "Unauthorized user attempting a enable or disable for oauth clients management";
            AdminAuditLogger.log((AdminAuditLogger.Component)AdminAuditLogger.Component.USER, (AdminAuditLogger.Event)AdminAuditLogger.Event.MODIFY, (String)newMessage);
        }
    }

    public void addClient(IRequestCycle cycle) {
        OAuthClientsManagementState state = this.getState();
        if (!state.getDelegate().getHasErrors()) {
            OAuthClientManagementTasklet tasklet = this.createTaskletToLoad(OAuthClientManagementTasklet.class);
            tasklet.setFinishLabel("Save");
            tasklet.populate(null);
            tasklet.setOperation(OAuthClientManagementTasklet.Operation.INSERT);
            tasklet.setMode(Mode.create);
            this.loadTasklet(tasklet);
        }
    }

    public void resetPaginationControls(IRequestCycle cycle) {
        OAuthClientsManagementState state = this.getState();
        ((Pagination.State)state.getPaginationState()).reset();
    }

    private OAuthClientsManagementState getState() {
        return (OAuthClientsManagementState)this.getCurrentState();
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        OAuthClientsManagementState state = this.getState();
        state.sortAndFilter();
    }

    public void sortClientName(IRequestCycle cycle) {
        OAuthClientsManagementState state = this.getState();
        if (state.getSortBy() == OAuthClientsManagementState.SORT_BY.Name) {
            state.setSortClientNameUp(!state.isSortClientNameUp());
        }
        state.setSortBy(OAuthClientsManagementState.SORT_BY.Name);
    }

    public void sortClientId(IRequestCycle cycle) {
        OAuthClientsManagementState state = this.getState();
        if (state.getSortBy() == OAuthClientsManagementState.SORT_BY.Id) {
            state.setSortClientIdUp(!state.isSortClientIdUp());
        }
        state.setSortBy(OAuthClientsManagementState.SORT_BY.Id);
    }

    public void sortModificationTime(IRequestCycle cycle) {
        OAuthClientsManagementState state = this.getState();
        if (state.getSortBy() == OAuthClientsManagementState.SORT_BY.ModificationTime) {
            state.setSortModificationTimeUp(!state.isSortModificationTimeUp());
        }
        state.setSortBy(OAuthClientsManagementState.SORT_BY.ModificationTime);
    }

    public void sortCreationTime(IRequestCycle cycle) {
        OAuthClientsManagementState state = this.getState();
        if (state.getSortBy() == OAuthClientsManagementState.SORT_BY.CreationTime) {
            state.setSortCreationTimeUp(!state.isSortCreationTimeUp());
        }
        state.setSortBy(OAuthClientsManagementState.SORT_BY.CreationTime);
    }

    public boolean isClientNameUp() {
        OAuthClientsManagementState state = this.getState();
        return state.isSortClientNameUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.Name;
    }

    public boolean isClientNameDown() {
        OAuthClientsManagementState state = this.getState();
        return !state.isSortClientNameUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.Name;
    }

    public boolean isClientIdUp() {
        OAuthClientsManagementState state = this.getState();
        return state.isSortClientIdUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.Id;
    }

    public boolean isClientIdDown() {
        OAuthClientsManagementState state = this.getState();
        return !state.isSortClientIdUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.Id;
    }

    public boolean isModificationTimeUp() {
        OAuthClientsManagementState state = this.getState();
        return state.isSortModificationTimeUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.ModificationTime;
    }

    public boolean isModificationTimeDown() {
        OAuthClientsManagementState state = this.getState();
        return !state.isSortModificationTimeUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.ModificationTime;
    }

    public boolean isCreationTimeUp() {
        OAuthClientsManagementState state = this.getState();
        return state.isSortCreationTimeUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.CreationTime;
    }

    public boolean isCreationTimeDown() {
        OAuthClientsManagementState state = this.getState();
        return !state.isSortCreationTimeUp() && state.getSortBy() == OAuthClientsManagementState.SORT_BY.CreationTime;
    }

    public void toggleAdvancedSearch(IRequestCycle cycle) {
        OAuthClientsManagementState state;
        state.setShowAdvancedSearch(!(state = this.getState()).isShowAdvancedSearch());
    }
}

