/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card;

import com.pingidentity.component.card.TaskletListCardUser;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;

public abstract class TaskletListCard
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract IBinding getParentBinding();

    public abstract IBinding getTaskletsBinding();

    public abstract String getFirstColumnHeader();

    public abstract boolean getHasSecondColumn();

    public abstract String getSecondColumnHeader();

    public abstract boolean getHasThirdColumn();

    public abstract String getThirdColumnHeader();

    public abstract boolean getHasFourthColumn();

    public abstract String getFourthColumnHeader();

    public List<Tasklet> getTasklets() {
        List<Tasklet> tasklets = new ArrayList<Tasklet>();
        IBinding binding = this.getTaskletsBinding();
        if (binding != null) {
            tasklets = (List)binding.getObject("tasklets", List.class);
        }
        return tasklets;
    }

    public TaskletListCardUser getParent() {
        TaskletListCardUser parent = null;
        IBinding binding = this.getParentBinding();
        if (binding != null) {
            parent = (TaskletListCardUser)binding.getObject("parent", TaskletListCardUser.class);
        }
        return parent;
    }

    public void edit(IRequestCycle cycle) {
        List<Tasklet> tasklets;
        Object[] params = cycle.getServiceParameters();
        Integer taskletToEditIndex = (Integer)params[0];
        if (taskletToEditIndex != null && (tasklets = this.getTasklets()).size() > taskletToEditIndex) {
            Tasklet taskletToEdit = tasklets.get(taskletToEditIndex);
            taskletToEdit.resetCurrentStateToSourceState();
            this.loadTasklet(taskletToEdit);
            taskletToEdit.gotoSummaryState(cycle);
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            List<Tasklet> tasklets;
            Object[] params = cycle.getServiceParameters();
            Integer taskletToDeleteIndex = (Integer)params[0];
            if (taskletToDeleteIndex != null && (tasklets = this.getTasklets()).size() > taskletToDeleteIndex) {
                Tasklet taskletToDelete = tasklets.get(taskletToDeleteIndex);
                taskletToDelete.setItDeleted(true);
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("adapter or c2cContract");
        }
    }

    public void undelete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            List<Tasklet> tasklets;
            Object[] params = cycle.getServiceParameters();
            Integer taskletToUndeleteIndex = (Integer)params[0];
            if (taskletToUndeleteIndex != null && (tasklets = this.getTasklets()).size() > taskletToUndeleteIndex) {
                Tasklet taskletToUndelete = tasklets.get(taskletToUndeleteIndex);
                taskletToUndelete.setItDeleted(false);
            }
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("adapter or c2cContract");
        }
    }

    public String getFirstColumnData(Tasklet t) {
        return this.getParent().getFirstColumnData(t);
    }

    public String getSecondColumnData(Tasklet t) {
        return this.getParent().getSecondColumnData(t);
    }

    public String getThirdColumnData(Tasklet t) {
        return this.getParent().getThirdColumnData(t);
    }

    public String getFourthColumnData(Tasklet t) {
        return this.getParent().getFourthColumnData(t);
    }

    public boolean enableActionColumn() {
        return this.getParent().enableActionColumn();
    }
}

