/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card.oauth.exchange;

import com.pingidentity.fsm.state.impl.oauth.exchange.BasePoliciesManagementState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.BasePolicyManagementTasklet;
import java.util.Optional;
import org.apache.tapestry.IRequestCycle;

public abstract class BasePoliciesManagementCard<T extends BasePolicyManagementTasklet, TS extends BasePoliciesManagementState>
extends TaskletCard {
    private final Class<T> tClass;
    private final Class<TS> tsClass;
    private int taskletListSize;
    private boolean wasAddClicked;

    public BasePoliciesManagementCard(Class<T> tClass, Class<TS> tsClass) {
        this.tClass = tClass;
        this.tsClass = tsClass;
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        TaskletListState state = (TaskletListState)this.getCurrentState();
        state.refreshTasklets();
    }

    public void addPolicy(IRequestCycle cycle) {
        if (!this.isAuthorizedForAction()) {
            return;
        }
        TS state = this.getState();
        if (!((TaskletState)state).getDelegate().getHasErrors()) {
            this.taskletListSize = ((TaskletListState)state).getTaskletListSize();
            this.wasAddClicked = true;
            BasePolicyManagementTasklet tasklet = (BasePolicyManagementTasklet)this.createTaskletToLoad(this.tClass);
            tasklet.setMode(Mode.create);
            tasklet.setFinishLabel("Save");
            this.loadTasklet(tasklet);
        }
    }

    public void edit(IRequestCycle cycle) {
        Object[] params;
        String idToEdit;
        TS state = this.getState();
        Optional taskletToEditOptional = ((BasePoliciesManagementState)state).getTaskletById(idToEdit = (String)(params = cycle.getServiceParameters())[0]);
        if (taskletToEditOptional.isPresent()) {
            BasePolicyManagementTasklet tasklet = (BasePolicyManagementTasklet)taskletToEditOptional.get();
            tasklet.setMode(Mode.edit);
            tasklet.setFinishLabel("Save");
            this.loadTasklet(tasklet);
            tasklet.gotoSummaryState(cycle);
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            TS state = this.getState();
            Object[] params = cycle.getServiceParameters();
            String policyToDelete = (String)params[0];
            ((BasePoliciesManagementState)state).delete(policyToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("Token Exchange Processor Policy");
        }
    }

    public void setDefaultId(IRequestCycle cycle) {
        TS state = this.getState();
        Object[] params = cycle.getServiceParameters();
        String newDefaultPolicy = (String)params[0];
        ((BasePoliciesManagementState)state).setDefaultId(newDefaultPolicy);
    }

    public boolean showTaskletCreatedMessage() {
        TS state = this.getState();
        boolean showTaskletCreateMessage = this.wasAddClicked && this.taskletListSize < ((TaskletListState)state).getTaskletListSize();
        this.taskletListSize = 0;
        this.wasAddClicked = false;
        return showTaskletCreateMessage;
    }

    public String getNewPolicyId() {
        TS state = this.getState();
        BasePolicyManagementTasklet t = (BasePolicyManagementTasklet)((TaskletListState)state).getTasklet(((TaskletListState)state).getTaskletListSize() - 1);
        return t.getId();
    }

    protected TS getState() {
        return (TS)((BasePoliciesManagementState)this.getCurrentState(this.tsClass));
    }
}

