/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card.oauth.exchange;

import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorMappingState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorMappingTasklet;
import java.util.Optional;
import org.apache.tapestry.IRequestCycle;

public class ProcessorMapping
extends TaskletCard {
    public void addTokenProcessorMapping(IRequestCycle cycle) {
        ProcessorMappingTasklet tasklet = this.createTaskletToLoad(ProcessorMappingTasklet.class);
        ((TaskletState)tasklet.getCurrentState()).refreshState();
        this.loadTasklet(tasklet);
    }

    public void edit(IRequestCycle cycle) {
        Object[] params;
        String idToEdit;
        ProcessorMappingState state = this.getState();
        Optional<ProcessorMappingTasklet> taskletToEditOptional = state.getTaskletById(idToEdit = (String)(params = cycle.getServiceParameters())[0]);
        if (taskletToEditOptional.isPresent()) {
            ProcessorMappingTasklet tasklet = taskletToEditOptional.get();
            taskletToEditOptional.get().setMode(Mode.edit);
            this.loadTasklet(tasklet);
            tasklet.gotoSummaryState(cycle);
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            ProcessorMappingState state = this.getState();
            Object[] params = cycle.getServiceParameters();
            String MappingToDelete = (String)params[0];
            state.delete(MappingToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("Token Exchange Processor Policy");
        }
    }

    public void undelete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            ProcessorMappingState state = this.getState();
            Object[] params = cycle.getServiceParameters();
            String mappingToUndelete = (String)params[0];
            state.undelete(mappingToUndelete);
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("Token Exchange Processor Policy");
        }
    }

    private ProcessorMappingState getState() {
        return this.getCurrentState(ProcessorMappingState.class);
    }
}

