/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.card.oauth.exchange;

import com.pingidentity.component.card.oauth.exchange.BasePoliciesManagementCard;
import com.pingidentity.fsm.state.impl.oauth.exchange.BasePoliciesManagementState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorPoliciesManagementState;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorPolicyManagementTasklet;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ProcessorPoliciesManagement
extends BasePoliciesManagementCard<ProcessorPolicyManagementTasklet, ProcessorPoliciesManagementState> {
    public ProcessorPoliciesManagement() {
        super(ProcessorPolicyManagementTasklet.class, ProcessorPoliciesManagementState.class);
    }

    @Override
    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String policyToDelete = (String)params[0];
            if (this.canDeleteProcessorPolicy(policyToDelete)) {
                Object state = this.getState();
                ((BasePoliciesManagementState)state).delete(policyToDelete);
            } else {
                ValidationDelegate delegate = ((ProcessorPoliciesManagementState)this.getState()).getParent().getDelegate(cycle);
                delegate.setFormComponent(null);
                delegate.record(this.getMessageFromState("Unable_to_delete_with_oauth_ref"), ValidationConstraint.REQUIRED);
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("Token Exchange Processor Policy");
        }
    }

    private boolean canDeleteProcessorPolicy(String policyToDelete) {
        TokenExchangeProcessorPolicyManager processorPolicyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
        return !processorPolicyManager.isInUse(policyToDelete);
    }
}

