/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.state.impl.AtmContractState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.impl.AssertionCreationTasklet;
import com.pingidentity.fsm.tasklet.impl.UserSessionCreationTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.AttributeContract;

public abstract class ATMAttributeContractEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String VALUES_IN_EXTENDED_LABEL = "Values";
    private StringPairPropertySelectionModel defaultSubjectAttributeModel = new StringPairPropertySelectionModel(false);

    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    public String getContractItem() {
        return this.getState().contractItem;
    }

    public boolean isContractItemEditing() {
        State curState = this.getState();
        return curState.contractItem.equals(curState.editItem);
    }

    public void setContractItem(String contractItem) {
        State s = this.getState();
        s.contractItem = StringUtils.stripToNull((String)contractItem);
        this.saveState(s);
    }

    public String getAttributeNameFormatFromContract(String attributeName) {
        return this.getContract().getMutableAttributeNameFormat(attributeName);
    }

    public String getAttributeNameFormatDescriptionFromContract(String attributeName) {
        String formatName = this.getAttributeNameFormatFromContract(attributeName);
        return this.getModelForAttributeNameFormat().getDescription(formatName);
    }

    public String getUpdateAttributeNameFormat() {
        return this.getState().updateAttributeNameFormat;
    }

    public void setUpdateAttributeNameFormat(String attributeNameFormat) {
        State s = this.getState();
        s.updateAttributeNameFormat = attributeNameFormat;
        this.saveState(s);
    }

    public String getNewAttributeNameFormat() {
        return this.getState().newAttributeNameFormat;
    }

    public void setNewAttributeNameFormat(String attributeNameFormat) {
        State s = this.getState();
        s.newAttributeNameFormat = attributeNameFormat;
        this.saveState(s);
    }

    public boolean isContractItemMasked() {
        State curState = this.getState();
        return this.getMaskList().contains(curState.contractItem);
    }

    public boolean isContractItemMultiValued() {
        State curState = this.getState();
        return this.getMultiValuedList().contains(curState.contractItem);
    }

    public Iterator<String> getMutableItems() {
        return this.getContract().getSortedMutableAttributeNames().iterator();
    }

    public Iterator<String> getImmutableItems() {
        return this.getContract().getSortedImmutableAttributeNames().iterator();
    }

    public StringPairPropertySelectionModel getMutableItemsModel() {
        this.defaultSubjectAttributeModel.add("USER_KEY", "USER_KEY");
        Iterator<String> iter = this.getMutableItems();
        while (iter.hasNext()) {
            String item = iter.next();
            this.defaultSubjectAttributeModel.add(item, item);
        }
        return this.defaultSubjectAttributeModel;
    }

    public abstract IBinding getContractBinding();

    public abstract IBinding getOriginalContractBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract boolean getAllowEmpty();

    public abstract boolean getShowExtensionLine();

    public abstract boolean getAllowSamlSubject();

    public abstract String getColumnHeading();

    public abstract IBinding getAttributeNameFormatLabelBinding();

    public abstract IBinding getMaskValuesBinding();

    public abstract IBinding getMaskListBinding();

    public abstract IBinding getMultiValuedListBinding();

    public abstract IBinding getIncludeAttributeNameFormatBinding();

    public abstract IBinding getAttributeNameFormatModelBinding();

    public abstract IBinding getIncludeSubjectNameFormatBinding();

    public abstract IBinding getSubjectNameFormatModelBinding();

    public abstract IBinding getSubjectNameFormatBinding();

    public abstract IBinding getExtendedContractLabelBinding();

    public abstract IBinding getAllowedAttributesBinding();

    public abstract IBinding getIsInheritingContractBinding();

    public abstract boolean getHasParentInstance();

    public String getExtendedContractLabel() {
        String label = null;
        IBinding binding = this.getExtendedContractLabelBinding();
        if (binding != null) {
            label = (String)binding.getObject("extendedContractLabel", String.class);
        }
        return label;
    }

    public List<String> getAllowedAttributesList() {
        List<String> allowedAttributes = new ArrayList<String>();
        IBinding binding = this.getAllowedAttributesBinding();
        if (binding != null) {
            allowedAttributes = (List)binding.getObject("allowedAttributes", List.class);
        }
        return allowedAttributes;
    }

    public String getAttributeNameFormatLabel() {
        return (String)this.getAttributeNameFormatLabelBinding().getObject("attributeNameFormatLabel", String.class);
    }

    public AttributeContract getContract() {
        if (this.isInheritingContract()) {
            return this.getOriginalContract();
        }
        return (AttributeContract)this.getContractBinding().getObject("contract", AttributeContract.class);
    }

    public AttributeContract getOriginalContract() {
        return (AttributeContract)this.getOriginalContractBinding().getObject("originalContract", AttributeContract.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    public Set<String> getMaskList() {
        return (Set)this.getMaskListBinding().getObject("maskList", Set.class);
    }

    public Boolean isMaskedValues() {
        return (Boolean)this.getMaskValuesBinding().getObject("maskValues", Boolean.class);
    }

    public Set<String> getMultiValuedList() {
        return (Set)this.getMultiValuedListBinding().getObject("multiValuedList", Set.class);
    }

    public Boolean isIncludeAttributeNameFormat() {
        return (Boolean)this.getIncludeAttributeNameFormatBinding().getObject("includeAttributeNameFormat", Boolean.class);
    }

    public StringPairPropertySelectionModel getModelForAttributeNameFormat() {
        return (StringPairPropertySelectionModel)this.getAttributeNameFormatModelBinding().getObject("attributeNameFormatModel", StringPairPropertySelectionModel.class);
    }

    public Boolean isIncludeSubjectNameFormat() {
        return (Boolean)this.getIncludeSubjectNameFormatBinding().getObject("includeSubjectNameFormat", Boolean.class);
    }

    public StringPairPropertySelectionModel getModelForSubjectNameFormat() {
        return (StringPairPropertySelectionModel)this.getSubjectNameFormatModelBinding().getObject("subjectNameFormatModel", StringPairPropertySelectionModel.class);
    }

    public String getSubjectNameFormat() {
        return (String)this.getSubjectNameFormatBinding().getObject("subjectNameFormat", String.class);
    }

    public void setSubjectNameFormat(String format) {
        this.getSubjectNameFormatBinding().setString(format);
    }

    public void setAttributeNameFormatLabel(String label) {
        this.getAttributeNameFormatLabelBinding().setString(label);
    }

    public void setExtendedContractLabel(String label) {
        this.getExtendedContractLabelBinding().setString(label);
    }

    public boolean isInheritingContract() {
        return this.getIsInheritingContractBinding().getBoolean();
    }

    public void setInheritingContract(boolean isInheritingContract) {
        this.getIsInheritingContractBinding().setBoolean(isInheritingContract);
    }

    public boolean isOverridingContract() {
        return !this.isInheritingContract();
    }

    public void setOverridingContract(boolean isOverridingContract) {
        this.setInheritingContract(!isOverridingContract);
        if (!isOverridingContract) {
            this.cancelEdit();
        }
    }

    private void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    private State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
            this.defaultSubjectAttributeModel = new StringPairPropertySelectionModel(false);
        }
        return state;
    }

    public String getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(String newItem) {
        State s = this.getState();
        s.newItem = StringUtils.stripToNull((String)newItem);
        this.saveState(s);
    }

    public String getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(String item) {
        State s = this.getState();
        s.editItem = StringUtils.stripToNull((String)item);
        this.saveState(s);
    }

    public String getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(String updateItem) {
        State s = this.getState();
        s.updateItem = StringUtils.stripToNull((String)updateItem);
        this.saveState(s);
    }

    public boolean getUpdateMask() {
        return this.getState().updateMask;
    }

    public void setUpdateMask(boolean mask) {
        State s = this.getState();
        s.updateMask = mask;
        this.saveState(s);
    }

    public boolean getNewMask() {
        return this.getState().newMask;
    }

    public void setNewMask(boolean mask) {
        State s = this.getState();
        s.newMask = mask;
        this.saveState(s);
    }

    public boolean getNewMultiValued() {
        return this.getState().newMultiValued;
    }

    public void setNewMultiValued(boolean multiValued) {
        State s = this.getState();
        s.newMultiValued = multiValued;
        this.saveState(s);
    }

    public boolean getUpdateMultiValued() {
        return this.getState().updateMultiValued;
    }

    public void setUpdateMultiValued(boolean multiValued) {
        State s = this.getState();
        s.updateMultiValued = multiValued;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        AttributeContract contract = this.getContract();
        boolean hasErrors = false;
        if (StringUtils.isBlank((String)this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (contract.attributeExists(this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().newItem, ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors && !this.getAllowSamlSubject() && this.getState().newItem.equals("SAML_SUBJECT")) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Saml_subject_not_allowed"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!this.getAllowedAttributesList().isEmpty() && !this.getAllowedAttributesList().contains(this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(String.format("Unsupported Attribute: %s", this.getState().newItem), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors) {
            State s = this.getState();
            contract.addMutableAttributeInfo(this.getState().newItem, this.getState().newAttributeNameFormat);
            if (this.isMaskedValues().booleanValue()) {
                if (s.newMask) {
                    this.getMaskList().add(s.newItem);
                } else {
                    this.getMaskList().remove(s.newItem);
                }
            }
            if (s.newMultiValued) {
                this.getMultiValuedList().add(s.newItem);
            } else {
                this.getMultiValuedList().remove(s.newItem);
            }
            s.newMask = false;
            s.newMultiValued = false;
            s.newItem = null;
            this.saveState(s);
        }
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        State curState = this.getState();
        curState.updateItem = curState.editItem = (String)params[0];
        curState.updateMask = this.isMaskedValues() != false ? this.getMaskList().contains(curState.updateItem) : false;
        if (this.isIncludeAttributeNameFormat().booleanValue()) {
            curState.updateAttributeNameFormat = this.getAttributeNameFormatFromContract(this.getState().editItem);
        }
        curState.updateMultiValued = this.getMultiValuedList().contains(curState.updateItem);
        this.saveState(curState);
    }

    public void onUpdateItem(IRequestCycle cycle) {
        AtmContractState currentState;
        AttributeContract contract = this.getContract();
        boolean hasErrors = false;
        State curState = this.getState();
        if (StringUtils.isBlank((String)curState.updateItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        } else if (!curState.updateItem.equals(curState.editItem)) {
            if (contract.attributeExists(curState.updateItem)) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().updateItem, ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!hasErrors && !this.getAllowSamlSubject() && curState.updateItem.equals("SAML_SUBJECT")) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Saml_subject_not_allowed"), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!this.getAllowedAttributesList().isEmpty() && !this.getAllowedAttributesList().contains(this.getState().updateItem)) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(String.format("Unsupported Attribute: %s", this.getState().updateItem), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!hasErrors) {
                contract.removeMutableAttributeName(curState.editItem);
                currentState = (AtmContractState)this.getCurrentState();
                if (curState.editItem.equals(currentState.getDefaultSubjectAttribute())) {
                    currentState.setDefaultSubjectAttribute(curState.updateItem);
                }
                contract.addMutableAttributeInfo(curState.updateItem, curState.updateAttributeNameFormat);
                this.defaultSubjectAttributeModel.removeById(curState.editItem);
            }
        } else if (this.isIncludeAttributeNameFormat().booleanValue() && !curState.updateAttributeNameFormat.equals(this.getAttributeNameFormatFromContract(this.getState().editItem))) {
            contract.updateMutableAttributeInfo(curState.updateItem, curState.updateAttributeNameFormat);
        }
        if (!hasErrors) {
            if (this.isMaskedValues().booleanValue()) {
                if (curState.updateMask) {
                    this.getMaskList().add(curState.updateItem);
                } else {
                    this.getMaskList().remove(curState.updateItem);
                }
            }
            currentState = (AtmContractState)this.getCurrentState();
            HashSet<String> newMultiValuedList = new HashSet<String>(this.getMultiValuedList());
            if (curState.updateMultiValued) {
                newMultiValuedList.add(curState.updateItem);
            } else {
                newMultiValuedList.remove(curState.updateItem);
            }
            currentState.setMultiValuedList(newMultiValuedList);
        }
        if (!hasErrors) {
            this.cancelEdit();
        }
        this.saveState(curState);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String deleteItem = (String)params[0];
            this.getContract().removeMutableAttributeName(deleteItem);
            this.getMultiValuedList().remove(deleteItem);
            AtmContractState currentState = (AtmContractState)this.getCurrentState();
            if (deleteItem.equals(currentState.getDefaultSubjectAttribute())) {
                currentState.resetDefaultSubjectAttribute();
            }
            this.defaultSubjectAttributeModel.removeById(deleteItem);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("attribute contract editor");
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        this.cancelEdit();
    }

    private void cancelEdit() {
        State curState = this.getState();
        curState.updateItem = null;
        curState.editItem = null;
        curState.updateMask = false;
        curState.updateMultiValued = false;
        this.saveState(curState);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        if (!this.getAllowEmpty() && (this.getContract().isEmpty() || !this.isAllowEmptyMutableAttributes() && this.getContract().getMutableAttributeNames().isEmpty())) {
            delegate.setFormComponent(null);
            String extendedLabel = this.getExtendedContractLabel();
            String messageId = extendedLabel != null && extendedLabel.contains(VALUES_IN_EXTENDED_LABEL) ? "One_value_required" : "One_attribute_required";
            delegate.record(this.getMessage(messageId), ValidationConstraint.REQUIRED);
        }
    }

    private boolean isAllowEmptyMutableAttributes() {
        if (this.getTasklet() instanceof AssertionCreationTasklet) {
            return !((AssertionCreationTasklet)this.getTasklet()).isAdditionalAttributesRequired();
        }
        if (this.getTasklet() instanceof UserSessionCreationTasklet) {
            return !((UserSessionCreationTasklet)this.getTasklet()).isAdditionalAttributesRequired();
        }
        return true;
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        String updateItem;
        boolean updateMask;
        boolean updateMultiValued;
        String editItem;
        String contractItem;
        String newItem;
        boolean newMask;
        boolean newMultiValued;
        String updateAttributeNameFormat;
        String newAttributeNameFormat;

        private State() {
        }
    }
}

