/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.oauth20.domain.ScopeManager;
import org.sourceid.saml20.domain.TokenEndpointAttributeContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class ATMTokenEndpointAttributeContractEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ScopeManager scopeManager = MgmtFactory.getScopeManager();

    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    public String getContractItem() {
        return this.getState().contractItem;
    }

    public boolean isContractItemEditing() {
        State curState = this.getState();
        return curState.contractItem.equals(curState.editItem);
    }

    public void setContractItem(String contractItem) {
        State s = this.getState();
        s.contractItem = StringUtils.stripToNull((String)contractItem);
        this.saveState(s);
    }

    public boolean isContractItemMultiValued() {
        if (this.isInheritingContract()) {
            return this.getOriginalContract().getMultiValued().contains(this.getState().contractItem);
        }
        return this.getContract().getMultiValued().contains(this.getState().contractItem);
    }

    public Iterator<String> getMutableItems() {
        if (this.isInheritingContract()) {
            return this.getOriginalContract().getSortedMutableAttributeNames().iterator();
        }
        return this.getContract().getSortedMutableAttributeNames().iterator();
    }

    public String scopesModalJavascript(String contractItem) {
        return "javascript:\nvar data = {\n'eventType':'showScopesSelectionModal',\n'description':'Choose the scopes that will trigger this attribute to be included in the Token Endpoint Response. Choosing none will result in this attribute always being included.',\n'scopeType':'commonScope',\n'isIncludeScopeGroups': false,\n'selectedScopes': " + this.getContract().getMappedScopes().getOrDefault(contractItem, Collections.emptySet()).stream().map(scope -> "'" + scope + "'").collect(Collectors.joining(",", "[", "]")) + ",\n};var origin = window.origin ? window.origin : window.location.origin;\nwindow.parent.postMessage(data, origin);\nvar idleTimerData = {'eventType': 'resetIdleTimer'};\nwindow.parent.postMessage(idleTimerData, origin);";
    }

    public int getNumberOfSelectedScopes(String contractItem) {
        return this.getContract().getMappedScopes().getOrDefault(contractItem, Collections.emptySet()).size();
    }

    public abstract IBinding getContractBinding();

    public abstract IBinding getOriginalContractBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getExtendedContractLabelBinding();

    public abstract IBinding getIsInheritingContractBinding();

    public abstract IBinding getCurrentContractItemSetterBinding();

    public abstract boolean getHasParentInstance();

    public String getExtendedContractLabel() {
        String label = null;
        IBinding binding = this.getExtendedContractLabelBinding();
        if (binding != null) {
            label = (String)binding.getObject("extendedContractLabel", String.class);
        }
        return label;
    }

    public TokenEndpointAttributeContract getContract() {
        if (this.isInheritingContract()) {
            return this.getOriginalContract();
        }
        return (TokenEndpointAttributeContract)this.getContractBinding().getObject("contract", TokenEndpointAttributeContract.class);
    }

    public TokenEndpointAttributeContract getOriginalContract() {
        return (TokenEndpointAttributeContract)this.getOriginalContractBinding().getObject("originalContract", TokenEndpointAttributeContract.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    public Consumer<String> getCurrentContractItemSetter() {
        return (Consumer)this.getCurrentContractItemSetterBinding().getObject("currentContractItemSetter", Consumer.class);
    }

    public void setExtendedContractLabel(String label) {
        this.getExtendedContractLabelBinding().setString(label);
    }

    public boolean isInheritingContract() {
        return this.getIsInheritingContractBinding().getBoolean();
    }

    public void setInheritingContract(boolean isInheritingContract) {
        this.getIsInheritingContractBinding().setBoolean(isInheritingContract);
    }

    public boolean isOverridingContract() {
        return !this.isInheritingContract();
    }

    public void setOverridingContract(boolean isOverridingContract) {
        this.setInheritingContract(!isOverridingContract);
        if (!isOverridingContract) {
            this.cancelEdit();
        }
    }

    private void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    private State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
        }
        return state;
    }

    public String getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(String newItem) {
        State s = this.getState();
        s.newItem = StringUtils.stripToNull((String)newItem);
        this.saveState(s);
    }

    public String getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(String item) {
        State s = this.getState();
        s.editItem = StringUtils.stripToNull((String)item);
        this.saveState(s);
    }

    public String getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(String updateItem) {
        State s = this.getState();
        s.updateItem = StringUtils.stripToNull((String)updateItem);
        this.saveState(s);
    }

    public boolean getNewMultiValued() {
        return this.getState().newMultiValued;
    }

    public void setNewMultiValued(boolean multiValued) {
        State s = this.getState();
        s.newMultiValued = multiValued;
        this.saveState(s);
    }

    public boolean getUpdateMultiValued() {
        return this.getState().updateMultiValued;
    }

    public void setUpdateMultiValued(boolean multiValued) {
        State s = this.getState();
        s.updateMultiValued = multiValued;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        TokenEndpointAttributeContract contract = this.getContract();
        boolean hasErrors = false;
        if (StringUtils.isBlank((String)this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (contract.attributeExists(this.getState().newItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().newItem, ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors) {
            State s = this.getState();
            contract.addMutableAttributeName(this.getState().newItem);
            if (s.newMultiValued) {
                contract.getMultiValued().add(s.newItem);
            }
            if (contract.getMappedScopes().containsKey(null)) {
                contract.getMappedScopes().put(s.newItem, (Set)contract.getMappedScopes().remove(null));
            }
            s.newMultiValued = false;
            s.newItem = null;
            this.saveState(s);
        }
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        State curState = this.getState();
        curState.updateItem = curState.editItem = (String)params[0];
        curState.updateMultiValued = this.getContract().getMultiValued().contains(curState.editItem);
        this.getCurrentContractItemSetter().accept(curState.updateItem);
        this.saveState(curState);
    }

    public void onUpdateItem(IRequestCycle cycle) {
        TokenEndpointAttributeContract contract = this.getContract();
        boolean hasErrors = false;
        State curState = this.getState();
        if (StringUtils.isBlank((String)curState.updateItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        } else if (!curState.updateItem.equals(curState.editItem) && contract.attributeExists(curState.updateItem)) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Already_contains") + " " + this.getState().updateItem, ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors) {
            contract.removeMutableAttributeName(curState.editItem);
            contract.addMutableAttributeName(curState.updateItem);
            if (curState.updateMultiValued) {
                this.getContract().getMultiValued().add(curState.updateItem);
            } else {
                this.getContract().getMultiValued().remove(curState.updateItem);
            }
            Set existingMappedScopes = (Set)this.getContract().getMappedScopes().remove(curState.editItem);
            if (existingMappedScopes != null) {
                this.getContract().getMappedScopes().put(curState.updateItem, existingMappedScopes);
            }
            this.cancelEdit();
        }
        this.saveState(curState);
    }

    public void cancelEdit(IRequestCycle cycle) {
        this.cancelEdit();
    }

    private void cancelEdit() {
        State curState = this.getState();
        curState.updateItem = null;
        curState.editItem = null;
        curState.updateMultiValued = false;
        this.getCurrentContractItemSetter().accept(null);
        this.saveState(curState);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String deleteItem = (String)params[0];
            this.getContract().removeMutableAttributeName(deleteItem);
            this.getContract().getMultiValued().remove(deleteItem);
            this.getContract().getMappedScopes().remove(deleteItem);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("token endpoint attribute contract editor");
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
        Map definedScopes = this.scopeManager.getScopeDescriptions();
        this.getContract().getMappedScopes().forEach((attribute, scopes) -> scopes.forEach(scope -> {
            if (!definedScopes.containsKey(scope)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Scope_Not_Exist", attribute, scope), ValidationConstraint.CONSISTENCY);
            }
        }));
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        String updateItem;
        boolean updateMultiValued;
        String editItem;
        String contractItem;
        String newItem;
        boolean newMultiValued;

        private State() {
        }
    }
}

