/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.DNtoIdpMap;

public abstract class AttrReqMappingEditor
extends TaskletCard
implements Serializable {
    private DNtoIdpMap updateItem;
    private DNtoIdpMap editItem;
    private DNtoIdpMap newItem = new DNtoIdpMap();
    private Object currentItem;

    public abstract IBinding getDistinguishedNameListBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getModelBinding();

    public abstract String getDnType();

    public abstract IBinding getConnectionListBinding();

    protected void prepareForRender(IRequestCycle arg0) {
        super.prepareForRender(arg0);
        if (this.getModel().anySelected()) {
            this.newItem = new DNtoIdpMap();
            this.editItem = null;
            this.updateItem = null;
            this.getModel().clear();
        }
    }

    public List<DNtoIdpMap> getDistinguishedNameList() {
        return (List)this.getDistinguishedNameListBinding().getObject("distinguishedNameList", List.class);
    }

    public List<DNtoIdpMap> getDistinguishedNameListCopy() {
        List list = (List)this.getDistinguishedNameListBinding().getObject("distinguishedNameList", List.class);
        return new ArrayList<DNtoIdpMap>(list);
    }

    public void setDistinguishedNameList(List newList) {
        this.getDistinguishedNameListBinding().setObject((Object)newList);
    }

    public StringPairPropertySelectionModel getConnectionList() {
        return (StringPairPropertySelectionModel)this.getConnectionListBinding().getObject("connectionList", StringPairPropertySelectionModel.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    public CheckboxModel getModel() {
        return (CheckboxModel)this.getModelBinding().getObject("model", CheckboxModel.class);
    }

    public List<CheckboxItem> getCheckboxItems() {
        return this.getModel().getCheckboxItems();
    }

    public void setCheckboxItems(List<CheckboxItem> items) {
        this.getModel().setCheckboxItems(items);
    }

    public boolean isEditMode() {
        return this.editItem != null;
    }

    public boolean isCurrentItemEditing() {
        return this.currentItem.equals(this.editItem);
    }

    public void onAddItem(IRequestCycle cycle) {
        DNtoIdpMap addItem;
        String invalidMsg;
        boolean hasErrors = false;
        if (StringUtils.isBlank((String)this.newItem.getDn())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Distinguished_name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if ((invalidMsg = this.newItem.validateRegex()) != null) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("invalid_regex", invalidMsg), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (StringUtils.isBlank((String)this.newItem.getIdpId())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Connection_id_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if ((addItem = this.findDistinguishedName(this.newItem.getDn())) != null) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getDnType() + " " + this.getMessage("Already_contains") + " " + this.newItem.getDn(), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors) {
            DNtoIdpMap newMap = new DNtoIdpMap(this.newItem.getDn(), this.newItem.getIdpId());
            this.getDistinguishedNameList().add(newMap);
            this.newItem = new DNtoIdpMap();
        }
    }

    public void onUpdateItem(IRequestCycle cycle) {
        DNtoIdpMap addItem;
        String invalidMsg;
        boolean hasErrors = false;
        if (StringUtils.isBlank((String)this.updateItem.getDn())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Distinguished_name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if ((invalidMsg = this.updateItem.validateRegex()) != null) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("invalid_regex", invalidMsg), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (StringUtils.isBlank((String)this.updateItem.getIdpId())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Connection_id_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if ((addItem = this.findDistinguishedName(this.updateItem.getDn())) != null && !addItem.getDn().equals(this.editItem.getDn())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getDnType() + " " + this.getMessage("Already_contains") + " " + this.updateItem.getDn(), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (!hasErrors) {
            DNtoIdpMap replaceItem = this.findDistinguishedName(this.editItem.getDn());
            DNtoIdpMap newMap = new DNtoIdpMap(this.updateItem.getDn(), this.updateItem.getIdpId());
            replaceItem.setDn(newMap.getDn());
            replaceItem.setIdpId(newMap.getIdpId());
            replaceItem.setIdpName(newMap.getIdpName());
            this.editItem = null;
            this.updateItem = null;
        }
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        DNtoIdpMap itemToEdit = new DNtoIdpMap((String)params[0], (String)params[1], (String)params[2]);
        this.editItem = this.findDistinguishedName(itemToEdit.getDn());
        this.updateItem = new DNtoIdpMap(this.editItem);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            DNtoIdpMap deleteItem = new DNtoIdpMap((String)params[0], (String)params[1]);
            this.getDistinguishedNameList().remove(deleteItem);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("attribute request mapping editor");
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        this.updateItem = null;
        this.editItem = null;
    }

    public void moveUp(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        Integer index = (Integer)params[0];
        if (index > 0) {
            ArrayList<DNtoIdpMap> entries = new ArrayList<DNtoIdpMap>(this.getDistinguishedNameList());
            DNtoIdpMap item = entries.get(index);
            entries.set(index, entries.get(index - 1));
            entries.set(index - 1, item);
            this.setDistinguishedNameList(entries);
        }
    }

    public void moveDown(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        Integer index = (Integer)params[0];
        if (index < this.getDistinguishedNameList().size() - 1) {
            ArrayList<DNtoIdpMap> entries = new ArrayList<DNtoIdpMap>(this.getDistinguishedNameList());
            DNtoIdpMap item = entries.get(index);
            entries.set(index, entries.get(index + 1));
            entries.set(index + 1, item);
            this.setDistinguishedNameList(entries);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getDnType() + " " + this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
    }

    private DNtoIdpMap findDistinguishedName(String searchItem) {
        DNtoIdpMap foundItem = null;
        for (DNtoIdpMap item : this.getDistinguishedNameList()) {
            if (!item.getDn().equals(searchItem)) continue;
            foundItem = item;
            break;
        }
        return foundItem;
    }

    public void setCurrentItem(Object currentItem) {
        this.currentItem = currentItem;
    }

    public Object getCurrentItem() {
        return this.currentItem;
    }

    public DNtoIdpMap getEditItem() {
        return this.editItem;
    }

    public void setEditItem(DNtoIdpMap item) {
        this.editItem = item;
    }

    public DNtoIdpMap getUpdateItem() {
        return this.updateItem;
    }

    public void setUpdateItem(DNtoIdpMap updateItem) {
        this.updateItem = updateItem;
    }

    public DNtoIdpMap getNewItem() {
        return this.newItem;
    }

    public void setNewItem(DNtoIdpMap newItem) {
        this.newItem = newItem;
    }
}

