/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.authnselection.ui.FindNodeByIdVisitor;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.pingcommons.util.tree.PreOrderTraversal;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public abstract class AuthnPolicyComponent
extends TaskletCard {
    public abstract IBinding getTreesBinding();

    public List<AuthnSelectionTree> getTheTreesList() {
        return new ArrayList<AuthnSelectionTree>(this.getTreesList());
    }

    public List<AuthnSelectionTree> getTreesList() {
        return (List)this.getTreesBinding().getObject("List", List.class);
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes(AsUiAction asUiAction) {
        AbstractPolicyState state = this.getState();
        return state.getSearchableTypes(asUiAction);
    }

    public boolean getIsInputSelectionRequired(AsUiAction asUiAction) {
        AbstractPolicyState state = this.getState();
        return state.getIsInputSelectionRequired(asUiAction);
    }

    public void removeComponent(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> {
            AbstractPolicyState state = this.getState();
            Tree<AsUiAction> tree = state.getAuthnSelectionTree();
            Tree.Node<AsUiAction> node = this.getNodeById(tree, nodeId);
            if (node != null) {
                ((AsUiAction)node.getData()).setSelectedOption(null);
                state.removeErrorsFor(nodeId);
            }
        });
    }

    private void setNoOpAction(AsActionOption.Type type, IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> {
            AbstractPolicyState state = this.getState();
            Tree<AsUiAction> tree = state.getAuthnSelectionTree();
            Tree.Node<AsUiAction> node = this.getNodeById(tree, nodeId);
            if (node != null) {
                ((AsUiAction)node.getData()).setSelectedOption(new AsActionOption(null, type));
            }
        });
    }

    public void continueLink(IRequestCycle cycle) {
        this.setNoOpAction(AsActionOption.Type.CONTINUE, cycle);
    }

    public void doneLink(IRequestCycle cycle) {
        this.setNoOpAction(AsActionOption.Type.DONE, cycle);
    }

    public void restartLink(IRequestCycle cycle) {
        this.setNoOpAction(AsActionOption.Type.RESTART, cycle);
    }

    public void onConfigure(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> {
            AbstractPolicyState state = this.getState();
            state.showApcState(nodeId, cycle);
        });
    }

    public void onConfigureLip(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> {
            AbstractPolicyState state = this.getState();
            state.showLipState(nodeId, cycle);
        });
    }

    public void onConfigureFragmentMapping(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> {
            AbstractPolicyState state = this.getState();
            state.showFragmentMapping(nodeId, cycle);
        });
    }

    public void onCopyTree(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> {
            AbstractPolicyState state = this.getState();
            state.copyTree(nodeId);
        });
    }

    public void onPasteTree(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> {
            AbstractPolicyState state = this.getState();
            List<String> messages = state.pasteTree(nodeId);
            state.formListener(cycle);
            ValidationDelegate delegate = this.getTasklet().getDelegate(cycle);
            state.performPasteValidation((IValidationDelegate)delegate, messages);
        });
    }

    public String getActionDropdownClass(AsActionOption selectedOption, int column) {
        if (column > 0 && selectedOption == null) {
            return "input-select required";
        }
        return "input-select";
    }

    private Tree.Node<AsUiAction> getNodeById(Tree<AsUiAction> tree, String nodeId) {
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(tree, (TraversalVisitor)nodeIdVisitor);
        return nodeIdVisitor.getNode();
    }

    private AbstractPolicyState getState() {
        return (AbstractPolicyState)this.getCurrentState();
    }

    public void toggleCollapse(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String nodeId = (String)params[0];
        this.setSubmitRunnable(() -> this.getState().toggleCollapseFor(nodeId));
    }

    public void onExpandAll(IRequestCycle cycle) {
        this.setSubmitRunnable(() -> this.getState().expandAll());
    }

    public void onCollapseAll(IRequestCycle cycle) {
        this.setSubmitRunnable(() -> this.getState().collapseAll());
    }
}

