/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.KeyAlgorithmFilter;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public abstract class CertificateSelectionList
extends TaskletCard
implements CertificateTypes {
    private CertificateTypes.ValidTypes certificateType;

    public abstract boolean getSelectPrompt();

    public abstract String getCertType();

    public abstract Object getCertManager();

    public abstract IBinding getSelectedCertBinding();

    public abstract IBinding getConnectionCertsBinding();

    public abstract IBinding getVerificationCertsBinding();

    public abstract Set<KeyAlgorithmFilter> getKeyAlgorithmFilters();

    public abstract boolean getDisabled();

    public abstract boolean getRequired();

    public Cert getSelectedCert() {
        return (Cert)this.getSelectedCertBinding().getObject("selectedCert", Cert.class);
    }

    public void setSelectedCert(Cert selectedCert) {
        this.getSelectedCertBinding().setObject((Object)selectedCert);
    }

    public ConnectionCerts getConnectionCerts() {
        return (ConnectionCerts)this.getConnectionCertsBinding().getObject("connectionCerts", ConnectionCerts.class);
    }

    public void setConnectionCerts(ConnectionCerts selectedCert) {
        this.getConnectionCertsBinding().setObject((Object)selectedCert);
    }

    public Set<Cert> getVerificationCerts() {
        return (Set)this.getVerificationCertsBinding().getObject("verificationCerts", Set.class);
    }

    public void setVerificationCerts(Set<Cert> verificationCerts) {
        this.getVerificationCertsBinding().setObject(verificationCerts);
    }

    protected void filterList(Collection<? extends Cert> certs) {
        Set<KeyAlgorithmFilter> filters = this.getKeyAlgorithmFilters();
        if (filters != null) {
            Iterator<? extends Cert> iter = certs.iterator();
            while (iter.hasNext()) {
                Cert cert = iter.next();
                X509Certificate x509 = cert.getX509Certificate();
                String algorithm = x509.getPublicKey().getAlgorithm();
                Integer keySize = cert.getPublicKeySize();
                boolean remove = false;
                CertificateTypes.KeyAlgorithms certAlgorithm = null;
                try {
                    certAlgorithm = CertificateTypes.KeyAlgorithms.valueOf(algorithm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (filters != null) {
                    if (certAlgorithm == null) {
                        remove = true;
                    } else {
                        KeyAlgorithmFilter matchingAlgFilter = null;
                        for (KeyAlgorithmFilter filter : filters) {
                            if (filter.getKeyAlg() != certAlgorithm) continue;
                            matchingAlgFilter = filter;
                            break;
                        }
                        if (matchingAlgFilter == null) {
                            remove = true;
                        } else {
                            DSignRotationSettingsManager rotationManger;
                            DSignRotationSetting rotationSetting;
                            int keySizeFilter;
                            String signatureName;
                            int minKeySize = matchingAlgFilter.getMinPublicKeySize();
                            if (minKeySize > 0 && (keySize == null || keySize < minKeySize)) {
                                remove = true;
                            }
                            if ((signatureName = matchingAlgFilter.getSignatureName()) != null && !signatureName.equals(x509.getSigAlgName())) {
                                remove = true;
                            }
                            if ((keySizeFilter = matchingAlgFilter.getKeySize()) > 0 && (keySize == null || keySize != keySizeFilter)) {
                                remove = true;
                            }
                            if (matchingAlgFilter.isRemoveRotatingCerts() && (rotationSetting = (rotationManger = MgmtFactory.getDSignRotationSettingsManager()).getRotationSetting(cert.getId())) != null && rotationSetting.isEnableCertRotation()) {
                                remove = true;
                            }
                        }
                    }
                }
                if (!remove) continue;
                iter.remove();
            }
        }
    }

    public IPropertySelectionModel getCertificateModel() {
        Collection<Object> certificatesForDisplay;
        StringPairPropertySelectionModel certificateModel = this.getSelectPrompt() ? new StringPairPropertySelectionModel(true) : new StringPairPropertySelectionModel();
        this.setCertificateType(this.getCertType());
        switch (this.certificateType) {
            case sslCertAuth: 
            case dsigSigningCert: 
            case xmlDecryptionCert: {
                certificatesForDisplay = ((PkCertManager)this.getCertManager()).getPkCerts();
                break;
            }
            case dsigVerificationCert: 
            case ocspDsigVerificationCert: 
            case wsTrustDsigVerificationCert: 
            case xmlEncryptionCert: {
                certificatesForDisplay = this.getConnectionCerts().getAllVerificationCerts();
                break;
            }
            case sslCertVerification: {
                certificatesForDisplay = this.getVerificationCerts();
                break;
            }
            case trustedCAs: {
                certificatesForDisplay = ((TrustedCAsManager)this.getCertManager()).getTrustedCAs();
                break;
            }
            default: {
                certificatesForDisplay = Collections.emptyList();
            }
        }
        if (certificatesForDisplay != null && !certificatesForDisplay.isEmpty()) {
            this.filterList(certificatesForDisplay);
            for (Cert cert : certificatesForDisplay) {
                certificateModel.add(cert.getDescriptionForDisplay(35), cert);
            }
        }
        return certificateModel;
    }

    private void setCertificateType(String certificateString) {
        if (certificateString.equals("dsigSigningCert")) {
            this.certificateType = CertificateTypes.ValidTypes.dsigSigningCert;
        } else if (certificateString.equals("sslCertAuth")) {
            this.certificateType = CertificateTypes.ValidTypes.sslCertAuth;
        } else if (certificateString.equals("sslCertVerification")) {
            this.certificateType = CertificateTypes.ValidTypes.sslCertVerification;
        } else if (certificateString.equals("dsigVerificationCert")) {
            this.certificateType = CertificateTypes.ValidTypes.dsigVerificationCert;
        } else if (certificateString.equals("ocspDsigVerificationCert")) {
            this.certificateType = CertificateTypes.ValidTypes.ocspDsigVerificationCert;
        } else if (certificateString.equals("wsTrustDsigVerificationCert")) {
            this.certificateType = CertificateTypes.ValidTypes.wsTrustDsigVerificationCert;
        } else if (certificateString.equals("trustedCAs")) {
            this.certificateType = CertificateTypes.ValidTypes.trustedCAs;
        } else if (certificateString.equals("sslServerCerts")) {
            this.certificateType = CertificateTypes.ValidTypes.sslServerCerts;
        } else if (certificateString.equals("xmlEncryptionCert")) {
            this.certificateType = CertificateTypes.ValidTypes.xmlEncryptionCert;
        } else if (certificateString.equals("xmlDecryptionCert")) {
            this.certificateType = CertificateTypes.ValidTypes.xmlDecryptionCert;
        }
    }

    public void manageCerts(IRequestCycle cycle) {
        TaskletState state = this.getCurrentState();
        this.loadTasklet(state.getTaskletToEdit());
    }
}

