/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.state.impl.ConnMgmtState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.impl.AuthnAdapterInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.MainMenuTasklet;
import com.pingidentity.fsm.tasklet.impl.SessionCreationAdapterTasklet;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import org.apache.commons.lang.StringUtils;

public class ConfigurationLabel
extends TaskletCard {
    private static final String DEFAULT = "";
    private static final String IDP = "IdP";
    private static final String SP = "SP";
    private static final String CONNECTION = "Connection";
    private static final String ADAPTER = "Adapter";
    private static final String MY_SERVER = "My Server";
    private static final String MAIN_MENU = "Main Menu";
    private static final String MANAGE_CONNS = "Manage Connections";
    private static final int MAX_CONN_ID_DISPLAY_LENGTH = 50;

    public String getConnName() {
        ConnectionTasklet connectionTasklet;
        Object connName;
        Tasklet t = this.getCurrentTasklet();
        if (t.findParent(ConnectionTasklet.class) != null && !StringUtils.isBlank((String)(connName = (connectionTasklet = t.findParent(ConnectionTasklet.class)).getConnectionName()))) {
            if (((String)connName).length() > 50) {
                connName = ((String)connName).substring(0, 49) + "...";
            }
            return "'" + (String)connName + "'";
        }
        return DEFAULT;
    }

    public String getConnId() {
        ConnectionTasklet connectionTasklet;
        Object connId;
        Tasklet t = this.getCurrentTasklet();
        if (t.findParent(ConnectionTasklet.class) != null && !StringUtils.isBlank((String)(connId = (connectionTasklet = t.findParent(ConnectionTasklet.class)).getConnId()))) {
            if (((String)connId).length() > 50) {
                connId = ((String)connId).substring(0, 49) + "...";
            }
            return "'" + (String)connId + "'";
        }
        return DEFAULT;
    }

    public String getRole() {
        Tasklet t = this.getCurrentTasklet();
        if (t.findParent(ConnectionTasklet.class) != null) {
            ConnectionTasklet connectionTasklet = t.findParent(ConnectionTasklet.class);
            if (ConnectionType.IDP == connectionTasklet.getConnectionType()) {
                return "IdP Connection";
            }
            if (ConnectionType.SP == connectionTasklet.getConnectionType()) {
                return "SP Connection";
            }
        } else {
            if (t instanceof AuthnAdapterInstanceTasklet) {
                return "IdP Adapter";
            }
            if (t instanceof SessionCreationAdapterTasklet) {
                SessionCreationAdapterTasklet sessionTasklet = (SessionCreationAdapterTasklet)t;
                if (StringUtils.isBlank((String)sessionTasklet.getName())) {
                    return "SP Adapter";
                }
                return "'" + sessionTasklet.getName() + "' SP Adapter";
            }
            if (t instanceof MainMenuTasklet) {
                return MAIN_MENU;
            }
            if (t instanceof SingleStateTasklet && t.getCurrentState() instanceof ConnMgmtState) {
                return MANAGE_CONNS;
            }
        }
        return MY_SERVER;
    }

    public boolean getDisplayPreamble() {
        return !MAIN_MENU.equals(this.getRole()) && !MANAGE_CONNS.equals(this.getRole());
    }
}

