/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.component.common.Download;
import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.state.impl.ConnMgmtState;
import com.pingidentity.fsm.state.impl.ConnectionToggleState;
import com.pingidentity.fsm.state.impl.SelectExportModeState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ConnectionImageType;
import com.pingidentity.fsm.tasklet.data.ConnectionItem;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.ProtocolType;
import com.pingidentity.fsm.tasklet.data.StatusType;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.ExportMetadataTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.ImportMetadataTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.util.EnumPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.api.ConnectionMigrationMgr;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.license.LicenseManager;

public abstract class ConnectionList
extends TaskletCard {
    public static final IPropertySelectionModel STATUS_MODEL = new EnumPropertySelectionModel(StatusType.values());

    public abstract IBinding getConnectionsBinding();

    public abstract boolean getCacheTasklets();

    public abstract IBinding getOnStateActivatedBinding();

    public abstract IBinding getLocalSettingsBinding();

    public abstract IBinding getConnectionTypeBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getUseCustomSortControlsBinding();

    public abstract IBinding getDisableActionDropDownBinding();

    public ArrayList<ConnectionItem> getConnectionsList() {
        return (ArrayList)this.getConnectionsBinding().getObject("connections", ArrayList.class);
    }

    public ConnectionType getConnType() {
        return (ConnectionType)((Object)this.getConnectionTypeBinding().getObject("connectionType", ConnectionType.class));
    }

    public Boolean getOnStateActivated() {
        IBinding binding = this.getOnStateActivatedBinding();
        return binding.getBoolean();
    }

    public void setOnStateActivated(Boolean onScreenActivated) {
        IBinding binding = this.getOnStateActivatedBinding();
        binding.setBoolean(onScreenActivated.booleanValue());
    }

    protected LocalSettings getLocalSettings() {
        return (LocalSettings)this.getLocalSettingsBinding().getObject("localSettings", LocalSettings.class);
    }

    private void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    private State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
        }
        return state;
    }

    protected void prepareForRender(IRequestCycle arg0) {
        super.prepareForRender(arg0);
        if (arg0.isRewinding()) {
            return;
        }
        State state = this.getState();
        if (this.getOnStateActivated().booleanValue()) {
            state.sortBy = SORT_BY.ModificationTime;
            state.protocolType = ProtocolType.ALL;
            state.connectionImageType = ConnectionImageType.ALL;
            state.statusType = StatusType.ALL;
            state.sortConnNameUp = false;
            state.sortConnIdUp = false;
            state.sortVirtualIdentityUp = false;
            state.sortProtocolUp = false;
            state.sortStatusUp = false;
            state.sortModificationTimeUp = true;
            state.sortCreationTimeUp = true;
            this.setOnStateActivated(false);
        }
        state.displayList = new ArrayList();
        for (ConnectionItem item : this.getConnectionsList()) {
            state.displayList.add(item);
        }
        if (this.isDisplaySortingControls()) {
            switch (state.sortBy) {
                case Name: {
                    if (state.sortConnNameUp) {
                        Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_NAME_UP);
                        break;
                    }
                    Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_NAME_DOWN);
                    break;
                }
                case Id: {
                    if (state.sortConnIdUp) {
                        Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_ID_UP);
                        break;
                    }
                    Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_ID_DOWN);
                    break;
                }
                case VirtualIdentity: {
                    if (state.sortVirtualIdentityUp) {
                        Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_VIRT_ID_UP);
                        break;
                    }
                    Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_VIRT_ID_DOWN);
                    break;
                }
                case Protocol: {
                    if (state.sortProtocolUp) {
                        Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_PROTO_UP);
                        break;
                    }
                    Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_PROTO_DOWN);
                    break;
                }
                case Status: {
                    if (state.sortStatusUp) {
                        Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_STATUS_UP);
                        break;
                    }
                    Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_STATUS_DOWN);
                    break;
                }
                case ModificationTime: {
                    if (state.sortModificationTimeUp) {
                        Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_MODIFICATION_TIME_UP);
                        break;
                    }
                    Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_MODIFICATION_TIME_DOWN);
                    break;
                }
                case CreationTime: {
                    if (state.sortCreationTimeUp) {
                        Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_CREATION_TIME_UP);
                        break;
                    }
                    Collections.sort(state.displayList, ConnectionItem.COMPARE_BY_CREATION_TIME_DOWN);
                }
            }
        }
        this.saveState(state);
    }

    public void checkConnectionForErrors(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        ConnectionItem connection = this.getConnectionFromList((Integer)params[0]);
        if (connection != null) {
            ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
            state.checkConnectionForErrors(connection);
        }
    }

    public void edit(IRequestCycle cycle) {
        ConnectionItem connection;
        Object[] params = cycle.getServiceParameters();
        Integer connToEdit = (Integer)params[0];
        if (connToEdit != null && (connection = this.getConnectionFromList(connToEdit)) != null) {
            if (!connection.isDraftConnection()) {
                Tasklet tasklet = null;
                if (this.getCacheTasklets()) {
                    tasklet = connection.getTasklet();
                }
                if (tasklet == null) {
                    tasklet = connection.getRole().equals("IdP") ? this.createAndPopulateIdpTasklet(connection) : this.createAndPopulateSpTasklet(connection);
                }
                tasklet.resetCurrentStateToSourceState();
                tasklet.setSaveDraftAvailable(false);
                tasklet.markProtocolImgAvailable(true);
                this.loadTasklet(tasklet);
                tasklet.gotoSummaryState(cycle);
                connection.setTasklet(tasklet);
            } else {
                ConnectionTasklet tasklet = this.getRoleSpecificTasklet(connection);
                if (!tasklet.resumeDraft(cycle)) {
                    ConnMgmtState state = (ConnMgmtState)this.getCurrentState();
                    state.setResumeDraftSuccessful(false);
                    Tasklet t = this.getCurrentTasklet();
                    t.next(cycle);
                }
            }
        }
    }

    public void export(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            Object[] params = cycle.getServiceParameters();
            Integer idx = (Integer)params[0];
            ConnectionItem connectionItem = this.getConnectionFromList(idx);
            String eid = connectionItem.getEntityId();
            boolean isIdp = connectionItem.getRole().equals("IdP");
            ConnectionMigrationMgr connMigrationMgr = new ConnectionMigrationMgr();
            byte[] connectionXmlBytes = connMigrationMgr.getConnectionXmlBytes(eid, isIdp ? Role.IDP : Role.SP);
            AdminAuditLogger.Component component = isIdp ? AdminAuditLogger.Component.IDP_CONNECTION : AdminAuditLogger.Component.SP_CONNECTION;
            String outputFileName = isIdp ? "idp-pingfederate-connection.xml" : "sp-pingfederate-connection.xml";
            Download.download(cycle, true, "text/xml", connectionXmlBytes, outputFileName, component);
        }
    }

    public void exportMetadata(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            Object[] params = cycle.getServiceParameters();
            Integer idx = (Integer)params[0];
            ConnectionItem connectionItem = this.getConnectionFromList(idx);
            ExportMetadataTasklet tasklet = this.createTaskletToLoad(ExportMetadataTasklet.class);
            tasklet.setCycle(cycle);
            ExportMetadataTasklet.DefaultRole defaultRole = "IdP".equals(connectionItem.getRole()) ? ExportMetadataTasklet.DefaultRole.SP : ExportMetadataTasklet.DefaultRole.IDP;
            tasklet.setDefaultRole(defaultRole);
            tasklet.setExportMode(SelectExportModeState.CONNECTION_MODE);
            tasklet.setSelectedConnection(connectionItem.getEntityId());
            this.loadTasklet(tasklet);
            tasklet.gotoMetadataSigningState(cycle);
        }
    }

    public void updateMetadata(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            Object[] params = cycle.getServiceParameters();
            Integer idx = (Integer)params[0];
            ConnectionItem connectionItem = this.getConnectionFromList(idx);
            String connectionId = connectionItem.getSystemId();
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            IdpConnection connection = null;
            if (connectionItem.getRole().equals("IdP")) {
                connection = connectionManager.getIdpConnectionBySystemId(connectionId);
            } else if (connectionItem.getRole().equals("SP")) {
                connection = connectionManager.getSpConnectionBySystemId(connectionId);
            }
            ImportMetadataTasklet tasklet = this.createTaskletToLoad(ImportMetadataTasklet.class);
            tasklet.setConnection((ConnectionBase)connection);
            tasklet.setFinishLabel("Save");
            tasklet.setCycle(cycle);
            this.loadTasklet(tasklet);
        }
    }

    public void copy(IRequestCycle cycle) {
        ConnectionItem connection;
        Object[] params;
        Integer connToCopy;
        if (this.isAuthorizedForAction() && (connToCopy = (Integer)(params = cycle.getServiceParameters())[0]) != null && (connection = this.getConnectionFromList(connToCopy)) != null && !connection.isDraftConnection()) {
            ConnectionTasklet connTasklet;
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            if (connection.getRole().equals("IdP")) {
                connTasklet = this.loadRoleSpecificTasklet(connection);
                IdpConnection idpConnection = connectionManager.getIdpConnection(connection.getEntityId());
                this.prepare4Copy((ConnectionBase)idpConnection);
                IdpConnectionConfigTasklet idp = (IdpConnectionConfigTasklet)connTasklet;
                idp.setExistingConnection(true);
                idp.setIdpConnection(idpConnection);
                idp.setMode(Mode.edit);
                idp.populate(idpConnection);
                idp.gotoGeneralInfoState(cycle);
                idp.setCopied(true);
            } else {
                connTasklet = this.loadRoleSpecificTasklet(connection);
                SpConnection spConnection = connectionManager.getSpConnection(connection.getEntityId());
                this.prepare4Copy((ConnectionBase)spConnection);
                SpConnectionConfigTasklet sp = (SpConnectionConfigTasklet)connTasklet;
                sp.setExistingConnection(true);
                sp.setSpConnection(spConnection);
                sp.setMode(Mode.edit);
                sp.populate(spConnection);
                sp.resetCurrentStateToSourceState();
                sp.gotoGeneralInfoState(cycle);
                sp.setCopied(true);
            }
            connTasklet.markProtocolImgAvailable(true);
        }
    }

    private void prepare4Copy(ConnectionBase connection) {
        SpConnection spConn;
        connection.assignId();
        connection.setActive(connection.isActive());
        connection.setLicenseConnectionGroupAssignment(null);
        connection.setCopiedConnection(true);
        connection.setEntityIdOnDisk(null);
        connection.setSourceIdOnDisk(null);
        connection.setFileSystemPath(null);
        connection.setCreationTime(null);
        connection.setLastModified(null);
        ConnectionCerts dsigVerificationCerts = connection.getDsigVerificationCerts();
        for (Object cert : dsigVerificationCerts.getAllVerificationCerts()) {
            cert.setAlias(null);
        }
        ConnectionCerts clientAuthCerts = connection.getClientAuthCerts();
        for (Cert cert : clientAuthCerts.getAllVerificationCerts()) {
            cert.setAlias(null);
        }
        EncryptionSettings encryptionSettings = connection.getEncryptionSettings();
        Cert encryptionCert = encryptionSettings.getEncryptionCert();
        if (encryptionCert != null) {
            encryptionCert.setAlias(null);
        }
        if (connection instanceof SpConnection && (spConn = (SpConnection)connection).getConnectionTargetType().equals("PingOneSCIM11")) {
            spConn.setConnectionTargetType("Standard");
        }
        ConnectionModuleSupport connectionModuleSupport = ConnectionModuleSupport.getInstance();
        ArrayList<ConnectionModuleConfiguration> moduleConfigsToInclude = new ArrayList<ConnectionModuleConfiguration>();
        for (ConnectionModuleConfiguration moduleConfiguration : connection.getConnectionModuleConfigurations()) {
            boolean includeConfiguration = connectionModuleSupport.isIncludeConfigurationWithCopy(connection.getRoleType(), moduleConfiguration.getClass());
            if (!includeConfiguration) continue;
            moduleConfigsToInclude.add(moduleConfiguration);
        }
        connection.setConnectionModuleConfigurations(moduleConfigsToInclude);
    }

    private Tasklet createAndPopulateIdpTasklet(ConnectionItem connection) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        IdpConnection idpConnection = connectionManager.getIdpConnection(connection.getEntityId());
        idpConnection.setActive(this.getConnectionStatus(connection));
        IdpConnectionConfigTasklet tasklet = this.getCurrentTasklet().createTaskletToLoad(IdpConnectionConfigTasklet.class);
        tasklet.setStartTime(System.currentTimeMillis());
        tasklet.setIdpConnection(idpConnection);
        tasklet.setExistingConnection(true);
        tasklet.setMode(Mode.edit);
        tasklet.populate(idpConnection);
        return tasklet;
    }

    private Tasklet createAndPopulateSpTasklet(ConnectionItem connection) {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        SpConnection spConnection = connectionManager.getSpConnection(connection.getEntityId());
        spConnection.setActive(this.getConnectionStatus(connection));
        SpConnectionConfigTasklet tasklet = this.getCurrentTasklet().createTaskletToLoad(SpConnectionConfigTasklet.class);
        tasklet.setStartTime(System.currentTimeMillis());
        tasklet.setSpConnection(spConnection);
        tasklet.setExistingConnection(true);
        tasklet.setMode(Mode.edit);
        tasklet.populate(spConnection);
        return tasklet;
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String connId = (String)params[1];
            ConnectionItem connToDelete = null;
            for (ConnectionItem conn : this.getDisplayList()) {
                if (!conn.getSystemId().equals(connId)) continue;
                connToDelete = conn;
            }
            if (connToDelete != null) {
                this.getCurrentState(ConnMgmtState.class).deleteConnection(connToDelete);
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("connection list");
        }
    }

    private ConnectionTasklet getRoleSpecificTasklet(ConnectionItem connection) {
        return connection.getRole().equals("IdP") ? (ConnectionTasklet)this.createTaskletToLoad(IdpConnectionConfigTasklet.class) : (ConnectionTasklet)this.createTaskletToLoad(SpConnectionConfigTasklet.class);
    }

    private ConnectionTasklet loadRoleSpecificTasklet(ConnectionItem connection) {
        return connection.getRole().equals("IdP") ? (ConnectionTasklet)this.loadNewTasklet(IdpConnectionConfigTasklet.class) : (ConnectionTasklet)this.loadNewTasklet(SpConnectionConfigTasklet.class);
    }

    public void sortConnName(IRequestCycle cycle) {
        State state = this.getState();
        if (state.sortBy == SORT_BY.Name) {
            state.sortConnNameUp = !state.sortConnNameUp;
        }
        state.sortBy = SORT_BY.Name;
        this.saveState(state);
    }

    public void sortConnId(IRequestCycle cycle) {
        State state = this.getState();
        if (state.sortBy == SORT_BY.Id) {
            state.sortConnIdUp = !state.sortConnIdUp;
        }
        state.sortBy = SORT_BY.Id;
        this.saveState(state);
    }

    public void sortVirtualIdentity(IRequestCycle cycle) {
        State state = this.getState();
        if (state.sortBy == SORT_BY.VirtualIdentity) {
            state.sortVirtualIdentityUp = !state.sortVirtualIdentityUp;
        }
        state.sortBy = SORT_BY.VirtualIdentity;
        this.saveState(state);
    }

    public void sortProtocol(IRequestCycle cycle) {
        State state = this.getState();
        if (state.sortBy == SORT_BY.Protocol) {
            state.sortProtocolUp = !state.sortProtocolUp;
        }
        state.sortBy = SORT_BY.Protocol;
        this.saveState(state);
    }

    public void sortStatus(IRequestCycle cycle) {
        State state = this.getState();
        if (state.sortBy == SORT_BY.Status) {
            state.sortStatusUp = !state.sortStatusUp;
        }
        state.sortBy = SORT_BY.Status;
        this.saveState(state);
    }

    public ConnectionItem getConnectionFromList(Integer identifier) {
        return this.getDisplayList().get(identifier);
    }

    public boolean isConnNameUp() {
        State state = this.getState();
        return state.sortConnNameUp && state.sortBy == SORT_BY.Name;
    }

    public boolean isConnNameDown() {
        State state = this.getState();
        return !state.sortConnNameUp && state.sortBy == SORT_BY.Name;
    }

    public boolean isConnIdUp() {
        State state = this.getState();
        return state.sortConnIdUp && state.sortBy == SORT_BY.Id;
    }

    public boolean isConnIdDown() {
        State state = this.getState();
        return !state.sortConnIdUp && state.sortBy == SORT_BY.Id;
    }

    public boolean isVirtualIdentityUp() {
        State state = this.getState();
        return state.sortVirtualIdentityUp && state.sortBy == SORT_BY.VirtualIdentity;
    }

    public boolean isVirtualIdentityDown() {
        State state = this.getState();
        return !state.sortVirtualIdentityUp && state.sortBy == SORT_BY.VirtualIdentity;
    }

    public boolean isProtocolSortUp() {
        State state = this.getState();
        return state.sortProtocolUp && state.sortBy == SORT_BY.Protocol;
    }

    public boolean isProtocolSortDown() {
        State state = this.getState();
        return !state.sortProtocolUp && state.sortBy == SORT_BY.Protocol;
    }

    public boolean isStatusSortUp() {
        State state = this.getState();
        return state.sortStatusUp && state.sortBy == SORT_BY.Status;
    }

    public boolean isStatusSortDown() {
        State state = this.getState();
        return !state.sortStatusUp && state.sortBy == SORT_BY.Status;
    }

    public boolean isCreateConnectionDisabled() {
        return !LicenseManager.canAddConnection();
    }

    public ProtocolType getProtocolType() {
        State state = this.getState();
        return state.protocolType;
    }

    public void setProtocolType(ProtocolType protocolType) {
        State state = this.getState();
        state.protocolType = protocolType;
        this.saveState(state);
    }

    public ConnectionImageType getConnectionImageType() {
        State state = this.getState();
        return state.connectionImageType;
    }

    public void setConnectionImageType(ConnectionImageType connectionImageType) {
        State state = this.getState();
        state.connectionImageType = connectionImageType;
        this.saveState(state);
    }

    public StatusType getStatusType() {
        State state = this.getState();
        return state.statusType;
    }

    public void setStatusType(StatusType statusType) {
        State state = this.getState();
        state.statusType = statusType;
        this.saveState(state);
    }

    public ArrayList<ConnectionItem> getDisplayList() {
        State state = this.getState();
        return state.displayList;
    }

    public boolean isLicenseGroupDefined() {
        return LicenseManager.isConnectionGroupDefined();
    }

    public boolean isDisplaySortingControls() {
        return !this.getUseCustomSortControlsBinding().getBoolean();
    }

    public boolean isDisableSelectAction() {
        return this.getDisableActionDropDownBinding().getBoolean();
    }

    public void toggle(IRequestCycle cycle) {
        TaskletState state = this.getCurrentState();
        if (state instanceof ConnectionToggleState) {
            Object[] params = cycle.getServiceParameters();
            String systemId = (String)params[0];
            ConnectionItem connToToggle = null;
            for (ConnectionItem conn : this.getDisplayList()) {
                if (!conn.getSystemId().equals(systemId)) continue;
                connToToggle = conn;
            }
            ConnectionToggleState toggleState = (ConnectionToggleState)((Object)state);
            toggleState.toggleConnection(connToToggle);
        }
    }

    private boolean getConnectionStatus(ConnectionItem connection) {
        TaskletState state = this.getCurrentState();
        if (state instanceof ConnectionToggleState) {
            return ((ConnectionToggleState)((Object)state)).getCurrentStatus(connection);
        }
        return connection.isActive();
    }

    public class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        boolean sortConnIdUp;
        boolean sortConnNameUp;
        boolean sortVirtualIdentityUp;
        boolean sortProtocolUp;
        boolean sortStatusUp;
        boolean sortModificationTimeUp;
        boolean sortCreationTimeUp;
        SORT_BY sortBy = SORT_BY.Name;
        ProtocolType protocolType = ProtocolType.ALL;
        ConnectionImageType connectionImageType = ConnectionImageType.ALL;
        StatusType statusType = StatusType.ALL;
        ArrayList<ConnectionItem> displayList;
    }

    public static enum SORT_BY {
        Name,
        Id,
        VirtualIdentity,
        Protocol,
        Status,
        ModificationTime,
        CreationTime;

    }
}

