/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public abstract class DataMap
extends TaskletCard {
    public static final Object FIXED_TEXT_VALUE = new Object();
    public static final Object TEXT_VALUE = new Object();
    public static final Object ATTR_QUERY_VALUE = new Object();
    public static final Object EXPRESSION_VALUE = new Object();
    public static final Object REQUEST_VALUE = new Object();
    private Map<String, TargetedAttributeMappingValue> flattenedAttributeMap;
    private String targetItem;
    private IPropertySelectionModel sourcesModel;
    private List<ChangeRecord> pendingChanges = new ArrayList<ChangeRecord>();
    private boolean isRewinding;
    private String itemToTest;

    public abstract IBinding getTargetBinding();

    public abstract IBinding getSourcesBinding();

    public abstract IBinding getModelBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getDataMapListOrderBinding();

    public abstract IBinding getDatetimeColumnsBinding();

    public Collection<String> getTarget() {
        return (Collection)this.getTargetBinding().getObject("target", Collection.class);
    }

    public Sources getSources() {
        return (Sources)this.getSourcesBinding().getObject("sources", Sources.class);
    }

    public List<String> getDataMapListOrder() {
        IBinding binding = this.getDataMapListOrderBinding();
        if (binding != null) {
            return (List)binding.getObject("dataMapListOrder", List.class);
        }
        return null;
    }

    public List<String> getDatetimeColumns() {
        IBinding binding = this.getDatetimeColumnsBinding();
        if (binding != null) {
            return (List)binding.getObject("datetimeColumns", List.class);
        }
        return null;
    }

    public Model getModel() {
        return (Model)this.getModelBinding().getObject("model", Model.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        this.isRewinding = cycle.isRewinding();
        if (!this.isRewinding) {
            Model model = this.getModel();
            HashSet<String> currentTargets = new HashSet<String>(this.getTarget());
            HashSet<String> mappedTargets = new HashSet<String>(model.getTargets());
            mappedTargets.removeAll(currentTargets);
            for (String target : mappedTargets) {
                model.remove(target);
            }
            Map<String, String> substituterValues = this.getSources().getValidSubstituterValues();
            for (Map.Entry<String, String> entry : substituterValues.entrySet()) {
                String key = entry.getKey();
                boolean foundIt = false;
                for (TestDataItem item : model.getTestDataList()) {
                    if (!key.equals(item.getFieldName())) continue;
                    foundIt = true;
                    break;
                }
                if (foundIt) continue;
                model.getTestDataList().add(new TestDataItem(key, ""));
            }
        }
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this.sourcesModel = null;
        if (this.isRewinding) {
            Model m = this.getModel();
            if (!this.pendingChanges.isEmpty()) {
                HashMap map = new HashMap();
                for (ChangeRecord changeRecord : this.pendingChanges) {
                    String actualTarget = this.flattenedAttributeMap.get(changeRecord.target).getTarget();
                    ArrayList<AttrMappingValue> amvList = (ArrayList<AttrMappingValue>)map.get(actualTarget);
                    if (amvList == null) {
                        amvList = new ArrayList<AttrMappingValue>();
                        map.put(actualTarget, amvList);
                    }
                    String sourceKey = changeRecord.source;
                    String sourceType = Sources.getSourceTypeFromKey(sourceKey);
                    String attributeSourceId = Sources.getSourceIdFromKey(sourceKey);
                    amvList.add(new AttrMappingValue(SourceTypeString.strToType((String)sourceType), changeRecord.value, null, attributeSourceId));
                }
                for (Map.Entry entry : map.entrySet()) {
                    m.updateSource((String)entry.getKey(), (List)entry.getValue());
                }
                this.pendingChanges.clear();
            }
        }
        super.cleanupAfterRender(cycle);
    }

    public List<String> getTargetList() {
        Collection<String> rawTagetList = this.getTarget();
        Map<String, String> disp2RealNameMap = this.makeUniqueDisplayNameList(rawTagetList);
        ArrayList<String> encodedTargetList = new ArrayList<String>(disp2RealNameMap.keySet());
        this.orderDataMap(encodedTargetList);
        this.flattenAttributeMapping(disp2RealNameMap);
        return encodedTargetList;
    }

    private void flattenAttributeMapping(Map<String, String> disp2RealNameMap) {
        this.flattenedAttributeMap = new HashMap<String, TargetedAttributeMappingValue>();
        AttributeMapping mapping = this.getModel().getMapping();
        Map map = mapping.getAttributeMapping();
        for (Map.Entry entry : map.entrySet()) {
            for (AttrMappingValue amv : (List)entry.getValue()) {
                String uniqueDisplayName = this.makeUniqueDisplayName(this.flattenedAttributeMap.keySet(), (String)entry.getKey());
                if (disp2RealNameMap.get(uniqueDisplayName) == null) continue;
                this.flattenedAttributeMap.put(uniqueDisplayName, new TargetedAttributeMappingValue((String)entry.getKey(), amv.getType(), amv.getValue(), amv.getAttributeSourceId()));
            }
        }
        for (Map.Entry<Object, Object> entry : disp2RealNameMap.entrySet()) {
            if (this.flattenedAttributeMap.get(entry.getKey()) != null) continue;
            this.flattenedAttributeMap.put((String)entry.getKey(), new TargetedAttributeMappingValue((String)entry.getValue(), this.getModel().getDefaultSourceType(), "", null));
        }
    }

    private Map<String, String> makeUniqueDisplayNameList(Collection<String> inList) {
        HashMap<String, String> uniqueNameMap = new HashMap<String, String>();
        if (inList != null && !inList.isEmpty()) {
            for (String realAttrName : inList) {
                String uniqueDisplayName = this.makeUniqueDisplayName(uniqueNameMap.keySet(), realAttrName);
                uniqueNameMap.put(uniqueDisplayName, realAttrName);
            }
        }
        return uniqueNameMap;
    }

    private String makeUniqueDisplayName(Set<String> usedNameSet, String origName) {
        Object uniqueName = origName;
        int i = 1;
        while (usedNameSet.contains(uniqueName)) {
            uniqueName = origName + "\t(" + i++ + ")";
        }
        return uniqueName;
    }

    public String getTargetItem() {
        return this.targetItem;
    }

    public void setTargetItem(String targetItem) {
        this.targetItem = targetItem;
    }

    public IPropertySelectionModel getSourcesModel() {
        if (this.sourcesModel == null) {
            Sources sources = this.getSources();
            this.sourcesModel = new StringPairPropertySelectionModel(true);
            for (String sourceKey : sources.getSourceMap().keySet()) {
                String sourceLabel = sources.getSourceKeysToLabels().get(sourceKey);
                if (sourceLabel == null) {
                    sourceLabel = sourceKey;
                }
                ((StringPairPropertySelectionModel)this.sourcesModel).add(sourceLabel, sourceKey);
            }
            ((StringPairPropertySelectionModel)this.sourcesModel).sort();
        }
        return this.sourcesModel;
    }

    public String getSelectedSource() {
        TargetedAttributeMappingValue tamv = this.flattenedAttributeMap.get(this.targetItem);
        String selectedSource = Sources.createSourceKey(tamv.getTypeString(), tamv.getAttributeSourceId());
        return selectedSource == null ? "" : selectedSource;
    }

    public String getExistingTargetValue() {
        TargetedAttributeMappingValue tamv = this.flattenedAttributeMap.get(this.targetItem);
        if (tamv != null) {
            return tamv.getValue();
        }
        return null;
    }

    public List<String> getSelectedSources() {
        return this.getModel().getSources(this.targetItem);
    }

    public void setSelectedSource(String selectedSource) {
        if (this.isRewinding) {
            String oldSelectedSource = this.getSelectedSource();
            ChangeRecord r = new ChangeRecord(ChangeRecord.Type.SOURCE, this.targetItem);
            r.oldSource = oldSelectedSource;
            if (selectedSource != null && selectedSource.equals(oldSelectedSource) && "Expression".equals(oldSelectedSource) && !this.isEaAdmin()) {
                r.source = oldSelectedSource;
                r.value = this.getExistingTargetValue();
            } else {
                r.source = selectedSource;
                r.value = null;
            }
            this.pendingChanges.add(r);
        }
    }

    public IPropertySelectionModel getValuesModel() {
        return (IPropertySelectionModel)this.getSources().get(this.getSelectedSource());
    }

    public String getValueItem() {
        return this.flattenedAttributeMap.get(this.targetItem).getValue();
    }

    public void setValueItem(String valueItem) {
        if (this.isRewinding) {
            ChangeRecord pendingChange = null;
            ChangeRecord lastChange = this.getLastChange();
            if (lastChange != null && lastChange.target.equals(this.targetItem)) {
                pendingChange = lastChange;
            }
            if (pendingChange != null) {
                pendingChange.value = pendingChange.oldSource.equals(pendingChange.source) ? valueItem : null;
            } else {
                String oldValueItem = this.getValueItem();
                if (oldValueItem == null || !oldValueItem.equals(valueItem)) {
                    ChangeRecord r = new ChangeRecord(ChangeRecord.Type.VALUE, this.targetItem);
                    r.source = this.getSelectedSource();
                    r.oldValue = oldValueItem;
                    r.value = valueItem;
                    this.pendingChanges.add(r);
                }
            }
        }
    }

    private ChangeRecord getLastChange() {
        if (!this.pendingChanges.isEmpty()) {
            return this.pendingChanges.get(this.pendingChanges.size() - 1);
        }
        return null;
    }

    public boolean getSelectedSourceIsList() {
        return this.getSources().get(this.getSelectedSource()) instanceof IPropertySelectionModel;
    }

    public boolean getSelectedSourceIsText() {
        return this.getSources().get(this.getSelectedSource()) == TEXT_VALUE;
    }

    public boolean getSelectedSourceIsFixed() {
        return this.getSources().get(this.getSelectedSource()) == FIXED_TEXT_VALUE;
    }

    public boolean getSelectedSourceIsExpression() {
        return this.getSources().get(this.getSelectedSource()) == EXPRESSION_VALUE;
    }

    public boolean getSelectedSourceIsDatetimeColumn() {
        List<String> datetimeColumnsList = this.getDatetimeColumns();
        return datetimeColumnsList != null && datetimeColumnsList.contains(this.getTargetItem());
    }

    public String getTargetName() {
        return this.getModel().getTargetName();
    }

    public String getDatetimeExampleLinkText() {
        return this.getMessage("Datetime_example_link_text");
    }

    public boolean isTestingExpression() {
        return this.getModel().isTestingExpression();
    }

    public void setTestingExpression(boolean testingExpression) {
        this.getModel().setTestingExpression(testingExpression);
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        this.itemToTest = (String)params[0];
        this.setTestingExpression(true);
    }

    public String getExpressionToTest() {
        Model model = this.getModel();
        return model.getValue(this.itemToTest);
    }

    public void setExpressionToTest(String expression) {
        Model model = this.getModel();
        model.updateValue(this.itemToTest, "EXPRESSION", expression, "");
    }

    public List<TestDataItem> getTestDataList() {
        return this.getModel().getTestDataList();
    }

    public void setTestDataList(List<TestDataItem> testDataList) {
        this.getModel().setTestDataList(testDataList);
    }

    public Object getExpressionTestState() {
        return this.getModel().getExpressionTestState();
    }

    public void setExpressionTestState(Object state) {
        this.getModel().setExpressionTestState(state);
    }

    private void orderDataMap(List<String> listToOrder) {
        List<String> order = this.getDataMapListOrder();
        if (order != null && !order.isEmpty()) {
            Object[] a = order.toArray();
            ListIterator<String> i = listToOrder.listIterator();
            for (int j = 0; j < a.length; ++j) {
                i.next();
                i.set((String)a[j]);
            }
        } else {
            Collections.sort(listToOrder);
        }
    }

    public boolean isDisplayValue() {
        return this.getModel().isDisplayValue(this.getSelectedSource());
    }

    public boolean isEaAdmin() {
        AdministrativeUser user = this.getCurrentUser();
        return user != null && user.isExpressionAdmin();
    }

    private static class TargetedAttributeMappingValue
    extends AttrMappingValue {
        private static final long serialVersionUID = 6309325591025790933L;
        private String target;

        public TargetedAttributeMappingValue(String target, org.sourceid.saml20.domain.SourceType type, String value, String attributeSourceId) {
            super(type, value, null, attributeSourceId);
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return this.target.equals(((TargetedAttributeMappingValue)((Object)o)).getTarget());
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + Objects.hash(this.target);
        }
    }

    public static class Sources
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Object> sources = new HashMap<String, Object>();
        private Map<String, String> sourceKeysToLabels = new HashMap<String, String>();
        private Map<String, String> validSubstituterValues = new HashMap<String, String>();
        private boolean validateTextField = true;
        private String customizedErrorMessage;
        private Map<String, String> additionalValidValues;
        private boolean allowBlankTextValues;

        public void addPropertySelectionSource(String key, IPropertySelectionModel model) {
            if (model instanceof StringPairPropertySelectionModel) {
                ((StringPairPropertySelectionModel)model).sort();
            }
            this.addPropertySelectionSource(key, model, null);
        }

        public void addPropertySelectionSource(String key, IPropertySelectionModel model, String prefix) {
            this.addPropertySelectionSource(key, null, null, model, prefix);
        }

        public void addPropertySelectionSource(String sourceType, String sourceId, String sourceLabel, IPropertySelectionModel model) {
            this.addPropertySelectionSource(sourceType, sourceId, sourceLabel, model, null);
        }

        public void addPropertySelectionSource(String sourceType, String sourceId, String sourceLabel, IPropertySelectionModel model, String prefix) {
            this.addPropertySelectionSource(sourceType, sourceId, null, sourceLabel, model, prefix);
        }

        public void addPropertySelectionSource(String sourceType, String sourceId, String sourceIdLabel, String sourceLabel, IPropertySelectionModel model, String prefix) {
            String key = Sources.createSourceKey(sourceType, sourceId);
            this.sources.put(key, new SelectionModelWrapper(model));
            this.sourceKeysToLabels.put(key, sourceLabel);
            if (StringUtils.isEmpty((String)prefix)) {
                prefix = "";
                if (key.startsWith("JDBC") || key.startsWith("LDAP") || key.startsWith("Other") || key.startsWith("Custom")) {
                    prefix = "ds.";
                    if (sourceIdLabel != null) {
                        prefix = (String)prefix + sourceIdLabel + ".";
                    } else if (sourceId != null) {
                        prefix = (String)prefix + sourceId + ".";
                    }
                } else if (key.startsWith("Mapped Attributes")) {
                    prefix = "mapped.";
                } else if (key.startsWith("Tracked HTTP Parameters")) {
                    prefix = "trackedparams.";
                }
            } else {
                if (!((String)prefix).endsWith(".")) {
                    prefix = (String)prefix + ".";
                }
                if (sourceIdLabel != null) {
                    prefix = (String)prefix + sourceIdLabel + ".";
                } else if (sourceId != null) {
                    prefix = (String)prefix + sourceId + ".";
                }
            }
            for (int i = 0; i < model.getOptionCount(); ++i) {
                String option = (String)model.getOption(i);
                if (option == null) continue;
                String tempKey = (String)prefix + option;
                this.validSubstituterValues.put(tempKey, tempKey);
            }
        }

        public void addNoMappingSource(String key) {
            this.sources.put(key, org.sourceid.saml20.domain.SourceType.NO_MAPPING.toString());
        }

        public void addTextSource(String key) {
            this.sources.put(key, TEXT_VALUE);
        }

        public void addAttrQuerySource(String key) {
            this.sources.put(key, ATTR_QUERY_VALUE);
        }

        public void addExpressionSource(String key) {
            this.sources.put(key, EXPRESSION_VALUE);
        }

        public void addSystemManagedSource(String key) {
            this.sources.put(key, FIXED_TEXT_VALUE);
        }

        public boolean isValidSourceValue(String key, String value) {
            Object o = this.sources.get(key);
            this.customizedErrorMessage = null;
            if (o instanceof SelectionModelWrapper) {
                return ((SelectionModelWrapper)o).isValidValue(value);
            }
            if (o == TEXT_VALUE) {
                if (this.validateTextField) {
                    if (this.additionalValidValues != null) {
                        for (Map.Entry<String, String> e : this.additionalValidValues.entrySet()) {
                            this.validSubstituterValues.put(e.getKey(), e.getValue());
                        }
                    }
                    TextSourceTypeValidatorBuilder validatorBuilder = new TextSourceTypeValidatorBuilder();
                    validatorBuilder.setAcceptAnyValue(false);
                    validatorBuilder.setAcceptBlankValues(this.allowBlankTextValues);
                    Set<String> validSubstituterKeys = this.getDeprecatedExtClientMetadataPrefix();
                    validatorBuilder.setSubstitutionVariables(validSubstituterKeys);
                    AttributeFulfillmentValue afv = new AttributeFulfillmentValue();
                    afv.setSource(new SourceTypeIdKey(SourceType.TEXT));
                    afv.setValue(value);
                    return validatorBuilder.buildMappingValidator(key, afv, null).validate();
                }
                return true;
            }
            if (o == EXPRESSION_VALUE) {
                ExpressionManager expressionManager = ExpressionManager.getInstance();
                if (!expressionManager.isEvaluateExpressionsOn()) {
                    this.customizedErrorMessage = "Error during expression evaluation: ";
                    return false;
                }
                if (this.validateTextField) {
                    ExpressionSourceTypeValidatorBuilder exprBuilder = new ExpressionSourceTypeValidatorBuilder();
                    Set<String> validSubstituterKeys = this.getDeprecatedExtClientMetadataPrefix();
                    exprBuilder.setSubstitutionVariables(validSubstituterKeys);
                    AttributeFulfillmentValue afv = new AttributeFulfillmentValue();
                    afv.setSource(new SourceTypeIdKey(SourceType.EXPRESSION));
                    afv.setValue(value);
                    Validator validator = exprBuilder.buildMappingValidator(null, afv, "");
                    if (!validator.validate()) {
                        if (!validator.getErrors().isEmpty()) {
                            ValidationError error = (ValidationError)validator.getErrors().get(0);
                            String msg = error.getDeveloperMessage();
                            if (msg == null) {
                                msg = error.getMessage();
                            }
                            this.customizedErrorMessage = msg;
                        }
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return "No Mapping".equals(key) && org.sourceid.saml20.domain.SourceType.NO_MAPPING.toString().equals(value);
        }

        public Set<String> getDeprecatedExtClientMetadataPrefix() {
            HashSet<String> validSubstituterKeys = new HashSet<String>(this.validSubstituterValues.keySet());
            for (String validSubstituterKey : this.validSubstituterValues.keySet()) {
                if (!validSubstituterKey.startsWith("extproperties.") && !validSubstituterKey.startsWith("extclientmetadata.")) continue;
                String prefix = "extclientmetadata.";
                String suffix = "extproperties.";
                if (validSubstituterKey.startsWith("extclientmetadata.")) {
                    prefix = "extproperties.";
                    suffix = "extclientmetadata.";
                }
                String s = prefix + validSubstituterKey.substring(suffix.length());
                validSubstituterKeys.add(s);
            }
            return validSubstituterKeys;
        }

        public void reset() {
            this.sources.clear();
            this.validSubstituterValues.clear();
        }

        public boolean isAllowBlankTextValues() {
            return this.allowBlankTextValues;
        }

        public void setAllowBlankTextValues(boolean allowBlankTextValues) {
            this.allowBlankTextValues = allowBlankTextValues;
        }

        public Map<String, Object> getSourceMap() {
            return this.sources;
        }

        public Object get(String key) {
            return this.sources.get(key);
        }

        public boolean isValidateTextField() {
            return this.validateTextField;
        }

        public void setValidateTextField(boolean validateTextField) {
            this.validateTextField = validateTextField;
        }

        public String getCustomizedErrorMessage() {
            return this.customizedErrorMessage;
        }

        public Map<String, String> getValidSubstituterValues() {
            return this.validSubstituterValues;
        }

        public void setAdditionalValidValues(Map<String, String> additionalValidValues) {
            this.additionalValidValues = additionalValidValues;
        }

        public static String createSourceKey(String sourceType, String sourceId) {
            Object key = sourceType;
            if (!StringUtils.isEmpty((String)sourceId)) {
                key = (String)key + "_" + sourceId;
            }
            return key;
        }

        public static String getSourceTypeFromKey(String sourceKey) {
            String sourceType = sourceKey;
            if (sourceKey != null && sourceKey.contains("_")) {
                sourceType = sourceKey.substring(0, sourceKey.indexOf("_"));
            }
            return sourceType;
        }

        public static String getSourceIdFromKey(String sourceKey) {
            String sourceId = null;
            if (sourceKey != null && sourceKey.contains("_")) {
                sourceId = sourceKey.substring(sourceKey.indexOf("_") + 1);
            }
            return sourceId;
        }

        public Map<String, String> getSourceKeysToLabels() {
            return this.sourceKeysToLabels;
        }
    }

    public static interface Model {
        public void updateSource(String var1, List<AttrMappingValue> var2);

        public void updateSource(String var1, String var2, String var3, String var4);

        public void updateValue(String var1, String var2, String var3, String var4);

        public Set<String> getTargets();

        public void remove(String var1);

        public String getSource(String var1);

        public List<String> getSources(String var1);

        public String getValue(String var1);

        public boolean contains(String var1);

        public String getTargetName();

        public void setTargetName(String var1);

        public boolean isTestingExpression();

        public void setTestingExpression(boolean var1);

        public List<TestDataItem> getTestDataList();

        public void setTestDataList(List<TestDataItem> var1);

        public Object getExpressionTestState();

        public void setExpressionTestState(Object var1);

        public AttributeMapping getMapping();

        public void cleanMappings(Set<String> var1);

        public boolean isDisplayValue(String var1);

        public org.sourceid.saml20.domain.SourceType getDefaultSourceType();
    }

    public static class SelectionModelWrapper
    implements IPropertySelectionModel {
        private transient IPropertySelectionModel delegate;
        private Set<String> validValues = new HashSet<String>();

        public SelectionModelWrapper(IPropertySelectionModel delegate) {
            this.delegate = delegate;
            for (int i = 0; i < delegate.getOptionCount(); ++i) {
                String s = (String)delegate.getOption(i);
                if (StringUtils.isBlank((String)s)) continue;
                this.validValues.add(s);
            }
        }

        public boolean isValidValue(String value) {
            return this.validValues.contains(value);
        }

        public int getOptionCount() {
            return this.delegate.getOptionCount();
        }

        public Object getOption(int index) {
            return this.delegate.getOption(index);
        }

        public String getLabel(int index) {
            return this.delegate.getLabel(index);
        }

        public String getValue(int index) {
            return this.delegate.getValue(index);
        }

        public Object translateValue(String index) {
            return this.delegate.translateValue(index);
        }
    }

    private static class ChangeRecord {
        public Type type;
        public String source;
        public String value;
        public String target;
        public String oldSource;
        public String oldValue;

        public ChangeRecord(Type type, String target) {
            this.type = type;
            this.target = target;
        }

        static enum Type {
            SOURCE,
            VALUE;

        }
    }
}

