/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.admin.api.validator.ExtendedPropertyValueValidator;
import com.pingidentity.component.common.MultiValuedNamePair;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.StringPairListEditor;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class OAuthClientParamEditor
extends StringPairListEditor
implements StringPairListEditor.StringPairListEditorListener {
    private static final long serialVersionUID = 1L;
    private final ClientSettingManager paramDescManager = MgmtFactory.getClientSettingManager();

    public String getCurrentValue() {
        return this.getState().currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.getState().currentValue = currentValue;
    }

    public MultiValuedNamePair getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(MultiValuedNamePair updateItem) {
        ParamState s = this.getState();
        s.updateItem = updateItem;
        this.saveState(s);
    }

    @Override
    public void onDeleteListItem(StringPairListEditor owner, String itemToDeleteName) {
    }

    public MultiValuedNamePair getCurrentItem() {
        return this.getState().currentItem;
    }

    public void setCurrentItem(MultiValuedNamePair currentItem) {
        ParamState s = this.getState();
        s.currentItem = currentItem;
        this.saveState(s);
    }

    public MultiValuedNamePair getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(MultiValuedNamePair item) {
        ParamState s = this.getState();
        s.editItem = item;
        this.saveState(s);
    }

    public List<MultiValuedNamePair> getDisplayList() {
        ParamState state = this.getState();
        return state.displayList;
    }

    @Override
    protected ParamState getState() {
        ParamState state = (ParamState)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new ParamState();
            this.saveState(state);
        }
        return state;
    }

    @Override
    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    @Override
    public boolean isCurrentItemEditing() {
        ParamState curState = this.getState();
        return curState.currentItem.equals((Object)curState.editItem);
    }

    @Override
    public void onUpdateItem(IRequestCycle cycle) {
        ParamState s = this.getState();
        if (!this.validateUpdate((NameValuePair)s.updateItem, (NameValuePair)s.editItem)) {
            this.doUpdate();
            this.saveState(s);
        }
    }

    @Override
    protected void doEdit(IRequestCycle cycle) {
        ParamState state = this.getState();
        MultiValuedNamePair pair = (MultiValuedNamePair)this.getRequestCycleItem(cycle);
        state.editItem = new MultiValuedNamePair(pair);
        state.updateItem = new MultiValuedNamePair(pair);
    }

    @Override
    public void cancelEdit(IRequestCycle cycle) {
        this.doCancel();
        this.saveState(this.getState());
    }

    @Override
    protected void doCancel() {
        ParamState state = this.getState();
        state.updateItem = null;
        state.editItem = null;
    }

    @Override
    protected void doAdd() {
        ClientParam param;
        int index = this.getIndex();
        MultiValuedNamePair pair = (MultiValuedNamePair)this.getList().get(index);
        MultiValuedNamePair newPair = new MultiValuedNamePair(false, false);
        String paramName = pair.getName();
        boolean isFirst = pair.isFirstValue();
        newPair.setName(paramName);
        newPair.setValue(this.getState().currentValue);
        newPair.setFirstValue(isFirst);
        this.getList().remove(index);
        this.getList().add(index, (NameValuePair)newPair);
        boolean isMultiValued = false;
        if (this.paramDescManager.getExtendedProperties() != null && (param = (ClientParam)this.paramDescManager.getExtendedProperties().get(paramName)) != null) {
            isMultiValued = param.isMultiValued();
        }
        if (isMultiValued) {
            pair.setFirstValue(false);
            this.getList().add(index + 1, (NameValuePair)pair);
        }
        Collections.sort(this.getList());
        this.getState().currentValue = "";
    }

    @Override
    public void onAddItem(IRequestCycle cycle) {
        ParamState s = this.getState();
        MultiValuedNamePair pair = (MultiValuedNamePair)this.getList().get(this.getIndex());
        MultiValuedNamePair newPair = new MultiValuedNamePair(pair.isFirstValue(), pair.isLastValue());
        newPair.setName(pair.getName());
        newPair.setValue(s.currentValue);
        if (StringUtils.isNotEmpty((String)newPair.getValue()) && !this.validateAdd((NameValuePair)newPair, null)) {
            this.doAdd();
            this.saveState(s);
        }
        s.currentValue = "";
    }

    @Override
    public List<NameValuePair> getList() {
        List<NameValuePair> sortedList = super.getList();
        Collections.sort(sortedList);
        return sortedList;
    }

    @Override
    protected void doUpdate() {
        ParamState state = this.getState();
        int idx = this.getList().indexOf(state.editItem);
        this.getList().set(idx, (NameValuePair)state.updateItem);
        Collections.sort(this.getList());
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof StringPairListEditor.StringPairListEditorListener) {
            StringPairListEditor.StringPairListEditorListener listener = (StringPairListEditor.StringPairListEditorListener)o;
            listener.onUpdateListItem(this, state.editItem.getName(), state.updateItem.getName());
        }
        state.editItem = null;
        state.updateItem = null;
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        ParamState state = this.getState();
        state.displayList = new ArrayList<MultiValuedNamePair>();
        ArrayList<NameValuePair> sorted = new ArrayList<NameValuePair>(this.getList());
        Collections.sort(sorted);
        Iterator it = sorted.iterator();
        MultiValuedNamePair first = null;
        if (it.hasNext()) {
            first = (MultiValuedNamePair)it.next();
            first.setFirstValue(true);
            state.displayList.add(first);
        }
        while (it.hasNext()) {
            MultiValuedNamePair current = (MultiValuedNamePair)it.next();
            if (first != null && current.getName().equals(first.getName())) {
                current.setFirstValue(false);
                state.displayList.add(current);
                continue;
            }
            current.setFirstValue(true);
            state.displayList.add(current);
            first = current;
        }
        this.getState().currentValue = "";
    }

    @Override
    public String validate(String name, String value, String originalName, String originalValue, List<NameValuePair> list, StringPairListEditor owner) {
        ExtendedPropertyValueValidator validator = new ExtendedPropertyValueValidator(null);
        validator.validateParamEntry(name, value);
        Iterator iterator = validator.getErrors().iterator();
        if (iterator.hasNext()) {
            ValidationError error = (ValidationError)iterator.next();
            return error.getMessage();
        }
        return null;
    }

    @Override
    protected boolean basicItemValidate(NameValuePair itemToValidate, NameValuePair originalItem) {
        String value;
        String name;
        boolean hasErrors = false;
        if (StringUtils.isBlank((String)itemToValidate.getValue())) {
            this.recErrorMsg("Cannot update the property with an empty value.");
            hasErrors = true;
        }
        if (!hasErrors && !this.getAllowSameNameValue().booleanValue() && StringUtils.equals((String)(name = itemToValidate.getName()), (String)(value = itemToValidate.getValue()))) {
            this.recErrorMsg("The " + this.getNameColumnTitleBinding().getString() + " and " + this.getValueColumnTitleBinding().getString() + " values must be different.");
            hasErrors = true;
        }
        if (!hasErrors) {
            hasErrors = this.extraItemValidate(itemToValidate, originalItem);
        }
        return hasErrors;
    }

    protected class ParamState
    extends StringPairListEditor.State {
        private static final long serialVersionUID = 1L;
        MultiValuedNamePair updateItem;
        MultiValuedNamePair editItem;
        MultiValuedNamePair currentItem;
        String currentValue;
        List<MultiValuedNamePair> displayList;

        protected ParamState() {
            super(OAuthClientParamEditor.this);
            this.currentValue = null;
        }
    }
}

