/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.display.filter.PaginationNavItem;
import com.pingidentity.fsm.tasklet.TaskletCard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class Pagination
extends TaskletCard
implements Serializable {
    public static final int MAX_ITEMS_PER_PAGE_DEFAULT = 20;
    private static final long serialVersionUID = 20071076L;

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getOnStateActivatedBinding();

    public abstract IBinding getLookAheadAvailableIndexBinding();

    private int getLastPageInCurrentBlock() {
        int maxAvailableIndex = this.getLookAheadAvailableIndexBinding().getInt();
        return maxAvailableIndex / 20 + 1;
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    public List<PaginationNavItem> getPages() {
        return this.getState().getPages();
    }

    protected void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    protected State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
            this.saveState(state);
        }
        return state;
    }

    public void goToPage(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        int page = (Integer)params[0];
        this.goToPage(page);
    }

    public Boolean getOnStateActivated() {
        IBinding binding = this.getOnStateActivatedBinding();
        return binding.getBoolean();
    }

    public void setOnStateActivated(Boolean onScreenActivated) {
        IBinding binding = this.getOnStateActivatedBinding();
        binding.setBoolean(onScreenActivated.booleanValue());
    }

    protected void prepareForRender(IRequestCycle arg0) {
        super.prepareForRender(arg0);
        State state = this.getState();
        if (this.getOnStateActivated().booleanValue()) {
            this.setOnStateActivated(false);
        }
        state.pages = new ArrayList<PaginationNavItem>();
        for (PaginationNavItem item : this.getPages()) {
            state.pages.add(item);
        }
        this.saveState(state);
    }

    public int getPageCount() {
        return this.getPages().size();
    }

    public boolean showPaginationControls() {
        this.buildPaginationData();
        return this.getPages().size() > 1;
    }

    private Map<String, PaginationNavItem> getPageNavigation() {
        HashMap<String, PaginationNavItem> navItemMap = new HashMap<String, PaginationNavItem>();
        navItemMap.put(this.getState().PREVIOUS_PAGE, new PaginationNavItem(this.getCurrentPage() == 1 ? 1 : this.getCurrentPage() - 1, ""));
        navItemMap.put(this.getState().NEXT_PAGE, new PaginationNavItem(this.getCurrentPage() + 1 > this.getLastPageInCurrentBlock() ? this.getState().currentPage : this.getState().currentPage + 1, ""));
        return navItemMap;
    }

    private void buildPaginationData() {
        this.getState().pages = this.getPagesInBlock();
        this.getState().pageNavigation = this.getPageNavigation();
    }

    private List<PaginationNavItem> getPagesInBlock() {
        int firstPage;
        int lastPageInCurrentBlock;
        ArrayList<PaginationNavItem> pagesOfItems = new ArrayList<PaginationNavItem>();
        for (int i = firstPage = (lastPageInCurrentBlock = this.getLastPageInCurrentBlock()) - this.getState().MAX_PAGES_PER_BLOCK + 1 < 1 ? 1 : lastPageInCurrentBlock - this.getState().MAX_PAGES_PER_BLOCK + 1; i <= lastPageInCurrentBlock; ++i) {
            if (this.getCurrentPage() == i) {
                pagesOfItems.add(new PaginationNavItem(i, Integer.toString(i), "active"));
                continue;
            }
            pagesOfItems.add(new PaginationNavItem(i, Integer.toString(i)));
        }
        return pagesOfItems;
    }

    public void goToPage(int page) {
        this.getState().currentPage = page;
    }

    public int getCurrentPage() {
        return this.getState().currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.getState().currentPage = currentPage;
    }

    public int getPrevPageIndex() {
        return this.getState().pageNavigation.get(this.getState().PREVIOUS_PAGE).getIndex();
    }

    public String getPrevPageLabel() {
        return this.getState().pageNavigation.get(this.getState().PREVIOUS_PAGE).getLabel();
    }

    public int getNextPageIndex() {
        return this.getState().pageNavigation.get(this.getState().NEXT_PAGE).getIndex();
    }

    public String getNextPageLabel() {
        return this.getState().pageNavigation.get(this.getState().NEXT_PAGE).getLabel();
    }

    public static class State {
        private static final long serialVersionUID = 20050515L;
        public int MAX_PAGES_PER_BLOCK = 5;
        String PREVIOUS_PAGE = "PREVIOUS_PAGE";
        String NEXT_PAGE = "NEXT_PAGE";
        Map<String, PaginationNavItem> pageNavigation = new HashMap<String, PaginationNavItem>();
        int currentPage = 1;
        List<PaginationNavItem> pages;

        public List<PaginationNavItem> getPages() {
            return this.pages;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public void reset() {
            this.currentPage = 1;
            this.pages = null;
            this.pageNavigation.clear();
        }
    }
}

