/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.ProtocolType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import org.apache.tapestry.IBinding;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.websso.Protocol;

public abstract class ProtocolList
extends TaskletCard
implements Serializable {
    private boolean supportSaml20;
    private boolean supportSaml11;
    private boolean supportSaml10;
    private boolean supportWsFed;
    private boolean supportOidc;

    public abstract IBinding getLocalSettingsBinding();

    public abstract IBinding getSelectedRoleBinding();

    public abstract IBinding getSelectedProtocolBinding();

    public abstract IBinding getShowListBinding();

    public abstract IBinding getShowWsFedBinding();

    public abstract IBinding getShowOidcBinding();

    public abstract IBinding getShowSelectBinding();

    public abstract IBinding getShowAllBinding();

    public abstract IBinding getProtocolRequiredBinding();

    public StringPairPropertySelectionModel getProtocolList() {
        StringPairPropertySelectionModel protocolPairs = new StringPairPropertySelectionModel(this.getShowSelectBinding().getBoolean());
        if (this.getShowAllBinding().getBoolean()) {
            protocolPairs.add(ProtocolType.ALL.getLabel() + " Protocols", ProtocolType.ALL.getProtocol());
        }
        this.setFlags();
        if (this.supportSaml20) {
            protocolPairs.add(ProtocolType.SAML20.getLabel(), ProtocolType.SAML20.getProtocol());
        }
        if (this.supportSaml11) {
            protocolPairs.add(ProtocolType.SAML11.getLabel(), ProtocolType.SAML11.getProtocol());
        }
        if (this.supportSaml10) {
            protocolPairs.add(ProtocolType.SAML10.getLabel(), ProtocolType.SAML10.getProtocol());
        }
        if (this.supportWsFed && this.getShowWsFed()) {
            protocolPairs.add(ProtocolType.WSFED.getLabel(), ProtocolType.WSFED.getProtocol());
        }
        if (this.supportOidc && ConnectionType.IDP.getName().equals(this.getSelectedRole()) && this.getShowOidc()) {
            protocolPairs.add(ProtocolType.OIDC.getLabel(), ProtocolType.OIDC.getProtocol());
        }
        return protocolPairs;
    }

    protected String getSelectedRole() {
        return (String)this.getSelectedRoleBinding().getObject("selectedRole", String.class);
    }

    protected LocalSettings getLocalSettingsIntl() {
        return (LocalSettings)this.getLocalSettingsBinding().getObject("localSettings", LocalSettings.class);
    }

    public Protocol getSelectedProtocol() {
        return (Protocol)this.getSelectedProtocolBinding().getObject("selectedProtocol", Protocol.class);
    }

    public boolean getShowListFlag() {
        return this.getShowListBinding().getBoolean();
    }

    public void setSelectedProtocol(Protocol selectedProtocol) {
        this.getSelectedProtocolBinding().setObject((Object)selectedProtocol);
    }

    public boolean showListAndHasMultipleProtocols() {
        return this.getShowListFlag() && !this.hasSingleProtocol();
    }

    protected boolean getShowWsFed() {
        return this.getShowWsFedBinding().getBoolean();
    }

    protected boolean getShowOidc() {
        return this.getShowOidcBinding().getBoolean();
    }

    public String getProtocolName() {
        return ProtocolType.getProtocolStringForType(this.getSelectedProtocol());
    }

    public boolean hasSingleProtocol() {
        int count = 0;
        this.setFlags();
        if (this.supportSaml20) {
            ++count;
        }
        if (this.supportSaml11) {
            ++count;
        }
        if (this.supportSaml10) {
            ++count;
        }
        if (this.supportWsFed && this.getShowWsFed()) {
            ++count;
        }
        if (this.supportOidc && ConnectionType.IDP.getName().equals(this.getSelectedRole())) {
            ++count;
        }
        return count == 1;
    }

    protected void setFlags() {
        LocalSettings localSettings = this.getLocalSettingsIntl();
        if (ConnectionType.SP.getName().equals(this.getSelectedRole())) {
            this.supportSaml20 = localSettings.isEnableSamlIdP();
            this.supportSaml11 = localSettings.isEnableSamlOneOneAp();
            this.supportSaml10 = localSettings.isEnableSamlOneZeroAp();
            this.supportWsFed = localSettings.isEnableWsFedIdP();
        } else {
            this.supportSaml20 = localSettings.isEnableSamlSp();
            this.supportSaml11 = localSettings.isEnableSamlOneOneRp();
            this.supportSaml10 = localSettings.isEnableSamlOneZeroRp();
            this.supportWsFed = localSettings.isEnableWsFedSp();
            this.supportOidc = localSettings.isEnableOIDCSp();
        }
    }

    public String getProtocolRequiredActionClass() {
        if (this.getProtocolRequiredBinding().getBoolean()) {
            return "input-select required";
        }
        return "input-select";
    }
}

