/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public class SelectedOption {
    private static final Log log = LogFactory.getLog(SelectedOption.class);
    private FilterableSelectionFieldDescriptor.SearchableType type;
    private String id;

    public SelectedOption(String selectedOption) {
        String[] parts = selectedOption.split("-", 2);
        if (parts.length != 2) {
            log.error((Object)"Selected option was not formatted properly. Returning the entire selected ID.");
            this.id = selectedOption;
        } else {
            this.id = parts[1];
        }
        try {
            this.type = FilterableSelectionFieldDescriptor.SearchableType.fromTabTitle((String)parts[0]);
        }
        catch (FilterableSelectionFieldDescriptor.SearchableType.SearchableTypeNotFound e) {
            log.error((Object)("Selected option has invalid type. " + e.getMessage()));
        }
    }

    public SelectedOption(FilterableSelectionFieldDescriptor.SearchableType type, String id) {
        this.type = type;
        this.id = id;
    }

    public FilterableSelectionFieldDescriptor.SearchableType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.type.getTabTitle() + "-" + this.id;
    }
}

