/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.Source2TargetMappingsState;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import java.util.ArrayList;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;

public abstract class Source2TargetMappingList
extends TaskletCard {
    public abstract IBinding getMappingsBinding();

    public abstract String getMappingsHeader();

    public abstract boolean getShowMappingStatus();

    public ArrayList<Source2TargetMappingTasklet<?>> getMappings() {
        return (ArrayList)this.getMappingsBinding().getObject("mappings", ArrayList.class);
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (cycle.isRewinding()) {
            return;
        }
        TaskletListState state = (TaskletListState)this.getCurrentState();
        state.refreshTasklets();
    }

    public void edit(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String mappingToEdit = (String)params[0];
        if (mappingToEdit != null) {
            for (Source2TargetMappingTasklet<?> t : this.getMappings()) {
                if (!t.getDescription().equals(mappingToEdit)) continue;
                t.initialize();
                t.resetCurrentStateToSourceState();
                t.setMode(Mode.edit);
                this.loadTasklet(t);
                t.gotoSummaryState(cycle);
            }
        }
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            Integer mappingToDelete = (Integer)params[0];
            Source2TargetMappingsState state = (Source2TargetMappingsState)this.getCurrentState();
            state.deleteTasklet(mappingToDelete);
        } else {
            this.auditLogUnauthorizedUserDeleteAction("source to target mapping list");
        }
    }

    public void undelete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String mappingToDelete = (String)params[0];
            for (Source2TargetMappingTasklet<?> t : this.getMappings()) {
                if (!t.getDescription().equals(mappingToDelete)) continue;
                t.setItDeleted(false);
                return;
            }
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("source to target mapping list");
        }
    }

    protected boolean containsTaskletMapping(String sourceId, String targetId) {
        for (Source2TargetMappingTasklet<?> t : this.getMappings()) {
            Object s2tMapping = t.getSource2TargetMapping();
            if (!s2tMapping.getSourceId().equals(sourceId) || !s2tMapping.getTargetId().equals(targetId)) continue;
            return true;
        }
        return false;
    }
}

