/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class StringPairListEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int index;

    public abstract IBinding getListBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getAllowEmptyBinding();

    public abstract IBinding getValueColumnTitleBinding();

    public abstract IBinding getNameColumnTitleBinding();

    public abstract IBinding getOwnerStateBinding();

    public abstract IBinding getNameWidthBinding();

    public abstract IBinding getValueWidthBinding();

    public abstract IBinding getAllowEmptyNameOrValueBinding();

    public abstract IBinding getAllowSameNameValueBinding();

    public Boolean getAllowEmpty() {
        IBinding binding = this.getAllowEmptyBinding();
        return binding.getBoolean();
    }

    public Boolean getAllowEmptyNameOrValue() {
        IBinding binding = this.getAllowEmptyNameOrValueBinding();
        return binding.getBoolean();
    }

    public Boolean getAllowSameNameValue() {
        IBinding binding = this.getAllowSameNameValueBinding();
        return binding.getBoolean();
    }

    public List<NameValuePair> getList() {
        return (List)this.getListBinding().getObject("List", List.class);
    }

    public String getNameItemWidth() {
        return this.makeWidthStyleValue(this.getNameWidthBinding().getInt());
    }

    public String getValueItemWidth() {
        return this.makeWidthStyleValue(this.getValueWidthBinding().getInt());
    }

    private String makeWidthStyleValue(int baseWidth) {
        return "width:" + (baseWidth - 10) + "px;";
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    protected void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    protected State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
            this.saveState(state);
        }
        return state;
    }

    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    public boolean isCurrentItemEditing() {
        State curState = this.getState();
        return curState.currentItem.equals((Object)curState.editItem);
    }

    public void setCurrentItem(NameValuePair currentItem) {
        State s = this.getState();
        s.currentItem = currentItem;
        this.saveState(s);
    }

    public NameValuePair getCurrentItem() {
        return this.getState().currentItem;
    }

    public NameValuePair getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(NameValuePair newItem) {
        State s = this.getState();
        s.newItem = newItem;
        this.saveState(s);
    }

    public NameValuePair getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(NameValuePair item) {
        State s = this.getState();
        s.editItem = item;
        this.saveState(s);
    }

    public NameValuePair getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(NameValuePair updateItem) {
        State s = this.getState();
        s.updateItem = updateItem;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        State s = this.getState();
        if (!this.validateAdd(s.newItem, null)) {
            this.doAdd();
            this.saveState(s);
        }
    }

    protected boolean validateAdd(NameValuePair itemToValidate, NameValuePair originalItem) {
        return this.basicItemValidate(itemToValidate, originalItem);
    }

    protected void doAdd() {
        State state = this.getState();
        this.getList().add(state.newItem);
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof StringPairListEditorListener) {
            StringPairListEditorListener listener = (StringPairListEditorListener)o;
            listener.onAddListItem(this, state.newItem.getName());
        }
        state.newItem = new NameValuePair();
    }

    protected boolean basicItemValidate(NameValuePair itemToValidate, NameValuePair originalItem) {
        String value;
        String name;
        boolean hasErrors = false;
        if (this.getAllowEmptyNameOrValue().booleanValue()) {
            if (StringUtils.isBlank((String)itemToValidate.getName()) && StringUtils.isBlank((String)itemToValidate.getValue())) {
                this.recErrorMsg("Please provide a value for " + this.getNameColumnTitleBinding().getString() + " or " + this.getValueColumnTitleBinding().getString() + ".");
                hasErrors = true;
            }
        } else {
            if (StringUtils.isBlank((String)itemToValidate.getName())) {
                this.recErrorMsg("Please provide a value for " + this.getNameColumnTitleBinding().getString() + ".");
                hasErrors = true;
            }
            if (StringUtils.isBlank((String)itemToValidate.getValue())) {
                this.recErrorMsg("Please provide a value for " + this.getValueColumnTitleBinding().getString() + ".");
                hasErrors = true;
            }
        }
        if (!hasErrors && !this.getAllowSameNameValue().booleanValue() && StringUtils.equals((String)(name = itemToValidate.getName()), (String)(value = itemToValidate.getValue()))) {
            this.recErrorMsg("The " + this.getNameColumnTitleBinding().getString() + " and " + this.getValueColumnTitleBinding().getString() + " values must be different.");
            hasErrors = true;
        }
        if (!hasErrors) {
            hasErrors = this.extraItemValidate(itemToValidate, originalItem);
        }
        return hasErrors;
    }

    protected void recErrorMsg(String message) {
        TaskletState.recordErrorMsg(message, (IValidationDelegate)this.getDelegate());
    }

    protected boolean extraItemValidate(NameValuePair itemToValidate, NameValuePair originalItem) {
        boolean hasError = false;
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof StringPairListEditorListener) {
            StringPairListEditorListener listener;
            String msg;
            String originalItemName = null;
            String originalItemValue = null;
            if (originalItem != null) {
                originalItemName = originalItem.getName();
                originalItemValue = originalItem.getValue();
            }
            if ((msg = (listener = (StringPairListEditorListener)o).validate(itemToValidate.getName(), itemToValidate.getValue(), originalItemName, originalItemValue, this.getList(), this)) != null) {
                this.recErrorMsg(msg);
                hasError = true;
            }
        }
        return hasError;
    }

    public void onUpdateItem(IRequestCycle cycle) {
        State s = this.getState();
        if (!this.validateUpdate(s.updateItem, s.editItem)) {
            this.doUpdate();
            this.saveState(s);
        }
    }

    protected boolean validateUpdate(NameValuePair itemToValidate, NameValuePair originalItem) {
        return this.basicItemValidate(itemToValidate, originalItem);
    }

    protected void doUpdate() {
        State state = this.getState();
        int idx = this.getList().indexOf(state.editItem);
        this.getList().set(idx, state.updateItem);
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof StringPairListEditorListener) {
            StringPairListEditorListener listener = (StringPairListEditorListener)o;
            listener.onUpdateListItem(this, state.editItem.getName(), state.updateItem.getName());
        }
        state.editItem = null;
        state.updateItem = null;
    }

    public void onEditItem(IRequestCycle cycle) {
        this.doEdit(cycle);
        this.saveState(this.getState());
    }

    protected void doEdit(IRequestCycle cycle) {
        State state = this.getState();
        NameValuePair pair = this.getRequestCycleItem(cycle);
        state.editItem = new NameValuePair(pair);
        state.updateItem = new NameValuePair(pair);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            NameValuePair pair = this.getRequestCycleItem(cycle);
            pair.setMarkedForDelete(true);
            Object o = this.getOwnerStateBinding().getObject();
            if (o instanceof StringPairListEditorListener) {
                StringPairListEditorListener listener = (StringPairListEditorListener)o;
                listener.onDeleteListItem(this, pair.getName());
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("string pair list editor");
        }
    }

    public void onUndeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            this.getRequestCycleItem(cycle).setMarkedForDelete(false);
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("string pair list editor");
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        this.doCancel();
        this.saveState(this.getState());
    }

    protected void doCancel() {
        State state = this.getState();
        state.updateItem = null;
        state.editItem = null;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            this.recErrorMsg("Please update or cancel the current item being edited.");
        }
        if (!this.getAllowEmpty().booleanValue() && this.getList().isEmpty()) {
            this.recErrorMsg("Please provide at least one " + this.getNameColumnTitleBinding().getString() + " and " + this.getValueColumnTitleBinding().getString());
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    protected NameValuePair getRequestCycleItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        int itemToDeleteIndex = (Integer)params[0];
        return this.getList().get(itemToDeleteIndex);
    }

    public static interface StringPairListEditorListener {
        public String validate(String var1, String var2, String var3, String var4, List<NameValuePair> var5, StringPairListEditor var6);

        public void onAddListItem(StringPairListEditor var1, String var2);

        public void onUpdateListItem(StringPairListEditor var1, String var2, String var3);

        public void onDeleteListItem(StringPairListEditor var1, String var2);
    }

    protected class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        NameValuePair updateItem;
        NameValuePair editItem;
        NameValuePair currentItem;
        NameValuePair newItem = new NameValuePair();

        protected State() {
        }

        public void clear() {
            this.updateItem = null;
            this.editItem = null;
            this.currentItem = null;
            this.newItem = new NameValuePair();
        }
    }
}

