/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class TableEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int index;
    private String deleteJsFunction;

    public abstract IBinding getListBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getOwnerStateBinding();

    public abstract IBinding getColumnDescriptorsBinding();

    public abstract IBinding getSearchableFilterListIndexBinding();

    public abstract IBinding getCheckboxListIndexBinding();

    public abstract IBinding getDefaultableBinding();

    public List<TableRow> getRowList() {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        rows.addAll(this.getList());
        return rows;
    }

    public List<TableRow> getList() {
        return (List)this.getListBinding().getObject("List", List.class);
    }

    public boolean isDefaultable() {
        if (this.getDefaultableBinding() == null) {
            return false;
        }
        return this.getDefaultableBinding().getBoolean();
    }

    public List<SimpleFieldDescriptor> getColumnDescriptors() {
        return (List)this.getColumnDescriptorsBinding().getObject("List", List.class);
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    protected void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    public State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new State();
            this.saveState(state);
        }
        return state;
    }

    public boolean isEditMode() {
        return this.getState().isEditMode();
    }

    public boolean isCurrentItemEditing() {
        State curState = this.getState();
        return curState.currentItem == curState.editItem;
    }

    public void setCurrentItem(TableRow currentItem) {
        State s = this.getState();
        s.currentItem = currentItem;
        this.saveState(s);
    }

    public TableRow getCurrentItem() {
        return this.getState().currentItem;
    }

    public TableRow getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(TableRow newItem) {
        State s = this.getState();
        s.newItem = newItem;
        this.saveState(s);
    }

    public TableRow getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(TableRow item) {
        State s = this.getState();
        s.editItem = item;
        this.saveState(s);
    }

    public TableRow getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(TableRow updateItem) {
        State s = this.getState();
        s.updateItem = updateItem;
        this.saveState(s);
    }

    public void onAddItem(IRequestCycle cycle) {
        State s = this.getState();
        if (this.isDefaultable() && (this.getList() == null || this.getList().size() == 0)) {
            s.newItem.setDefault(true);
        }
        if (!this.validateAdd(s.newItem, null)) {
            this.doAdd();
            this.saveState(s);
        }
    }

    protected boolean validateAdd(TableRow itemToValidate, TableRow originalItem) {
        return this.basicItemValidate(itemToValidate, originalItem);
    }

    protected void doAdd() {
        State state = this.getState();
        this.getList().add(state.newItem);
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onAddItem(this, state.newItem);
        }
        state.newItem = this.newTableRow();
    }

    protected TableRow newTableRow() {
        List<SimpleFieldDescriptor> descriptors = this.getColumnDescriptors();
        ArrayList<FieldItem> items = new ArrayList<FieldItem>();
        for (SimpleFieldDescriptor desc : descriptors) {
            FieldItem item = new FieldItem(desc, desc.getInitialValue());
            items.add(item);
        }
        TableRow newRow = new TableRow(items);
        newRow.setNewRow(true);
        return newRow;
    }

    protected void recErrorMsgs(List<String> messages) {
        for (String message : messages) {
            TaskletState.recordErrorMsg(message, (IValidationDelegate)this.getDelegate());
        }
    }

    private boolean basicItemValidate(TableRow itemToValidate, TableRow originalItem) {
        TableEditorListener listener;
        List<String> msgs;
        boolean hasError = false;
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener && (msgs = (listener = (TableEditorListener)o).validate(itemToValidate, originalItem, this.getList(), this)) != null) {
            this.recErrorMsgs(msgs);
            hasError = msgs.size() > 0;
        }
        return hasError;
    }

    public void onUpdateItem(IRequestCycle cycle) {
        State s = this.getState();
        if (!this.validateUpdate(s.updateItem, s.editItem)) {
            this.doUpdate();
            this.saveState(s);
        }
    }

    protected boolean validateUpdate(TableRow itemToValidate, TableRow originalItem) {
        return this.basicItemValidate(itemToValidate, originalItem);
    }

    protected void doUpdate() {
        State state = this.getState();
        int idx = this.getList().indexOf(state.editItem);
        this.getList().set(idx, state.updateItem);
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onUpdateItem(this, state.editItem, state.updateItem);
        }
        state.editItem = null;
        state.updateItem = null;
    }

    public void onTestExpressionItem(IRequestCycle cycle) {
        State state = this.getState();
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onTestExpressionItem(this, state.currentItem, state.updateItem);
        }
        if (state.updateItem == null) {
            this.onEditItem(cycle);
        }
    }

    public void onEditItem(IRequestCycle cycle) {
        this.doEdit(cycle);
        this.saveState(this.getState());
    }

    protected void doEdit(IRequestCycle cycle) {
        TableRow pair;
        State state = this.getState();
        state.editItem = pair = this.getRequestCycleItem(cycle);
        state.updateItem = new TableRow(pair);
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onEditItem(this, state.editItem, state.updateItem);
        }
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            TableRow row = this.getRequestCycleItem(cycle);
            if (StringUtils.isNotBlank((String)this.getDeleteJsFunction())) {
                this.getList().remove(row);
            } else {
                row.setMarkedForDelete(true);
            }
            Object o = this.getOwnerStateBinding().getObject();
            if (o instanceof TableEditorListener) {
                TableEditorListener listener = (TableEditorListener)o;
                listener.onDeleteItem(this, row);
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("table editor");
        }
    }

    public void onUndeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            this.getRequestCycleItem(cycle).setMarkedForDelete(false);
            Object o = this.getOwnerStateBinding().getObject();
            if (o instanceof TableEditorListener) {
                TableEditorListener listener = (TableEditorListener)o;
                listener.onUndeleteItem(this, this.getRequestCycleItem(cycle));
            }
        } else {
            this.auditLogUnauthorizedUserUndeleteAction("table editor");
        }
    }

    public boolean isEditable() {
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            return listener.isEditable();
        }
        return true;
    }

    public void onUpdateFieldStates(IRequestCycle cycle) {
        State state = this.getState();
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onUpdateState(this, state.editItem, state.updateItem);
        }
    }

    public void onUpdateNewItemFieldStates(IRequestCycle cycle) {
        State state = this.getState();
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onUpdateState(this, null, state.newItem);
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        this.doCancel();
        this.saveState(this.getState());
    }

    public void onChooseDefaultItem(IRequestCycle cycle) {
        Object o = this.getOwnerStateBinding().getObject();
        TableRow tableRow = this.getRequestCycleItem(cycle);
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onChooseDefaultItem(this, tableRow);
        }
    }

    protected void doCancel() {
        State state = this.getState();
        state.updateItem = null;
        state.editItem = null;
    }

    public boolean isNewRowEditable() {
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            return listener.isNewRowEditable(this);
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            this.recErrorMsgs(Arrays.asList("Please update or cancel the current item being edited."));
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private boolean allRowsDeleted(TableEditor owner) {
        if (owner == null || owner.getList() == null || owner.getList().size() == 0) {
            return true;
        }
        for (TableRow row : owner.getList()) {
            if (row.isMarkedForDelete()) continue;
            return false;
        }
        return true;
    }

    public TableRow getRequestCycleItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        int itemToDeleteIndex = (Integer)params[0];
        return this.getList().get(itemToDeleteIndex);
    }

    public String getNewItemDisplayName() {
        return this.getNewItem().getFields().get(this.getSearchFilterListIndex()).getDisplayName();
    }

    public void setNewItemDisplayName(String newItemDisplayName) {
        this.getNewItem().getFields().get(this.getSearchFilterListIndex()).setDisplayName(newItemDisplayName);
    }

    public String getNewItemTypeAndId() {
        return this.getNewItem().getFields().get(this.getSearchFilterListIndex()).getTypeAndId();
    }

    public void setNewItemTypeAndId(String newItemTypeAndId) {
        FieldItem fieldItem = this.getNewItem().getFields().get(this.getSearchFilterListIndex());
        fieldItem.setTypeAndId(newItemTypeAndId);
        String typeAndId = "";
        if (StringUtils.isNotEmpty((String)newItemTypeAndId)) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(newItemTypeAndId);
            typeAndId = option.getId();
        }
        fieldItem.setValue(typeAndId);
        this.onUpdateNewSearchFilterList(this.getNewItem());
    }

    public String getUpdateItemDisplayName() {
        TableRow tableRow = this.getUpdateItem();
        if (StringUtils.isEmpty((String)this.getUpdateItem().getFields().get(this.getSearchFilterListIndex()).getDisplayName())) {
            tableRow = this.getCurrentItem();
        }
        return tableRow.getFields().get(this.getSearchFilterListIndex()).getDisplayName();
    }

    public void setUpdateItemDisplayName(String newItemDisplayName) {
        this.getUpdateItem().getFields().get(this.getSearchFilterListIndex()).setDisplayName(newItemDisplayName);
    }

    public String getUpdateItemTypeAndId() {
        TableRow tableRow = this.getUpdateItem();
        if (StringUtils.isEmpty((String)this.getUpdateItem().getFields().get(this.getSearchFilterListIndex()).getTypeAndId())) {
            tableRow = this.getCurrentItem();
        }
        return tableRow.getFields().get(this.getSearchFilterListIndex()).getTypeAndId();
    }

    public void setUpdateItemTypeAndId(String updateItemTypeAndId) {
        FieldItem fieldItem = this.getUpdateItem().getFields().get(this.getSearchFilterListIndex());
        fieldItem.setTypeAndId(updateItemTypeAndId);
        String typeAndId = "";
        if (StringUtils.isNotEmpty((String)updateItemTypeAndId)) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(updateItemTypeAndId);
            typeAndId = option.getId();
        }
        this.getUpdateItem().getFields().get(this.getSearchFilterListIndex()).setValue(typeAndId);
        this.onUpdateSearchFilterList(this.getUpdateItem());
    }

    private void onUpdateSearchFilterList(TableRow updateRow) {
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onUpdateSearchFilterList(this, this.getEditItem(), updateRow);
        }
    }

    private void onUpdateNewSearchFilterList(TableRow updateRow) {
        Object o = this.getOwnerStateBinding().getObject();
        if (o instanceof TableEditorListener) {
            TableEditorListener listener = (TableEditorListener)o;
            listener.onUpdateSearchFilterList(this, null, updateRow);
        }
    }

    public Integer getSearchFilterListIndex() {
        return (Integer)this.getSearchableFilterListIndexBinding().getObject("searchableFilterListIndex", Integer.class);
    }

    public CheckboxModel getAddCheckboxModel() {
        return this.getNewItem().getFields().get(this.getCheckboxModelIndex()).getCheckboxModel();
    }

    public void setAddCheckboxModel(CheckboxModel checkboxModel) {
        this.getNewItem().getFields().get(this.getCheckboxModelIndex()).setCheckboxModel(checkboxModel);
    }

    public void setUpdateCheckboxModel(CheckboxModel checkboxModel) {
        this.getUpdateItem().getFields().get(this.getCheckboxModelIndex()).setCheckboxModel(checkboxModel);
    }

    public CheckboxModel getUpdateCheckboxModel() {
        return this.getUpdateItem().getFields().get(this.getCheckboxModelIndex()).getCheckboxModel();
    }

    public Integer getCheckboxModelIndex() {
        return (Integer)this.getCheckboxListIndexBinding().getObject("checkboxListIndex", Integer.class);
    }

    public void moveUp(IRequestCycle cycle) {
        TaskletState s = this.getCurrentState();
        if (s instanceof TableEditorRowOrdering) {
            TableEditorRowOrdering rowOrderingState = (TableEditorRowOrdering)((Object)s);
            Object[] params = cycle.getServiceParameters();
            Integer itemToMoveUp = (Integer)params[0];
            rowOrderingState.moveUp(itemToMoveUp);
        }
    }

    public void moveDown(IRequestCycle cycle) {
        TaskletState s = this.getCurrentState();
        if (s instanceof TableEditorRowOrdering) {
            TableEditorRowOrdering rowOrderingState = (TableEditorRowOrdering)((Object)s);
            Object[] params = cycle.getServiceParameters();
            Integer itemToMoveDown = (Integer)params[0];
            rowOrderingState.moveDown(itemToMoveDown);
        }
    }

    public boolean getShowRowOrderingColumn() {
        if (this.getList().size() > 1) {
            TaskletState s = this.getCurrentState();
            return s != null ? s instanceof TableEditorRowOrdering : false;
        }
        return false;
    }

    public boolean isNewConfig() {
        return this.getCurrentTasklet().getMode().equals((Object)Mode.create);
    }

    public String getDeleteJsFunction() {
        return this.deleteJsFunction;
    }

    public void setDeleteJsFunction(String function) {
        this.deleteJsFunction = function;
    }

    public void clearAllDefaults() {
        List<TableRow> rowList = this.getList();
        if (rowList != null) {
            for (TableRow row : rowList) {
                row.setDefault(false);
            }
        }
    }

    public static List<String> covertValidatorErrors(List<ValidationError> validationErrorList) {
        LinkedList<String> errorsList = new LinkedList<String>();
        if (validationErrorList != null) {
            for (ValidationError error : validationErrorList) {
                errorsList.add(error.getMessage());
            }
        }
        return errorsList;
    }

    public List<TableRow> getUnsavedRowList() {
        List<TableRow> returnList = this.getRowList();
        State state = this.getState();
        if (state.editItem != null) {
            int idx = this.getList().indexOf(state.editItem);
            returnList.set(idx, new TableRow(state.updateItem));
        } else {
            returnList.add(state.getNewItem());
        }
        return returnList;
    }

    public static interface TableEditorListener {
        default public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
            return new ArrayList<String>();
        }

        default public void onAddItem(TableEditor owner, TableRow newRow) {
            if (owner.isDefaultable() && (owner.getList() != null && owner.getList().size() == 1 || owner.allRowsDeleted(owner))) {
                newRow.setDefault(true);
            }
        }

        default public void onChooseDefaultItem(TableEditor owner, TableRow rowToSetAsDefault) {
            if (owner.isDefaultable()) {
                owner.clearAllDefaults();
                rowToSetAsDefault.setDefault(true);
            }
        }

        default public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        }

        default public void onEditItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        }

        default public void onDeleteItem(TableEditor owner, TableRow deletedRow) {
        }

        default public void onUndeleteItem(TableEditor owner, TableRow undeletedRow) {
        }

        default public void onTestExpressionItem(TableEditor owner, TableRow currentRow, TableRow updatedRow) {
        }

        default public boolean isEditable() {
            return true;
        }

        default public boolean isNewRowEditable(TableEditor owner) {
            return true;
        }

        default public void onUpdateSearchFilterList(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        }

        default public void onUpdateState(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        }
    }

    public static interface TableEditorRowOrdering {
        public void moveUp(int var1);

        public void moveDown(int var1);
    }

    public class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        TableRow updateItem;
        TableRow editItem;
        TableRow currentItem;
        TableRow newItem;

        public State() {
            this.newItem = TableEditor.this.newTableRow();
        }

        public TableRow getUpdateItem() {
            return this.updateItem;
        }

        public TableRow getNewItem() {
            return this.newItem;
        }

        public TableRow getEditItem() {
            return this.editItem;
        }

        public boolean isEditMode() {
            return this.editItem != null;
        }

        public void clear() {
            this.updateItem = null;
            this.editItem = null;
            this.currentItem = null;
            if (this.newItem != null) {
                for (FieldItem fieldItem : this.newItem.getFields()) {
                    String fieldInitValue = fieldItem.getDescriptor().getInitialValue();
                    fieldItem.setValue(fieldInitValue);
                }
            }
        }
    }
}

