/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.common;

import com.pingidentity.fsm.tasklet.TaskletCard;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.WhiteListUIEntry;

public abstract class WhiteListEditor
extends TaskletCard
implements Serializable {
    private static final long serialVersionUID = 20071029L;
    private boolean showMetadataUrlColumn = false;

    public abstract IBinding getListBinding();

    public abstract IBinding getStateBinding();

    public abstract IBinding getDelegateBinding();

    public abstract IBinding getAllowEmptyBinding();

    public Boolean getAllowEmpty() {
        IBinding binding = this.getAllowEmptyBinding();
        return binding.getBoolean();
    }

    public List<WhiteListUIEntry> getList() {
        return (List)this.getListBinding().getObject("List", List.class);
    }

    public List<WhiteListUIEntry> getListCopy() {
        List list = (List)this.getListBinding().getObject("List", List.class);
        List<WhiteListUIEntry> listCopy = list.stream().collect(Collectors.toList());
        return listCopy;
    }

    public ValidationDelegate getDelegate() {
        return (ValidationDelegate)this.getDelegateBinding().getObject("delegate", ValidationDelegate.class);
    }

    protected void saveState(WhiteListInternalState curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    protected WhiteListInternalState getState() {
        WhiteListInternalState state = (WhiteListInternalState)this.getStateBinding().getObject("state", Object.class);
        if (state == null) {
            state = new WhiteListInternalState();
            this.saveState(state);
            this.showMetadataUrlColumn = this.showMetadataUrlColumn();
        }
        return state;
    }

    public boolean isEditMode() {
        return this.getState().editItem != null;
    }

    public boolean isCurrentItemEditing() {
        WhiteListInternalState curState = this.getState();
        return curState.currentItem.equals((Object)curState.editItem);
    }

    public void setCurrentItem(WhiteListUIEntry currentItem) {
        WhiteListInternalState s = this.getState();
        s.currentItem = currentItem;
        this.saveState(s);
    }

    public WhiteListUIEntry getCurrentItem() {
        return this.getState().currentItem;
    }

    public WhiteListUIEntry getNewItem() {
        return this.getState().newItem;
    }

    public void setNewItem(WhiteListUIEntry newItem) {
        WhiteListInternalState s = this.getState();
        s.newItem = newItem;
        this.saveState(s);
    }

    public WhiteListUIEntry getEditItem() {
        return this.getState().editItem;
    }

    public void setEditItem(WhiteListUIEntry item) {
        WhiteListInternalState s = this.getState();
        s.editItem = item;
        this.saveState(s);
    }

    public WhiteListUIEntry getUpdateItem() {
        return this.getState().updateItem;
    }

    public void setUpdateItem(WhiteListUIEntry updateItem) {
        WhiteListInternalState s = this.getState();
        s.updateItem = updateItem;
        this.saveState(s);
    }

    public void onShowAdvanced(IRequestCycle cycle) {
        if (this.showMetadataUrlColumn && this.doesListContainMetadataUrl()) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Basic_view_error"), ValidationConstraint.REQUIRED);
        } else {
            this.showMetadataUrlColumn = !this.showMetadataUrlColumn;
        }
    }

    public void onAddItem(IRequestCycle cycle) {
        String metadataServiceUrl;
        boolean hasErrors = false;
        if (this.findByDomain(this.getState().newItem.getDomain().trim()) != null) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Already_contains_domain") + " " + this.getState().newItem.getDomain(), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (StringUtils.isBlank((String)this.getState().newItem.getDomain().trim())) {
            this.getDelegate().setFormComponent(null);
            this.getDelegate().record(this.getMessage("Domain_name_required"), ValidationConstraint.REQUIRED);
            hasErrors = true;
        }
        if (this.showMetadataUrlColumn() && !StringUtils.isBlank((String)(metadataServiceUrl = this.getState().newItem.getMetadataServiceUrl().trim()))) {
            if (this.findByMetadataServiceUrl(this.getState().newItem.getMetadataServiceUrl().trim()) != null) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Already_contains_url") + " " + this.getState().newItem.getMetadataServiceUrl().trim(), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (!ValidationUtil.isValidHttpOrHttpsUrl((String)metadataServiceUrl)) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Metadata_service_url_malformed"), ValidationConstraint.URL_FORMAT);
                hasErrors = true;
            }
        }
        if (!hasErrors) {
            WhiteListInternalState s = this.getState();
            WhiteListUIEntry newEntry = new WhiteListUIEntry();
            newEntry.setDomain(s.newItem.getDomain().trim());
            if (s.newItem.getMetadataServiceUrl() != null) {
                newEntry.setMetadataServiceUrl(s.newItem.getMetadataServiceUrl());
            }
            s.newItem = new WhiteListUIEntry();
            this.getList().add(newEntry);
            this.saveState(s);
        }
    }

    public void onUpdateItem(IRequestCycle cycle) {
        if (this.getState().updateItem.equals((Object)this.getState().editItem)) {
            this.getState().editItem = null;
            this.getState().updateItem = null;
        } else {
            String metadataServiceUrl;
            boolean hasErrors = false;
            if (!this.getState().updateItem.getDomain().trim().equals(this.getState().editItem.getDomain().trim()) && this.findByDomain(this.getState().updateItem.getDomain().trim()) != null) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Already_contains_domain") + " " + this.getState().updateItem.getDomain().trim(), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (StringUtils.isBlank((String)this.getState().updateItem.getDomain().trim())) {
                this.getDelegate().setFormComponent(null);
                this.getDelegate().record(this.getMessage("Domain_name_required"), ValidationConstraint.REQUIRED);
                hasErrors = true;
            }
            if (this.showMetadataUrlColumn() && !StringUtils.isBlank((String)(metadataServiceUrl = this.getState().updateItem.getMetadataServiceUrl().trim()))) {
                String editMetadataServiceUrl = this.getState().editItem.getMetadataServiceUrl();
                if (!metadataServiceUrl.equals(editMetadataServiceUrl) && this.findByMetadataServiceUrl(metadataServiceUrl) != null) {
                    this.getDelegate().setFormComponent(null);
                    this.getDelegate().record(this.getMessage("Already_contains_url") + " " + this.getState().updateItem.getMetadataServiceUrl().trim(), ValidationConstraint.REQUIRED);
                    hasErrors = true;
                }
                if (!ValidationUtil.isValidHttpOrHttpsUrl((String)metadataServiceUrl)) {
                    this.getDelegate().setFormComponent(null);
                    this.getDelegate().record(this.getMessage("Metadata_service_url_malformed"), ValidationConstraint.URL_FORMAT);
                    hasErrors = true;
                }
            }
            if (!hasErrors) {
                WhiteListInternalState s = this.getState();
                WhiteListUIEntry mapping = this.findByDomain(s.editItem.getDomain().trim());
                mapping.setDomain(s.updateItem.getDomain().trim());
                if (s.updateItem.getMetadataServiceUrl() != null) {
                    mapping.setMetadataServiceUrl(s.updateItem.getMetadataServiceUrl().trim());
                }
                this.getState().editItem = null;
                s.updateItem = null;
                this.saveState(s);
            }
        }
    }

    public void onEditItem(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        WhiteListInternalState curState = this.getState();
        String itemToEdit = (String)params[0];
        WhiteListUIEntry editItem = this.findByDomain(itemToEdit);
        curState.editItem = new WhiteListUIEntry(editItem);
        curState.updateItem = new WhiteListUIEntry(editItem);
        this.saveState(curState);
    }

    public void onDeleteItem(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String deleteItem = (String)params[0];
            this.getList().remove(this.findByDomain(deleteItem));
        } else {
            this.auditLogUnauthorizedUserDeleteAction("white list editor");
        }
    }

    public void cancelEdit(IRequestCycle cycle) {
        WhiteListInternalState curState = this.getState();
        curState.updateItem = null;
        curState.editItem = null;
        this.saveState(curState);
    }

    private WhiteListUIEntry findByDomain(String searchLocalName) {
        for (WhiteListUIEntry e : this.getList()) {
            if (!e.getDomain().equals(searchLocalName)) continue;
            return e;
        }
        return null;
    }

    private WhiteListUIEntry findByMetadataServiceUrl(String searchLocalName) {
        for (WhiteListUIEntry e : this.getList()) {
            if (e.getMetadataServiceUrl() == null || !e.getMetadataServiceUrl().equals(searchLocalName)) continue;
            return e;
        }
        return null;
    }

    public boolean showMetadataUrlColumn() {
        return this.doesListContainMetadataUrl() || this.showMetadataUrlColumn;
    }

    private boolean doesListContainMetadataUrl() {
        for (WhiteListUIEntry e : this.getList()) {
            if (StringUtils.isBlank((String)e.getMetadataServiceUrl())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate) {
        if (this.isEditMode()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Update_required"), ValidationConstraint.REQUIRED);
        }
    }

    private class WhiteListInternalState
    implements Serializable {
        private static final long serialVersionUID = 20071029L;
        WhiteListUIEntry updateItem;
        WhiteListUIEntry editItem;
        WhiteListUIEntry currentItem;
        WhiteListUIEntry newItem = new WhiteListUIEntry();

        private WhiteListInternalState() {
        }
    }
}

