/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorValidator;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AccessTokenManagementContractsToConnectionDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.AccessTokenManagementContractsToTokenMappingsDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.AccessTokenMappingToTeppDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.AuthnPolicyDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertiesAccessTokenMapDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertiesIdpConnDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertiesOidcPolicyMapDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertiesPluginToUserKeyAttrMapDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertiesSettingsApcToPersistentGrantMapDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertiesSettingsTeppToPersistentGrantMapDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertiesSpConnDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ExtendedPropertyToAuthnSelectorDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.FragmentDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.IdpAdapterAuthorizationServerSettingValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.IdpAdapterToConnectionDependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.IdpToSpAdapterMappingDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.OOBAuthenticatorDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.PCVToOAuthROCredMappingsDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.PluginDependencyValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.ProtocolSettingsDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.SpAdapterToConnectionDependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.StsRequestContractsToConnectionDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.TeppToTokenProcessorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.TokenGeneratorMappingToTeppDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.TokenGeneratorsToConnectionsDepErrorValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.TokenGeneratorsToTokenTranslatorMappingsValidatorImpl;
import com.pingidentity.dependency.error.validator.impl.TokenProcessorPolicyDepErrorValidator;
import com.pingidentity.dependency.error.validator.impl.TokenProcessorsToConnectionsDepErrorValidatorImpl;
import com.pingidentity.fsm.state.impl.Apc2SpAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.AuthnAdapterInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.a2a.domain.mgmt.Apc2SpAdapterManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdentityStoreProvisionerInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.C2CMappingDb;
import org.sourceid.saml20.metadata.partner.C2CMappingDbEntryResult;

public class DependencyErrorUIValidatorImpl
implements DependencyErrorUIValidator {
    private final Logger log = Logger.getLogger(this.getClass());
    private final Map<DependencyType, List<DependencyErrorValidator>> validatorsByType = new HashMap<DependencyType, List<DependencyErrorValidator>>();
    private final Tasklet tasklet;
    private final DependencyErrorManager dependencyErrorManager;
    private final AuthzServerManager authzServerManager;
    private final ClientSettingManager clientSettingManager;
    private final ConnectionManager connectionManager;
    private final Collection<DependencyError> errors;
    private final AdministrativeUser administrativeUser;
    private final LocalSettingsManager localSettingsManager;
    private final Apc2SpAdapterManager apc2SpaMgr;
    private final C2CMappingDb c2CMappingDb;
    private final IdpAdapterManager idpAdapterManager;

    public DependencyErrorUIValidatorImpl(Tasklet currentTasklet) {
        this(currentTasklet, MgmtFactory.getAuthzServerManager(), MgmtFactory.getClientSettingManager(), MgmtFactory.getConnectionManager(), MgmtFactory.getDependencyErrorManager(), MgmtFactory.getLocalSettingsManager(), MgmtFactory.getApc2SpAdapterManager(), MgmtFactory.getC2CMappingDb(), MgmtFactory.getIdpAdapterManager());
    }

    public DependencyErrorUIValidatorImpl(Tasklet currentTasklet, AuthzServerManager authzServerManager, ClientSettingManager clientSettingManager, ConnectionManager connectionManager, DependencyErrorManager dependencyErrorManager, LocalSettingsManager localSettingsManager, Apc2SpAdapterManager apc2SpaMgr, C2CMappingDb c2CMappingDb, IdpAdapterManager idpAdapterManager) {
        this.authzServerManager = authzServerManager;
        this.clientSettingManager = clientSettingManager;
        this.connectionManager = connectionManager;
        this.administrativeUser = currentTasklet.getCurrentUser();
        this.dependencyErrorManager = dependencyErrorManager;
        this.errors = new ArrayList<DependencyError>(dependencyErrorManager.getErrors());
        this.tasklet = currentTasklet;
        this.localSettingsManager = localSettingsManager;
        this.apc2SpaMgr = apc2SpaMgr;
        this.c2CMappingDb = c2CMappingDb;
        this.idpAdapterManager = idpAdapterManager;
        this.initialize();
    }

    private void initialize() {
        this.registerValidator(DependencyType.AUTHN_POLICY_ATTRS, new AuthnPolicyDepErrorValidatorImpl(this));
        this.registerValidator(DependencyType.FRAGMENT_ATTRS, new FragmentDepErrorValidatorImpl(this));
        this.registerValidator(DependencyType.IDP_ADAPTER, new IdpAdapterToConnectionDependencyErrorValidatorImpl());
        this.registerValidator(DependencyType.IDP_ADAPTER, new IdpToSpAdapterMappingDepErrorValidatorImpl());
        this.registerValidator(DependencyType.IDP_ADAPTER, new IdpAdapterAuthorizationServerSettingValidatorImpl());
        this.registerValidator(DependencyType.IDP_ADAPTER, new FragmentDepErrorValidatorImpl(this));
        this.registerValidator(DependencyType.IDP_ADAPTER, new AuthnPolicyDepErrorValidatorImpl(this));
        this.registerValidator(DependencyType.IDP_ADAPTER, this.createPluginContractMappingDependencyValidator());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertiesIdpConnDepErrorValidatorImpl());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertiesOidcPolicyMapDepErrorValidatorImpl());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertiesAccessTokenMapDepErrorValidatorImpl());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertiesPluginToUserKeyAttrMapDepErrorValidatorImpl());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertiesSettingsApcToPersistentGrantMapDepErrorValidatorImpl());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertiesSettingsTeppToPersistentGrantMapDepErrorValidatorImpl(this.authzServerManager, this.clientSettingManager));
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertiesSpConnDepErrorValidatorImpl(this.connectionManager));
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, this.createPluginContractMappingDependencyValidator());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new ExtendedPropertyToAuthnSelectorDepErrorValidatorImpl());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new AuthnPolicyDepErrorValidatorImpl(this));
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new FragmentDepErrorValidatorImpl(this));
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new TokenGeneratorMappingToTeppDepErrorValidatorImpl());
        this.registerValidator(DependencyType.OAUTH_CLIENT_SETTINGS, new TokenProcessorPolicyDepErrorValidator());
        this.registerValidator(DependencyType.OOB_AUTH_PLUGIN, new OOBAuthenticatorDepErrorValidatorImpl(this));
        this.registerValidator(DependencyType.PCV, new PCVToOAuthROCredMappingsDepErrorValidatorImpl());
        this.registerValidator(DependencyType.PROTOCOL_SETTINGS, new ProtocolSettingsDepErrorValidatorImpl());
        this.registerValidator(DependencyType.SP_ADAPTER, new SpAdapterToConnectionDependencyErrorValidatorImpl());
        this.registerValidator(DependencyType.SP_ADAPTER, new IdpToSpAdapterMappingDepErrorValidatorImpl());
        this.registerValidator(DependencyType.STS, new StsRequestContractsToConnectionDepErrorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY, new AccessTokenMappingToTeppDepErrorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY, new TokenGeneratorMappingToTeppDepErrorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_GENERATOR, new TokenGeneratorsToTokenTranslatorMappingsValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_GENERATOR, new TokenGeneratorMappingToTeppDepErrorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_GENERATOR, new ProtocolSettingsDepErrorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_GENERATOR, new TokenGeneratorsToConnectionsDepErrorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_PROCESSOR, new TokenProcessorsToConnectionsDepErrorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_PROCESSOR, new TokenGeneratorsToTokenTranslatorMappingsValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_PROCESSOR, new TeppToTokenProcessorValidatorImpl());
        this.registerValidator(DependencyType.TOKEN_PROCESSOR, new ProtocolSettingsDepErrorValidatorImpl());
        this.registerValidator(DependencyType.ACCESS_TOKEN_MANAGEMENT_ATTRS, new AccessTokenManagementContractsToConnectionDepErrorValidatorImpl());
        this.registerValidator(DependencyType.ACCESS_TOKEN_MANAGEMENT_ATTRS, new AccessTokenManagementContractsToTokenMappingsDepErrorValidatorImpl());
    }

    @Override
    public synchronized void obtainNewDependencyErrors(Object causedByItem, DependencyType dependencyType) {
        List<DependencyErrorValidator> registeredValidators = this.validatorsByType.get(dependencyType);
        if (registeredValidators != null) {
            this.validate(registeredValidators, causedByItem);
        }
        switch (dependencyType) {
            case c2c: {
                C2cContract c2cContract = (C2cContract)causedByItem;
                if (!this.localSettingsManager.getLocalSettings().isDisableAutomaticConnectionValidation()) {
                    this.obtainInvalidIdpConnectionIds(c2cContract);
                    this.obtainInvalidSpConnectionIds(c2cContract);
                }
                this.obtainInvalidApc2SpaMappings(c2cContract);
                break;
            }
            case SCOPE_MANAGEMENT: {
                HashSet<String> allScopeAndGroups = new HashSet<String>();
                allScopeAndGroups.addAll(ScopeUtil.getScopeAndGroupNames());
                allScopeAndGroups.addAll(ScopeUtil.getExclusiveScopeAndGroupNames());
                this.checkOAuthGrantManagementDep(allScopeAndGroups);
                break;
            }
            case IDP_CONN_METADATA: {
                IdpConnection idpConnection = (IdpConnection)causedByItem;
                ValidationDelegate delegate = this.validateIdpConnection(idpConnection);
                AffectedItemType connectionType = AffectedItemType.IDP_CONN;
                String affectedItemId = idpConnection.getId();
                this.updateDependencyError(affectedItemId, affectedItemId, delegate.getHasErrors(), connectionType, dependencyType);
                break;
            }
            case SP_CONN_METADATA: {
                SpConnection spConnection = (SpConnection)causedByItem;
                ValidationDelegate delegate = this.validateSpConnection(spConnection);
                AffectedItemType connectionType = AffectedItemType.SP_CONN;
                String affectedItemId = spConnection.getId();
                this.updateDependencyError(affectedItemId, affectedItemId, delegate.getHasErrors(), connectionType, dependencyType);
                break;
            }
            case IDENTITY_STORE_PROVISIONER: {
                this.validateInboundProvisioningConnections((IdentityStoreProvisionerInstance)causedByItem);
                break;
            }
        }
        this.dependencyErrorManager.setErrors(this.errors);
    }

    private void checkOAuthGrantManagementDep(Set<String> allScopeAndGroups) {
        boolean hasError = false;
        String atmIdForOAuthGrantManagement = this.authzServerManager.getAtmIdForOAuthGrantManagement();
        String scopeForOAuthGrantManagement = this.authzServerManager.getScopeForOAuthGrantManagement();
        if (StringUtils.isNotBlank((String)atmIdForOAuthGrantManagement) && StringUtils.isNotBlank((String)scopeForOAuthGrantManagement) && !allScopeAndGroups.contains(scopeForOAuthGrantManagement)) {
            hasError = true;
        }
        this.updateDependencyError(AffectedItemType.AUTH_SERVER_SETTINGS.getFriendlyName(), AffectedItemType.AUTH_SERVER_SETTINGS.getFriendlyName(), hasError, AffectedItemType.AUTH_SERVER_SETTINGS, DependencyType.SCOPE_MANAGEMENT);
    }

    private void validateInboundProvisioningConnections(IdentityStoreProvisionerInstance causedByItem) {
        for (IdpConnection idpConnection : this.connectionManager.getAllIdpConnections()) {
            if (idpConnection.getInboundProvisioning() == null || idpConnection.getInboundProvisioning().getIdentityStoreProvisioner() == null || !idpConnection.getInboundProvisioning().getIdentityStoreProvisionerId().equals(causedByItem.getId())) continue;
            ValidationDelegate delegate = this.validateIdpConnection(idpConnection);
            DependencyError error = new DependencyError(idpConnection.getId(), DependencyType.IDENTITY_STORE_PROVISIONER, causedByItem.getId(), AffectedItemType.IDP_CONN);
            if (delegate.getHasErrors()) {
                if (this.errors.contains(error)) continue;
                this.errors.add(error);
                continue;
            }
            this.errors.removeIf(dependencyError -> dependencyError.equals((Object)error));
        }
    }

    private void validate(List<DependencyErrorValidator> validators, Object causedByItem) {
        if (validators != null) {
            for (DependencyErrorValidator validator : validators) {
                if (this.localSettingsManager.getLocalSettings().isDisableAutomaticConnectionValidation() && validator.requiresConnectionValidation()) continue;
                validator.setCurrentUser(this.administrativeUser);
                validator.getDependencyErrors(causedByItem, this.errors);
            }
        }
    }

    private void registerValidator(DependencyType dependencyType, DependencyErrorValidator validator) {
        List<DependencyErrorValidator> validators = this.validatorsByType.get(dependencyType);
        if (validators == null) {
            validators = new ArrayList<DependencyErrorValidator>();
        }
        validators.add(validator);
        this.validatorsByType.put(dependencyType, validators);
    }

    private void obtainInvalidApc2SpaMappings(C2cContract c2cContract) {
        for (Direct2SpAdapterMapping apc2SpaMapping : this.apc2SpaMgr.getMappingsUsingSource(c2cContract.getId())) {
            String mappingId = DependencyErrorHandler.buildMappingId((Source2TargetMapping)apc2SpaMapping);
            ValidationDelegate delegate = new ValidationDelegate();
            Apc2SpAdapterMappingTasklet t = this.tasklet.createTaskletToLoad(Apc2SpAdapterMappingTasklet.class);
            t.populate(apc2SpaMapping);
            t.appendErrors((IValidationDelegate)delegate, null, false);
            this.updateDependencyError(c2cContract.getId(), mappingId, delegate.getHasErrors(), AffectedItemType.APC2SPA, DependencyType.c2c);
        }
    }

    private void obtainInvalidIdpConnectionIds(C2cContract contract) {
        Collection results = this.c2CMappingDb.getEntriesByContractId(contract.getId());
        for (C2CMappingDbEntryResult result : results) {
            IdpConnection conn;
            if (!result.getConnType().equals((Object)Role.IDP) || (conn = this.connectionManager.getIdpConnection(result.getEntityId())) == null) continue;
            ValidationDelegate delegate = this.validateIdpConnection(conn);
            this.updateDependencyError(contract.getId(), conn.getId(), delegate.getHasErrors(), AffectedItemType.IDP_CONN, DependencyType.c2c);
        }
    }

    private ValidationDelegate validateIdpConnection(IdpConnection idpConnection) {
        ValidationDelegate delegate = new ValidationDelegate();
        IdpConnectionConfigTasklet idpConnConfigTasklet = this.tasklet.createTaskletToLoad(IdpConnectionConfigTasklet.class);
        idpConnConfigTasklet.setParentTasklet(null);
        idpConnConfigTasklet.setIdpConnection(idpConnection);
        idpConnConfigTasklet.setMode(Mode.edit);
        idpConnConfigTasklet.populate(idpConnection);
        idpConnConfigTasklet.appendErrors((IValidationDelegate)delegate, null, false);
        return delegate;
    }

    private void obtainInvalidSpConnectionIds(C2cContract contract) {
        Collection results = this.c2CMappingDb.getEntriesByContractId(contract.getId());
        for (C2CMappingDbEntryResult result : results) {
            SpConnection conn;
            if (!result.getConnType().equals((Object)Role.SP) || (conn = this.connectionManager.getSpConnection(result.getEntityId())) == null) continue;
            ValidationDelegate delegate = this.validateSpConnection(conn);
            this.updateDependencyError(contract.getId(), conn.getId(), delegate.getHasErrors(), AffectedItemType.SP_CONN, DependencyType.c2c);
        }
    }

    private ValidationDelegate validateSpConnection(SpConnection spConnection) {
        SpConnectionConfigTasklet spConnConfigTasklet = this.tasklet.createTaskletToLoad(SpConnectionConfigTasklet.class);
        spConnConfigTasklet.setParentTasklet(null);
        spConnConfigTasklet.setSpConnection(spConnection);
        spConnConfigTasklet.setMode(Mode.edit);
        ValidationDelegate delegate = new ValidationDelegate();
        spConnConfigTasklet.populate(spConnection);
        spConnConfigTasklet.appendErrors((IValidationDelegate)delegate, null, false);
        return delegate;
    }

    private synchronized void removeError(String affectedItemID, AffectedItemType affectedItemType) {
        this.log.debug((Object)"Removing a dependency error ...");
        this.errors.removeIf(error -> error.getAffectedInstanceId().equals(affectedItemID) && error.getAffectedInstanceType().equals((Object)affectedItemType));
    }

    public synchronized void updateDependencyError(String causedByInstanceId, String affectedItemId, boolean affectedItemHasError, AffectedItemType affectedItemType, DependencyType causedByType) {
        DependencyError dependencyError = new DependencyError(affectedItemId, causedByType, causedByInstanceId, affectedItemType);
        if (affectedItemHasError && !this.errors.contains(dependencyError)) {
            this.errors.add(dependencyError);
        } else if (!affectedItemHasError && this.errors.contains(dependencyError)) {
            this.removeError(affectedItemId, affectedItemType);
        }
    }

    public Tasklet getTasklet() {
        return this.tasklet;
    }

    private DependencyErrorValidator createPluginContractMappingDependencyValidator() {
        return new PluginDependencyValidatorImpl(this, (PluginManager<? extends PluginDescriptor, ? extends ConfigurablePluginInstance>)this.idpAdapterManager, AuthnAdapterInstanceTasklet.class, PluginManagementSupport.PluginManagementType.IDP_ADAPTER, DependencyType.IDP_ADAPTER, AffectedItemType.IDP_ADAPTER);
    }
}

