/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.IdpOAuthGrantAttributeMapping;
import com.pingidentity.admin.api.validator.AccessTokenManagerMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.IdpAccessTokenMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.IdpConnectionOAuthAttributeContractTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AccessTokenManagementContractsToConnectionDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        BearerAccessTokenMgmtPluginInstance atm = (BearerAccessTokenMgmtPluginInstance)causedByItem;
        for (org.sourceid.saml20.domain.IdpConnection idpConnection : connectionManager.getAllIdpConnections()) {
            if (idpConnection.getOAuthSettings() == null || idpConnection.getOAuthSettings().getOAuthAssertionGrantMappingByTokenManagerId(atm.getId()) == null) continue;
            IdpConnection apiConn = new IdpConnection();
            IdpOAuthGrantAttributeMapping apiContract = new IdpOAuthGrantAttributeMapping();
            apiConn.setIdpOAuthGrantAttributeMapping(apiContract);
            IdpConnectionOAuthAttributeContractTranslator acTranslator = new IdpConnectionOAuthAttributeContractTranslator();
            acTranslator.domainToApi(idpConnection, apiConn);
            new IdpAccessTokenMappingTranslator().domainToApi(idpConnection, apiConn);
            AccessTokenManagerMappingValidator validator = new AccessTokenManagerMappingValidator(apiConn.getIdpOAuthGrantAttributeMapping(), new ValidatorContext());
            DependencyError error = new DependencyError(idpConnection.getId(), DependencyType.ACCESS_TOKEN_MANAGEMENT_ATTRS, atm.getId(), AffectedItemType.IDP_CONN);
            if (validator.validate()) {
                existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                continue;
            }
            if (existingErrors.contains(error)) continue;
            existingErrors.add(error);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }
}

