/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.oauth.AccessTokenMapping;
import com.pingidentity.admin.api.model.oauth.AccessTokenMappingType;
import com.pingidentity.admin.api.validator.AccessTokenMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.oauth.ClientCredentialToAccessTokenMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.oauth.UserKeyToAccessTokenMappingTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AccessTokenManagementContractsToTokenMappingsDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        BearerAccessTokenMgmtPluginInstance atm = (BearerAccessTokenMgmtPluginInstance)causedByItem;
        List accessTokenMappings = authzServerManager.getAccessTokenMappings().stream().filter(mapping -> mapping.getTokenManagerId().equals(atm.getId())).collect(Collectors.toList());
        if (!accessTokenMappings.isEmpty()) {
            for (org.sourceid.oauth20.domain.AccessTokenMapping accessTokenMapping : accessTokenMappings) {
                AccessTokenMapping apiAccessTokenMapping;
                ClientCredentialToAccessTokenMappingTranslator translator;
                if (AccessTokenMappingType.CLIENT_CREDENTIALS.equals((Object)AccessTokenMappingType.fromContextId((String)accessTokenMapping.getContextId()))) {
                    translator = new ClientCredentialToAccessTokenMappingTranslator();
                    apiAccessTokenMapping = translator.domainToApi((ClientCredentialAccessTokenMapping)accessTokenMapping);
                } else {
                    translator = new UserKeyToAccessTokenMappingTranslator();
                    apiAccessTokenMapping = translator.domainToApi((UserKeyToAccessTokenMapping)accessTokenMapping);
                }
                AccessTokenMappingValidator validator = new AccessTokenMappingValidator(apiAccessTokenMapping, new ValidatorContext(true, this.isEaAdmin(), true));
                DependencyError error = new DependencyError(accessTokenMapping.getId(), DependencyType.ACCESS_TOKEN_MANAGEMENT_ATTRS, atm.getId(), AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING);
                if (validator.validate()) {
                    existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                    continue;
                }
                if (existingErrors.contains(error)) continue;
                existingErrors.add(error);
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

