/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.oauth.AccessTokenMapping;
import com.pingidentity.admin.api.validator.AccessTokenMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.oauth.UserKeyToAccessTokenMappingTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.oauth20.handlers.ContextUtil;
import org.sourceid.oauth20.handlers.OAuthSourceId;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AccessTokenMappingToTeppDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private static final TokenExchangeProcessorPolicyManager teppManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private static final ContextUtil cxtUtil = new ContextUtil();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        TokenExchangeProcessorPolicy policy;
        String teppId;
        String contextId;
        Collection mappings;
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.TEPP, DependencyType.OAUTH_CLIENT_SETTINGS);
        if (causedByItem instanceof TokenExchangeProcessorPolicy && (mappings = authzServerManager.getUserKeyToAccessTokenMappingsForContext(contextId = cxtUtil.buildQualifiedId("urn:ietf:params:oauth:grant-type:token-exchange", new OAuthSourceId(OAuthSourceId.Type.TOKEN_EXCHANGE_PROCESSOR_POLICY, teppId = (policy = (TokenExchangeProcessorPolicy)causedByItem).getId())))) != null) {
            for (UserKeyToAccessTokenMapping mapping : mappings) {
                UserKeyToAccessTokenMappingTranslator translator = new UserKeyToAccessTokenMappingTranslator();
                AccessTokenMapping apiMapping = translator.domainToApi(mapping);
                AccessTokenMappingValidator validator = new AccessTokenMappingValidator(apiMapping, new ValidatorContext(true, this.isEaAdmin(), true));
                boolean validAttribute = validator.validate();
                DependencyError error = new DependencyError(mapping.getId(), DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY, teppId, AffectedItemType.OAUTH_ACCESS_TOKEN_MAPPING);
                this.updateErrors(existingErrors, validAttribute, error);
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

