/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.OAuthSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertiesIdpConnDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private static final ClientSettingManager clientSettingMgr = MgmtFactory.getClientSettingManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof IdpConnection) {
            ClientSetting clientSetting = clientSettingMgr.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            IdpConnection idpConnection = (IdpConnection)causedByItem;
            AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.IDP_CONN, idpConnection.getId(), DependencyType.OAUTH_CLIENT_SETTINGS);
            this.checkIdPConnectionExtendedMetadataDependency(existingErrors, extendedClientMetadataSet, idpConnection);
        } else if (causedByItem instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)causedByItem;
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkIdPConnectionExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }

    private void checkIdPConnectionExtendedMetadataDependency(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet) {
        Collection idpConnections = connectionManager.getAllIdpConnections();
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.IDP_CONN, DependencyType.OAUTH_CLIENT_SETTINGS);
        if (idpConnections != null) {
            for (IdpConnection idpConnection : idpConnections) {
                this.checkIdPConnectionExtendedMetadataDependency(existingErrors, extendedClientMetadataSet, idpConnection);
            }
        }
    }

    private void checkIdPConnectionExtendedMetadataDependency(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, IdpConnection idpConnection) {
        OAuthSettings oAuthSettings;
        UserKeyAttrMapping ssoToOAuthAttrMapping = idpConnection.getSsoToOAuthAttrMapping();
        if (ssoToOAuthAttrMapping != null) {
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, ssoToOAuthAttrMapping.getAttributeMapping(), AffectedItemType.IDP_CONN, idpConnection.getId())) {
                return;
            }
            if (AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, ssoToOAuthAttrMapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.IDP_CONN, idpConnection.getId())) {
                return;
            }
        }
        if ((oAuthSettings = idpConnection.getOAuthSettings()) != null) {
            List oAuthAssertionGrantMappingList = oAuthSettings.getOAuthAssertionGrantMappingList();
            for (OAuthAssertionGrantMapping oAuthAssertionGrantMapping : oAuthAssertionGrantMappingList) {
                if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, oAuthAssertionGrantMapping.getAttributeMapping(), AffectedItemType.IDP_CONN, idpConnection.getId())) {
                    return;
                }
                if (!AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, oAuthAssertionGrantMapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.IDP_CONN, idpConnection.getId())) continue;
                return;
            }
        }
        Collection targetAttributeMappings = idpConnection.getTargetAttributeMappings();
        for (Object targetAttributeMapping : targetAttributeMappings) {
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, targetAttributeMapping.getAttributeMapping(), AffectedItemType.IDP_CONN, idpConnection.getId())) {
                return;
            }
            if (!AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, targetAttributeMapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.IDP_CONN, idpConnection.getId())) continue;
            return;
        }
        Collection c2cContractMappings = idpConnection.getC2cContractMappings();
        for (C2cContractAttributeMapping c2cContractMapping : c2cContractMappings) {
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, c2cContractMapping.getAttributeMapping(), AffectedItemType.IDP_CONN, idpConnection.getId())) {
                return;
            }
            if (!AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, c2cContractMapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.IDP_CONN, idpConnection.getId())) continue;
            return;
        }
        WsTrustFederatedWspSettings wsTrustSettings = idpConnection.getWsTrustSettings();
        if (wsTrustSettings != null) {
            wsTrustSettings.getAssertionToTokenMappingsMappings().forEach(tokenMapping -> {
                if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, tokenMapping.getAttributeMapping().getAttributeMapping(), AffectedItemType.IDP_CONN, idpConnection.getId())) {
                    return;
                }
                if (AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, tokenMapping.getAttributeMapping().getTokenAuthorizationIssuanceCriteria(), AffectedItemType.IDP_CONN, idpConnection.getId())) {
                    return;
                }
            });
        }
    }
}

