/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrMapping;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertiesOidcPolicyMapDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ClientSettingManager clientSettingMgr = MgmtFactory.getClientSettingManager();
    private static final OpenIdConnectProviderPolicyManager oidcProviderPolicyManager = MgmtFactory.getOIDCProviderPolicyManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof OpenIdConnectProviderPolicy) {
            OpenIdConnectProviderPolicy openIdConnectProviderPolicy = (OpenIdConnectProviderPolicy)causedByItem;
            ClientSetting clientSetting = clientSettingMgr.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, openIdConnectProviderPolicy);
        } else if (causedByItem instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)causedByItem;
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkOidcPolicyMappingsExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }

    private void checkOidcPolicyMappingsExtendedMetadataDependency(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet) {
        OpenIdConnectProviderPolicy policy = oidcProviderPolicyManager.getPolicy();
        if (policy != null) {
            this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, policy);
        }
    }

    private void checkMappingDependencyOnExtendedMetadata(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, OpenIdConnectProviderPolicy policy) {
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policy.getPolicyGroups().values()) {
            UserInfoAttrMapping userInfoAttrMapping = policyGroup.getUserInfoAttributeMapping();
            AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.OIDC_POLICY_MANAGEMENT, policyGroup.getPolicyId(), DependencyType.OAUTH_CLIENT_SETTINGS);
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, userInfoAttrMapping.getAttributeMapping(), AffectedItemType.OIDC_POLICY_MANAGEMENT, policyGroup.getPolicyId())) {
                return;
            }
            if (!AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, userInfoAttrMapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.OIDC_POLICY_MANAGEMENT, policyGroup.getPolicyId())) continue;
            return;
        }
    }
}

