/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertiesPluginToUserKeyAttrMapDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();
    private static final ClientSettingManager clientSettingMgr = MgmtFactory.getClientSettingManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)causedByItem;
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkPluginToUserKeyAttrMappingExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        } else if (causedByItem instanceof PluginToUserKeyAttrMapping) {
            ClientSetting clientSetting = clientSettingMgr.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkPluginToUserKeyAttrMappingExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        } else if (causedByItem instanceof Collection && ((Collection)causedByItem).iterator().hasNext() && ((Collection)causedByItem).iterator().next() instanceof PluginToUserKeyAttrMapping) {
            ClientSetting clientSetting = clientSettingMgr.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkPluginToUserKeyAttrMappingExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }

    private void checkPluginToUserKeyAttrMappingExtendedMetadataDependency(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet) {
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.OAUTH_IDP_ADAPTER_MAPPING, DependencyType.OAUTH_CLIENT_SETTINGS);
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING, DependencyType.OAUTH_CLIENT_SETTINGS);
        this.checkMappingsDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, AffectedItemType.OAUTH_IDP_ADAPTER_MAPPING, authzServerMgr.getAdapterToUserKeyMappings());
        this.checkMappingsDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, AffectedItemType.OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING, authzServerMgr.getPwdCredValidatorToUserKeyMappings());
    }

    private void checkMappingsDependencyOnExtendedMetadata(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, AffectedItemType affectedItemType, Collection<PluginToUserKeyAttrMapping> pluginToUserKeyMappings) {
        if (pluginToUserKeyMappings != null) {
            for (PluginToUserKeyAttrMapping mapping : pluginToUserKeyMappings) {
                this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, affectedItemType, mapping);
            }
        }
    }

    private void checkMappingDependencyOnExtendedMetadata(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, AffectedItemType affectedItemType, PluginToUserKeyAttrMapping mapping) {
        if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, mapping.getAttributeMapping(), affectedItemType, mapping.getSourceId())) {
            return;
        }
        AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, mapping.getTokenAuthorizationIssuanceCriteria(), affectedItemType, mapping.getSourceId());
    }
}

