/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.TeppToUserKeyAttrMapping;

public class ExtendedPropertiesSettingsTeppToPersistentGrantMapDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private final AuthzServerManager authzServerManager;
    private final ClientSettingManager clientSettingManager;

    public ExtendedPropertiesSettingsTeppToPersistentGrantMapDepErrorValidatorImpl(AuthzServerManager authzServerMgr, ClientSettingManager clientSettingMgr) {
        this.authzServerManager = authzServerMgr;
        this.clientSettingManager = clientSettingMgr;
    }

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof TeppToUserKeyAttrMapping) {
            ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            TeppToUserKeyAttrMapping teppToUserKeyAttrMapping = (TeppToUserKeyAttrMapping)causedByItem;
            AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.TEPP_TO_PERSISTENT_GRANT_MAPPING, teppToUserKeyAttrMapping.getSourceId(), DependencyType.OAUTH_CLIENT_SETTINGS);
            this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, teppToUserKeyAttrMapping);
        } else if (causedByItem instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)causedByItem;
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkOAuthTeppExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        } else if (causedByItem instanceof Collection && ((Collection)causedByItem).iterator().hasNext() && ((Collection)causedByItem).iterator().next() instanceof TeppToUserKeyAttrMapping) {
            ClientSetting clientSetting = this.clientSettingManager.getClientSetting();
            Set<String> extendedClientMetadataSet = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
            this.checkOAuthTeppExtendedMetadataDependency(existingErrors, extendedClientMetadataSet);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }

    void checkOAuthTeppExtendedMetadataDependency(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet) {
        Collection collectionOfMappings = this.authzServerManager.getTeppToUserKeyMappings();
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.TEPP_TO_PERSISTENT_GRANT_MAPPING, DependencyType.OAUTH_CLIENT_SETTINGS);
        if (collectionOfMappings != null) {
            for (TeppToUserKeyAttrMapping mapping : collectionOfMappings) {
                this.checkMappingDependencyOnExtendedMetadata(existingErrors, extendedClientMetadataSet, mapping);
            }
        }
    }

    private void checkMappingDependencyOnExtendedMetadata(Collection<DependencyError> existingErrors, Set<String> extendedClientMetadataSet, TeppToUserKeyAttrMapping mapping) {
        if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedClientMetadataSet, mapping.getAttributeMapping(), AffectedItemType.TEPP_TO_PERSISTENT_GRANT_MAPPING, mapping.getSourceId())) {
            return;
        }
        AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedClientMetadataSet, mapping.getTokenAuthorizationIssuanceCriteria(), AffectedItemType.TEPP_TO_PERSISTENT_GRANT_MAPPING, mapping.getSourceId());
    }
}

