/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ExtendedPropertyToAuthnSelectorDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final AuthnSelectorManager authnSelectorManager = MgmtFactory.getAuthnSelectorManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)causedByItem;
            Set extendedParamNames = clientSetting.getExtendedMetadataParams().keySet();
            Collection selectors = authnSelectorManager.getInstances();
            for (AuthnSelectorInstance selector : selectors) {
                if (!selector.getDescriptor().getType().equals("Extended Property Authentication Selector")) continue;
                String propertyName = selector.getConfiguration().getField("Extended Property").getValue();
                DependencyError error = new DependencyError(selector.getId(), DependencyType.OAUTH_CLIENT_SETTINGS, propertyName, AffectedItemType.AUTHENTICATION_SELECTOR);
                if (extendedParamNames.contains(propertyName)) {
                    existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                    continue;
                }
                if (existingErrors.contains(error)) continue;
                existingErrors.add(error);
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

