/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpAdapterAuthorizationServerSettingValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final AuthzServerManager authzServerMgr = MgmtFactory.getAuthzServerManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (causedByItem instanceof IdpAuthnAdapterInstance) {
            if (UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(authzServerMgr.getAuthzConsentSetting())) {
                IdpAuthnAdapterInstance idpAdapter = (IdpAuthnAdapterInstance)causedByItem;
                if (idpAdapter.getId().equals(authzServerMgr.getExternalConsentAdapterId())) {
                    if (this.isAttributeMissingFromAdapter(idpAdapter, authzServerMgr.getReturnedScopeAttributeName()) || this.isAttributeMissingFromAdapter(idpAdapter, authzServerMgr.getReturnedAuthorizationDetailsAttributeName())) {
                        DependencyError error = new DependencyError(AffectedItemType.AUTH_SERVER_SETTINGS.getFriendlyName(), DependencyType.IDP_ADAPTER, AffectedItemType.AUTH_SERVER_SETTINGS.getFriendlyName(), AffectedItemType.AUTH_SERVER_SETTINGS);
                        if (!existingErrors.contains(error)) {
                            existingErrors.add(error);
                        }
                    } else {
                        existingErrors.removeIf(err -> err.getAffectedInstanceType() == AffectedItemType.AUTH_SERVER_SETTINGS);
                    }
                }
            } else {
                existingErrors.removeIf(err -> err.getAffectedInstanceType() == AffectedItemType.AUTH_SERVER_SETTINGS);
            }
        }
    }

    private boolean isAttributeMissingFromAdapter(IdpAuthnAdapterInstance idpAdapter, String attribute) {
        return StringUtils.isNotBlank((String)attribute) && !idpAdapter.getAttributeContract().getAllAttributeNames().contains(attribute);
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

