/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.validator.IdpAdapterMappingsValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.IdpAdapterMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.SpConnectionAttributeContractTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Arrays;
import java.util.Collection;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpAdapterToConnectionDependencyErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private static final IdpAdapterMappingTranslator mappingTranslator = new IdpAdapterMappingTranslator(new ValidatorContext());
    private static final SpConnectionAttributeContractTranslator attributeContractTranslator = new SpConnectionAttributeContractTranslator();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (!(causedByItem instanceof IdpAuthnAdapterInstance)) {
            return;
        }
        IdpAuthnAdapterInstance adapter = (IdpAuthnAdapterInstance)causedByItem;
        Collection connections = connectionManager.getAllSpConnections();
        for (org.sourceid.saml20.domain.SpConnection spConnection : connections) {
            for (AdapterToAssertionMapping mapping : spConnection.getAdapterMappings()) {
                if (!mapping.getAdapterInstanceId().equals(adapter.getId()) && (mapping.getConnectionOverrideInstance() == null || !mapping.getConnectionOverrideInstance().getParentId().equals(adapter.getId()))) continue;
                SpConnection apiConn = new SpConnection();
                apiConn.setSpBrowserSso(new SpBrowserSso());
                attributeContractTranslator.domainToApi(spConnection, apiConn);
                Protocol protocol = Protocol.valueOf((String)spConnection.getProtocol().name());
                apiConn.getSpBrowserSso().setProtocol(protocol);
                mappingTranslator.domainToApi(Arrays.asList(mapping), apiConn.getSpBrowserSso().getAdapterMappings());
                IdpAdapterMappingsValidator mappingValidator = new IdpAdapterMappingsValidator(apiConn.getSpBrowserSso(), mapping.getRestrictedVirtualServerIds(), new ValidatorContext(true, this.isEaAdmin(), true));
                DependencyError error = new DependencyError(spConnection.getId(), DependencyType.IDP_ADAPTER, adapter.getId(), AffectedItemType.SP_CONN);
                if (mappingValidator.validate()) {
                    existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                    continue;
                }
                if (existingErrors.contains(error)) continue;
                existingErrors.add(error);
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }
}

