/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.oauth.ResourceOwnerCredentialsMapping;
import com.pingidentity.admin.api.validator.OAuthRoCredsMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.oauth.OAuthResourceOwnerCredentialsMappingsTranslator;
import java.util.Collection;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.PluginToUserKeyAttrMapping;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PCVToOAuthROCredMappingsDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        PasswordCredentialValidatorInstance instance = (PasswordCredentialValidatorInstance)causedByItem;
        Collection mappings = this.authzServerManager.getPwdCredValidatorToUserKeyMappings();
        for (PluginToUserKeyAttrMapping mapping : mappings) {
            if (!mapping.getSourcePluginId().equals(instance.getId())) continue;
            OAuthResourceOwnerCredentialsMappingsTranslator translator = new OAuthResourceOwnerCredentialsMappingsTranslator();
            ResourceOwnerCredentialsMapping apiMapping = translator.domainToApi(mapping);
            OAuthRoCredsMappingValidator validator = new OAuthRoCredsMappingValidator(apiMapping, null);
            DependencyError error = new DependencyError(mapping.getSourceId(), DependencyType.PCV, instance.getId(), AffectedItemType.OAUTH_RESOURCE_OWNER_CREDENTIAL_MAPPING);
            if (validator.validate()) {
                existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                continue;
            }
            if (existingErrors.contains(error)) continue;
            existingErrors.add(error);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

